<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-8 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-profile">
                <div class="panel-heading" style="position:relative;background-image:url(<?php echo $user['Profile']['banner']; ?>);">
                    <div class="pull-right" style="position:absolute; right:15px; bottom:15px;">
                        <?php echo $this->Html->link(__('Download vCard'), array('action'=>'vcard', 'ext'=>'vcf', $user['User']['id']), array('class' => 'btn btn-heading', 'escape' => false)); ?>
                    </div>
                    <?php if (($this->Session->read('Auth.User.id') == $user['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons with_bg">
                        <?php echo $this->Html->link('<i class="fa fa-key" title="' . __('Change password') . '"></i>', array('controller'=>'users', 'action'=>'password', $user['User']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit profile') . '"></i>', array('controller'=>'users', 'action'=>'edit', $user['User']['id']), array('escape' => false)); ?>
                        <?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
                            <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'users', 'data-action' => 'delete', 'data-item_id' => $user['User']['id'])); ?>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="user-profile-pic">
                        <a class="colorbox" href="<?php echo $user['Profile']['big_photo']; ?>" title="<?php echo $user['Profile']['name']; ?>">
                            <img src="<?php echo $user['Profile']['photo']; ?>" border="0" width="80" height="80" />
                        </a>
                    </div> 
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <div class="user-stats">
                        <div class="row">
                        <?php
                        if (Configure::read('CFG.users_follow')) {
                            ?>
                            <div class="col-sm-3 col-xs-4 user-stat hidden-xs">
                                <?php echo __('Items'); ?><br>
                                <span class="counter" data-to="<?php echo count($user['News']) + count($user['Event']) + count($user['File']) + count($user['Message']); ?>" data-speed="700"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Following'); ?><br>
                                <span class="counter counter-following" data-to="<?php echo count($user['UserFollow']); ?>" data-speed="700"><?php echo count($user['UserFollow']); ?></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Followers'); ?><br>
                                <span class="counter counter-followers" data-to="<?php echo count($user['UserFollower']); ?>" data-speed="700"><?php echo count($user['UserFollower']); ?></span>
                            </div>
                            <?php if ($user['User']['id'] != $this->Session->read('Auth.User.id')) { ?>
                            <div class="col-sm-3 user-stats-follow">
                                <?php if (in_array($user['User']['id'], $current_user['UserFollow'])) { ?>
                                <button class="btn btn-primary btn-follow active" data-id="<?php echo $user['User']['id']; ?>"><?php echo __('Following'); ?></button>
                                <?php } else { ?>
                                <button class="btn btn-primary btn-follow" data-id="<?php echo $user['User']['id']; ?>"><?php echo __('Follow'); ?></button>
                                <?php } ?>
                            </div>
                            <?php
                            }
                        } else {
                            ?>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('News'); ?><br>
                                <span class="counter" data-to="<?php echo count($user['News']); ?>" data-speed="700"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Events'); ?><br>
                                <span class="counter" data-to="<?php echo count($user['Event']); ?>" data-speed="700"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Files'); ?><br>
                                <span class="counter" data-to="<?php echo count($user['File']); ?>" data-speed="700"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Messages'); ?><br>
                                <span class="counter" data-to="<?php echo count($user['Message']); ?>" data-speed="700"></span>
                            </div>
                            <?php
                        }
                        ?>
                        </div>
                    </div>
                    
                    <div class="pull-right">
                        <div class="social">
                            <?php echo !empty($user['Profile']['linkedin']) ? '<a href="' . $user['Profile']['linkedin'] . '" target="_blank"><i class="fa fa-linkedin" title="' . __('LinkedIn') . '"></i></a>' : null; ?>
                            <?php echo !empty($user['Profile']['twitter']) ? '<a href="' . $user['Profile']['twitter'] . '" target="_blank"><i class="fa fa-twitter" title="' . __('Twitter') . '"></i></a>' : null; ?>
                            <?php echo !empty($user['Profile']['facebook']) ? '<a href="' . $user['Profile']['facebook'] . '" target="_blank"><i class="fa fa-facebook" title="' . __('Facebook') . '"></i></a>' : null; ?>
                        </div>
                    </div>
                    
                    <h2><?php echo $user['Profile']['first_name']; ?> <span class="semi-bold"><?php echo $user['Profile']['last_name']; ?></span></h2>
                    <h3><?php echo isset($user['Profile']['function']) && !empty($user['Profile']['function']) ? $user['Profile']['function'] . ', ' : null; ?> <?php echo $user['Profile']['company']; ?></h3>
                    
                    <ul>
                        <li>
                            <label><?php echo __('Address'); ?></label>
                            <?php echo isset($user['Profile']['address']) && !empty($user['Profile']['address']) ? $user['Profile']['address'] . ', ' : null; ?> <?php echo $user['Profile']['zip']; ?> <?php echo $user['Profile']['city']; ?>
                        </li>
                        <li>
                            <label><?php echo __('Phone number'); ?></label>
                            <?php echo $user['Profile']['phone']; ?>
                        </li>
                        <li>
                            <label><?php echo __('Email address'); ?></label>
                            <?php echo $user['User']['email']; ?>
                        </li>
                    </ul>
                </div>
                <div class="panel-footer">
                    <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-left"></i> ' . __('Back'), $referer, array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-profile">
                <div class="panel-body">
                    <h4><?php echo __('Personal information'); ?></h4>
                    <div class="separator">
                        <label><?php echo __('About me'); ?></label>
                        <?php echo $user['Profile']['references']; ?>
                    </div>
                    <div class="separator">
                        <label><?php echo __('Hobbies'); ?></label>
                        <?php echo $user['Profile']['hobbies']; ?>
                    </div>
                    <div class="separator">
                        <label><?php echo __('Knowledge'); ?></label>
                        <?php echo $user['Profile']['knowledge']; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="msnry animated fadeInUp">
        <?php
        foreach ($items as $item) {
            $modelName = $item['modelName'];
            $controllerlName = $item['controllerName'];
            ?>
            <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 item">
                <div class="panel panel-<?php echo strtolower($modelName); ?>">
                    <div class="panel-heading">
                        <?php if (($this->Session->read('Auth.User.id') == $item['associated']['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                        <div class="icons">
                            <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>strtolower($controllerlName), 'action'=>'edit', $item['id']), array('escape' => false)); ?>
                            <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', array('controller'=>strtolower($controllerlName), 'action'=>'delete', $item['id']), array('escape' => false)); ?>
                        </div>
                        <?php } ?>
                        <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                        <h2><?php echo $item['title']; ?></h2>
                        
                        
                        <div class="profile-wrapper">                        
                            <?php echo $this->Html->link('<img src="' . $item['associated']['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['associated']['User']['id']), array('escape' => false)); ?>
                        </div> 
                        <div class="profile-name">
                            <?php echo $this->Html->link($item['associated']['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['associated']['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['associated']['User']['id']), array('escape' => false)); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-body">
                        <?php
                        if ($modelName == 'News') {
                            echo $this->Text->truncate(
                                $item['content'],
                                300,
                                array(
                                    'ellipsis' => '...',
                                    'exact' => false,
                                    'html' => true
                                )
                            );
                        } elseif ($modelName == 'Event') {
                            ?>
                            <ul>
                                <?php
                                if ($item['start_date'] == $item['end_date']) {
                                    ?>
                                    <li><i class="fa fa-calendar-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['start_date'], null, Configure::read('CFG.timezone')); ?></li>
                                    <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['start_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <li><i class="fa fa-arrow-left fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['end_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <?php
                                } else {
                                    ?>
                                    <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['start_date'], null, Configure::read('CFG.timezone')); ?> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['start_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['end_date'], null, Configure::read('CFG.timezone')); ?> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['end_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <?php
                                }
                                ?>
                                <?php if ($item['location']) { ?>
                                <li><i class="fa fa-location-arrow fa-fw"></i> <a href="https://www.google.com/maps/dir//<?php echo str_replace(' ', '+', $item['location']); ?>" target="_blank"><?php echo $item['location']; ?></a></li>
                                <?php } ?>
                            </ul>
                            <?php
                            echo $this->Text->truncate(
                                $item['content'],
                                100,
                                array(
                                    'ellipsis' => '...',
                                    'exact' => false,
                                    'html' => true
                                )
                            );
                        } elseif ($modelName == 'File') {
                            echo $this->Text->truncate(
                                $item['content'],
                                200,
                                array(
                                    'ellipsis' => '...',
                                    'exact' => false,
                                    'html' => true
                                )
                            );
                            ?>
                            <ul class="files">
                                <?php
                                foreach ($item['associated']['FileAttachment'] as $file) {
                                    $filename = explode('/', $file['file']);
                                    ?>
                                    <li><a href="<?php echo $file['file']; ?>" target="_blank"><?php echo wordwrap(end($filename), 30, "-<br>\n", true); ?></a></li>
                                    <?php
                                } 
                                ?>
                            </ul>
                            <?php
                        } elseif ($modelName == 'Message') {
                            ?>
                            <div class="separator">
                                <p><?php echo $this->Text->truncate(
                                    $item['content'],
                                    200,
                                    array(
                                        'ellipsis' => '...',
                                        'exact' => false,
                                        'html' => true
                                    )
                                ); ?></p>
                            </div>
                            <?php
                            $i = 0;
                            foreach ($item['associated']['MessageComment'] as $comment) {
                                if ($i == 2) {
                                    break;
                                }
                                ?>
                                <div class="separator">
                                    <div class="profile-wrapper">
                                        <?php echo $this->Html->link('<img src="' . $comment['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                                    </div> 
                                    <div class="profile-name">
                                        <?php echo $this->Html->link($comment['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $comment['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                                    </div>
                                    <div class="clearfix"></div>
                                    <small>
                                        <i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $comment['created'], null, Configure::read('CFG.timezone')); ?>
                                    </small>
                                    <p><?php echo $this->Text->truncate(
                                        $comment['content'],
                                        100,
                                        array(
                                            'ellipsis' => '...',
                                            'exact' => false,
                                            'html' => true
                                        )
                                    ); ?></p>
                                </div>
                                <?php
                                $i++;
                            }
    
                            if (count($item['associated']['MessageComment']) != $i) {
                                ?>
                                <div class="separator">
                                    <p>...</p>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <div class="panel-footer">
                        <div class="icons">
                            <?php echo $this->Html->link('<i class="fa fa-fw fa-comment" title="' . __('Comments') . '"></i> ' . count($item['associated'][$modelName.'Comment']), array('controller'=>strtolower($controllerlName), 'action'=>'view', $item['id'], '#'=>'comments'), array('escape' => false)); ?>
                            <?php 
                            if ($modelName == 'Event') {
                                echo '<i class="fa fa-fw fa-thumbs-up" title="' . __('Present') . '"></i> ' . count($item['associated']['EventAttendeePresent']);
                                echo '<i class="fa fa-fw fa-thumbs-down" title="' . __('Absent') . '"></i> ' . count($item['associated']['EventAttendeeAbsent']);
                            } 
                            ?>
                        </div>
                        <div class="pull-right">
                            <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-right"></i> ' . __('More info'), array('controller'=>strtolower($controllerlName), 'action'=>'view', $item['id']), array('class' => 'btn btn-primary', 'escape' => false)); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    msnry();
});

function msnry() {
    $('.msnry').imagesLoaded(function() {
        $('.msnry').masonry({
            itemSelector  : '.item',
            columnWidth   : '.item',
            isAnimated    : true
        });
    });
}
</script>