<div class="container animated fadeInUp">
    <div class="row">  
        <div class="col-md-7 col-md-offset-2 no-padding">
            <div class="row wrapper">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 white">
                    <h1 class="normal"><?php echo (Configure::read('CFG.users_register') ? __('Sign Up') : __('Request account')); ?></h1>
                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
                    <p><?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-left"></i> ' . __('Login'), array('controller'=>'users', 'action'=>'login'), array('class' => 'btn btn-info', 'escape' => false)); ?></p>
                </div>

                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 grey">
                    <?php
                    echo $this->Session->flash(); 
                    echo $this->Session->flash('auth');
                    ?>
                    <form method="post" id="UserRegisterForm" action="/users/register">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                <input type="text" name="data[Profile][first_name]" id="ProfileFirstName" class="form-control" placeholder="<?php echo __('First Name'); ?>" />
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                <input type="text" name="data[Profile][last_name]" id="ProfileLastName" class="form-control" placeholder="<?php echo __('Last Name'); ?>" />
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <input type="text" name="data[User][email]" id="UserEmail" class="form-control" placeholder="<?php echo __('Email address'); ?>" />
                            </div>
                            <?php
                            if (Configure::read('CFG.users_register')) {
                                ?>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                    <input type="password" name="data[User][password]" id="UserPassword" class="form-control" placeholder="<?php echo __('Password'); ?>" />
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                    <label for="UserSettingLanguage"><?php echo __('Language'); ?></label>
                                    <select name="data[UserSetting][language]" id="UserSettingLanguage" class="form-control">
                                        <?php
                                        foreach($languages as $key => $val) {
                                            ?>
                                            <option value="<?php echo $key; ?>" <?php echo Configure::read('CFG.language') == $key ? ' selected' : null; ?>><?php echo $val; ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                    <label for="UserSettingTimezone"><?php echo __('Time zone'); ?></label>
                                    <select name="data[UserSetting][timezone]" id="UserSettingTimezone" class="form-control">
                                        <?php
                                        $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                                        foreach($timezones as $timezone) {
                                            ?>
                                            <option value="<?php echo $timezone; ?>" <?php echo Configure::read('CFG.timezone') == $timezone ? ' selected' : null; ?>><?php echo $timezone; ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <?php
                            }
                            ?>
                            <div class="col-md-12 form-row">
                                <div class="pull-right">
                                    <button type="submit" class="btn btn-primary"><i class="fa fa-arrow-circle-o-right"></i> <?php echo (Configure::read('CFG.users_register') ? __('Sign Up') : __('Request account')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {    
    $("#UserRegisterForm").validate({
        rules: {
            'data[Profile][first_name]': {
                required: true
            },
            'data[Profile][last_name]': {
                required: true
            },
            'data[User][email]': {
                required: true,
                email: true
            }
            <?php if (Configure::read('CFG.users_register')) { ?>
            , 'data[User][password]': {
                required: true,
                minlength: 6
            }
            <?php } ?>
        }
    });
});
</script>