<div class="row">
    <div class="msnry animated fadeInUp">
        <?php foreach ($users->data as $item) { ?>
        <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-profile">
                <div class="panel-heading" style="background-image:url(<?php echo $item['Profile']['banner']; ?>);">
                    <?php if (($this->Session->read('Auth.User.id') == $item['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons with_bg">
                        <?php echo $this->Html->link('<i class="fa fa-key" title="' . __('Change password') . '"></i>', array('controller'=>'users', 'action'=>'password', $item['User']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit profile') . '"></i>', array('controller'=>'users', 'action'=>'edit', $item['User']['id']), array('escape' => false)); ?>
                        <?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'users', 'data-action' => 'delete', 'data-item_id' => $item['User']['id'])); ?>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    
                    <div class="user-profile-pic">
                        <img src="<?php echo $item['Profile']['photo']; ?>" width="80" height="80" />
                    </div> 
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <div class="user-stats">
                        <div class="row">
                        <?php
                        if (Configure::read('CFG.users_follow')) {
                            ?>
                            <div class="col-sm-3 col-xs-4 user-stat hidden-xs">
                                <?php echo __('Items'); ?><br>
                                <span class="counter" data-to="<?php echo count($item['News']) + count($item['Event']) + count($item['File']) + count($item['Message']); ?>" data-speed="700"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Following'); ?><br>
                                <span class="counter counter-following" data-to="<?php echo count($item['UserFollow']); ?>" data-speed="500"><?php echo count($item['UserFollow']); ?></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Followers'); ?><br>
                                <span class="counter counter-followers" data-to="<?php echo count($item['UserFollower']); ?>" data-speed="500"><?php echo count($item['UserFollower']); ?></span>
                            </div>
                            <?php if ($item['User']['id'] != $this->Session->read('Auth.User.id')) { ?>
                            <div class="col-sm-3 user-stats-follow">
                                <?php if (in_array($item['User']['id'], $current_user['UserFollow'])) { ?>
                                <button class="btn btn-primary btn-follow active" data-id="<?php echo $item['User']['id']; ?>"><?php echo __('Following'); ?></button>
                                <?php } else { ?>
                                <button class="btn btn-primary btn-follow" data-id="<?php echo $item['User']['id']; ?>"><?php echo __('Follow'); ?></button>
                                <?php } ?>
                            </div>
                            <?php
                            }
                        } else {
                            ?>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('News'); ?><br>
                                <span class="counter" data-to="<?php echo count($item['News']); ?>" data-speed="500"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Events'); ?><br>
                                <span class="counter" data-to="<?php echo count($item['Event']); ?>" data-speed="500"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Files'); ?><br>
                                <span class="counter" data-to="<?php echo count($item['File']); ?>" data-speed="500"></span>
                            </div>
                            <div class="col-sm-3 col-xs-6 user-stat">
                                <?php echo __('Messages'); ?><br>
                                <span class="counter" data-to="<?php echo count($item['Message']); ?>" data-speed="500"></span>
                            </div>
                            <?php
                        }
                        ?>
                        </div>
                    </div>
                    
                    <div class="pull-right">
                        <div class="social">
                            <?php echo !empty($item['Profile']['linkedin']) ? '<a href="' . $item['Profile']['linkedin'] . '" target="_blank"><i class="fa fa-linkedin" title="' . __('LinkedIn') . '"></i></a>' : null; ?>
                            <?php echo !empty($item['Profile']['twitter']) ? '<a href="' . $item['Profile']['twitter'] . '" target="_blank"><i class="fa fa-twitter" title="' . __('Twitter') . '"></i></a>' : null; ?>
                            <?php echo !empty($item['Profile']['facebook']) ? '<a href="' . $item['Profile']['facebook'] . '" target="_blank"><i class="fa fa-facebook" title="' . __('Facebook') . '"></i></a>' : null; ?>
                        </div>
                    </div>
                    
                    <h2><?php echo $item['Profile']['first_name']; ?> <span class="semi-bold"><?php echo $item['Profile']['last_name']; ?></span></h2>
                    <h3><?php echo isset($item['Profile']['function']) && !empty($item['Profile']['function']) ? $item['Profile']['function'] . ', ' : null; ?> <?php echo $item['Profile']['company']; ?></h3>
                    <ul>
                        <li>
                            <label><?php echo __('Address'); ?></label>
                            <?php echo isset($item['Profile']['address']) && !empty($item['Profile']['address']) ? $item['Profile']['address'] . ', ' : null; ?> <?php echo $item['Profile']['zip']; ?> <?php echo $item['Profile']['city']; ?>
                        </li>
                        <li>
                            <label><?php echo __('Phone number'); ?></label>
                            <?php echo $item['Profile']['phone']; ?>
                        </li>
                        <li>
                            <label><?php echo __('Email address'); ?></label>
                            <?php echo $item['User']['email']; ?>
                        </li>
                    </ul>
                </div>
                <div class="panel-footer">
                    <div class="pull-right">
                        <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-right"></i> ' . __('View profile'), array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

<?php
if(count($users->numbers) > 1) {
    ?>
    <div class="row">
        <div class="col-xs-12 text-center paginate">
            <hr class="colered">
            <ul class="pagination">
            <?php
            foreach($users->numbers as $num) {
                $url = '/users/?p=' . $num;
                
                if((isset($_GET['p']) && $num == $_GET['p']) || ($num == 1 && !isset($_GET['p']))) {
                    echo '<li class="active"><a href="'.$url.'">'.$num.'</a></li>';
                }else{
                    echo '<li><a href="'.$url.'">'.$num.'</a></li>';
                }
            }
            ?>
            </ul>
        </div>
    </div>
    <?php
}
?>