<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-main panel-form">
                <div class="panel-heading">
                    <h1><i class="fa fa-user fa-fw"></i> <?php echo __('Edit Profile'); ?></h1>
                </div>
                
                <div class="panel-body content">
                    <form id="UserEditForm" action="/users/edit/<?php echo $user['User']['id']; ?>" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3><?php echo __('Personal information'); ?></h3>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFirstName"><?php echo __('First name'); ?></label>
                            <input name="data[Profile][first_name]" id="ProfileFirstName" type="text" class="form-control" value="<?php echo $user['Profile']['first_name'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileLastName"><?php echo __('Last name'); ?></label>
                            <input name="data[Profile][last_name]" id="ProfileLastName" type="text" class="form-control" value="<?php echo $user['Profile']['last_name'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileCompany"><?php echo __('Company'); ?></label>
                            <input name="data[Profile][company]" id="ProfileCompany" type="text" class="form-control" value="<?php echo $user['Profile']['company'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFunction"><?php echo __('Function'); ?></label>
                            <input name="data[Profile][function]" id="ProfileFunction" type="text" class="form-control" value="<?php echo $user['Profile']['function'] ?>" />
                        </div>
                        <?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFirstName">Type</label>
                            <select name="data[User][role]" id="UserRole" class="form-control">
                                <option value="user"<?php echo $user['User']['role'] == 'user' ? ' selected="selected"' : null; ?>><?php echo __('User'); ?></option>
                                <option value="admin"<?php echo $user['User']['role'] == 'admin' ? ' selected="selected"' : null; ?>><?php echo __('Administrator'); ?></option>
                            </select>
                        </div>
                        <?php } ?>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3><?php echo __('Contact information'); ?></h3>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileAddress"><?php echo __('Street'); ?></label>
                            <input name="data[Profile][address]" id="ProfileAddress" type="text" class="form-control" value="<?php echo $user['Profile']['address'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                             <label for="ProfileCity"><?php echo __('City'); ?></label>
                            <input name="data[Profile][city]" id="ProfileCity" type="text" class="form-control" value="<?php echo $user['Profile']['city'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileZip"><?php echo __('ZIP/Postal Code'); ?></label>
                            <input name="data[Profile][zip]" id="ProfileZip" type="text" class="form-control" value="<?php echo $user['Profile']['zip'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileCountry"><?php echo __('Country'); ?></label>
                            <input name="data[Profile][country]" id="ProfileCountry" type="text" class="form-control" value="<?php echo $user['Profile']['country'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfilePhone"><?php echo __('Phone number'); ?></label>
                            <input name="data[Profile][phone]" id="ProfilePhone" type="text" class="form-control inputmask" value="<?php echo $user['Profile']['phone'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="UserEmail"><?php echo __('Email address'); ?></label>
                            <input name="data[User][email]" id="UserEmail" type="text" class="form-control" value="<?php echo $user['User']['email'] ?>" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3><?php echo __('Accounts'); ?></h3>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileLinkedin"><?php echo __('LinkedIn'); ?></label>
                            <input name="data[Profile][linkedin]" id="ProfileLinkedin" type="text" class="form-control" value="<?php echo $user['Profile']['linkedin'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileTwitter"><?php echo __('Twitter'); ?></label>
                            <input name="data[Profile][twitter]" id="ProfileTwitter" type="text" class="form-control" value="<?php echo $user['Profile']['twitter'] ?>" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFacebook"><?php echo __('Facebook'); ?></label>
                            <input name="data[Profile][facebook]" id="ProfileFacebook" type="text" class="form-control" value="<?php echo $user['Profile']['facebook'] ?>" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3><?php echo __('Footage'); ?></h3>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-4 col-xs-12 form-row">
                            <label for="ProfilePhoto"><?php echo __('Profile photo'); ?></label>
                            <div class="fileinput fileinput-<?php echo !empty($user['Profile']['photo']) ? 'exists' : 'new';?>" data-provides="fileinput">
                              <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 120px; height: 120px;">
                                  <?php echo !empty($user['Profile']['photo']) ? '<img src="' . $user['Profile']['photo'] . '" />' : null;?>
                              </div>
                              <div>
                                <span class="btn btn-default btn-file"><span class="fileinput-new" data-trigger="fileinput"><?php echo __('Select photo'); ?></span><span class="fileinput-exists" data-trigger="fileinput"><?php echo __('Edit'); ?></span><input type="file" name="data[Profile][photo]" id="ProfilePhoto" /></span>
                              </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-4 col-xs-12 form-row">
                            <label for="ProfileBanner"><?php echo __('Cover photo'); ?></label>
                            <div class="fileinput fileinput-<?php echo !empty($user['Profile']['banner']) ? 'exists' : 'new';?>" data-provides="fileinput">
                              <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 160px; height: 120px;">
                                  <?php echo !empty($user['Profile']['banner']) ? '<img src="' . $user['Profile']['banner'] . '" />' : null;?>
                              </div>
                              <div>
                                <span class="btn btn-default btn-file"><span class="fileinput-new" data-trigger="fileinput"><?php echo __('Select photo'); ?></span><span class="fileinput-exists" data-trigger="fileinput"><?php echo __('Edit'); ?></span><input type="file" name="data[Profile][banner]" id="ProfileBanner" /></span>
                              </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3>Other</h3>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileReferences"><?php echo __('About me'); ?></label>
                            <textarea name="data[Profile][references]" id="ProfileReferences" class="form-control wysiwyg"><?php echo $user['Profile']['references'] ?></textarea>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileHobbies"><?php echo __('Hobbies'); ?></label>
                            <textarea name="data[Profile][hobbies]" id="ProfileHobbies" class="form-control wysiwyg"><?php echo $user['Profile']['hobbies'] ?></textarea>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileKnowledge"><?php echo __('Knowledge'); ?></label>
                            <textarea name="data[Profile][knowledge]" id="ProfileKnowledge" class="form-control wysiwyg"><?php echo $user['Profile']['knowledge'] ?></textarea>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-right form-row">
                            <button type="button" class="btn btn-warning" onclick="window.location='<?php echo $referer; ?>';"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save'); ?></button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {    
    $("#UserEditForm").validate({
        rules: {
            'data[Profile][first_name]': {
                required: true
            },
            'data[Profile][last_name]': {
                required: true
            },
            'data[Profile][address]': {
                required: true
            },
            'data[Profile][zip]': {
                required: true
            },
            'data[Profile][city]': {
                required: true
            },
            'data[Profile][country]': {
                required: true
            },
            'data[Profile][phone]': {
                required: true
            },
            'data[User][email]': {
                required: true,
                email: true
            }
        }
    });
});
</script>