<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-main panel-form">
                <div class="panel-heading">
                    <h1><i class="fa fa-user fa-fw"></i> <?php echo __('Add Member'); ?></h1>
                </div>
                
                <div class="panel-body content">
                    <form id="UserAddForm" action="/users/add" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3><?php echo __('Login'); ?></h3>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFirstName"><?php echo __('Email address'); ?></label>
                            <input name="data[User][email]" id="UserEmail" type="text" class="form-control" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFirstName"><?php echo __('Password'); ?></label>
                            <div class="input-group">
                                <input name="data[User][password]" id="UserPassword" type="text" class="form-control" />
                                <span class="input-group-btn">
                                    <button class="btn btn-input" type="button" id="UserPasswordGenerate" title="<?php echo __('Generate'); ?>"><i class="fa fa-refresh pointer"></i></button>
                                </span>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFirstName"><?php echo __('Type'); ?></label>
                            <select name="data[User][role]" id="UserRole" class="form-control">
                                <option value="user"><?php echo __('User'); ?></option>
                                <option value="admin"><?php echo __('Administrator'); ?></option>
                            </select>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <h3><?php echo __('Personal information'); ?></h3>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileFirstName"><?php echo __('First name'); ?></label>
                            <input name="data[Profile][first_name]" id="ProfileFirstName" type="text" class="form-control" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="ProfileLastName"><?php echo __('Last name'); ?></label>
                            <input name="data[Profile][last_name]" id="ProfileLastName" type="text" class="form-control" />
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="UserSettingLanguage"><?php echo __('Language'); ?></label>
                            <select name="data[UserSetting][language]" id="UserSettingLanguage" class="form-control">
                                <?php
                                foreach($languages as $key => $val) {
                                    ?>
                                    <option value="<?php echo $key; ?>" <?php echo Configure::read('CFG.language') == $key ? ' selected' : null; ?>><?php echo $val; ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                            <label for="UserSettingTimezone"><?php echo __('Time zone'); ?></label>
                            <select name="data[UserSetting][timezone]" id="UserSettingTimezone" class="form-control">
                                <?php
                                $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                                foreach($timezones as $timezone) {
                                    ?>
                                    <option value="<?php echo $timezone; ?>" <?php echo Configure::read('CFG.timezone') == $timezone ? ' selected' : null; ?>><?php echo $timezone; ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-lg-5 col-md-12 col-sm-12 col-xs-12 form-row">
                            <div class="control-group">
                                <div class="checkbox check-form"> 
                                    <input type="checkbox" name="data[User][notify]" id="UserNotify" value="1" checked="checked">
                                    <label for="UserNotify"><?php echo __('Send email with login information'); ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-right form-row">
                            <button type="button" class="btn btn-warning"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save'); ?></button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$('#UserPasswordGenerate').click(function() {
    $('#UserPassword').val($.password(8));
});

$(document).ready(function() {    
    $("#UserAddForm").validate({
        rules: {
            'data[User][email]': {
                required: true,
                email: true
            },
            'data[User][password]': {
                required: true,
                minlength: 6
            },
            'data[Profile][first_name]': {
                required: true
            },
            'data[Profile][last_name]': {
                required: true
            }
        }
    });
});
</script>