<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="panel panel-news">
                <div class="panel-heading">
                    <?php if (($this->Session->read('Auth.User.id') == $item['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons">
                        <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'news', 'action'=>'edit', $item['News']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'news', 'data-action' => 'delete', 'data-item_id' => $item['News']['id'])); ?>
                    </div>
                    <?php } ?>
                    <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['News']['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['News']['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                    <h2><?php echo $item['News']['title']; ?></h2>
                    
                    <div class="profile-wrapper">                        
                        <?php echo $this->Html->link('<img src="' . $item['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div> 
                    <div class="profile-name">
                        <?php echo $this->Html->link($item['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <?php echo $item['News']['content']; ?>
                </div>
                <div class="panel-footer">
                    <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-left"></i> ' . __('Back'), $referer, array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    <div class="pull-right">
                        <?php echo $this->Html->link('<i class="fa fa-comment"></i> ' . __('Add comment'), array('controller'=>'news', 'action'=>'view', $item['News']['id'], '#'=>'comment'), array('class'=>'btn btn-primary btn-comment', 'escape'=>false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<a name="comment"></a>
<div class="row row-comment" style="display:none;">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="panel panel-main panel-form">
            <div class="panel-body ">
                <form action="/news/comment/<?php echo $item['News']['id']; ?>" method="post">
                <fieldset>
                    <ul>
                        <li>
                            <label for="NewsContent"><?php echo __('Comment'); ?></label>
                            <textarea name="data[NewsComment][content]" id="CommentContent" class="form-control wysiwyg"></textarea>
                        </li>
                        <li class="submit">
                            <input name="data[NewsComment][id]" id="CommentId" type="hidden" value="" />
                            <button type="reset" class="btn btn-warning btn-comment-cancel"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save comment'); ?></button>
                        </li>
                    </ul>
                </fieldset>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if (count($item['NewsComment']) > 0) { ?>
<a name="comments"></a>
<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="panel panel-news panel-comment">
                <div class="panel-body">
                    <h2><?php echo __('Comments'); ?></h2>
                    <?php 
                    foreach ($item['NewsComment'] as $comment) {
                        ?>
                        <div class="separator">
                            <?php if (($this->Session->read('Auth.User.id') == $comment['user_id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                            <div class="icons pull-right">
                                <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'news', 'action'=>'view', $item['News']['id'], '#'=>'comment'), array('class'=>'btn-comment-edit', 'data-id'=>$comment['id'], 'escape'=>false)); ?>
                                <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'news', 'data-action' => 'comment_delete', 'data-item_id' => $comment['id'])); ?>
                            </div>
                            <?php } ?>
                            <div class="profile-wrapper">
                                <?php echo $this->Html->link('<img src="' . $comment['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                            </div> 
                            <div class="profile-name">
                                <?php echo $this->Html->link($comment['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $comment['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>

                            </div>
                            <div class="clearfix"></div>
                            <small class="datetime">
                                <i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $comment['created'], null, Configure::read('CFG.timezone')); ?>
                            </small>
                            <div class="clearfix"></div>
                            <div class="comment-content">
                                <?php echo $comment['content']; ?>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>