<div class="row">
    <div class="msnry animated fadeInUp">
        <?php foreach ($items->data as $item) { ?>
        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 item">
            <div class="panel panel-news">
                <div class="panel-heading">
                    <?php if (($this->Session->read('Auth.User.id') == $item['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons">
                        <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'news', 'action'=>'edit', $item['News']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'news', 'data-action' => 'delete', 'data-item_id' => $item['News']['id'])); ?>
                    </div>
                    <?php } ?>
                    <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['News']['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['News']['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                    <h2><?php echo $item['News']['title']; ?></h2>
                    
                    <div class="profile-wrapper">                        
                        <?php echo $this->Html->link('<img src="' . $item['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div> 
                    <div class="profile-name">
                        <?php echo $this->Html->link($item['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <?php echo $this->Text->truncate(
                        $item['News']['content'],
                        250,
                        array(
                            'ellipsis' => '...',
                            'exact' => false,
                            'html' => true
                        )
                    ); ?>
                </div>
                <div class="panel-footer">
                    <div class="icons">
                        <?php echo $this->Html->link('<i class="fa fa-comment" title="' . __('Comments') . '"></i> ' . count($item['NewsComment']), array('controller'=>'news', 'action'=>'view', $item['News']['id'], '#'=>'comments'), array('escape' => false)); ?>
                    </div>
                    <div class="pull-right">
                        <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-right"></i> ' . __('More info'), array('controller'=>'news', 'action'=>'view', $item['News']['id']), array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

<?php
if(count($items->numbers) > 1) {
    ?>
    <div class="row">
        <div class="col-xs-12 text-center paginate">
            <hr class="colered">
            <ul class="pagination">
            <?php
            foreach($items->numbers as $num) {
                $url = '/news/?p=' . $num;
                
                if((isset($_GET['p']) && $num == $_GET['p']) || ($num == 1 && !isset($_GET['p']))) {
                    echo '<li class="active"><a href="'.$url.'">'.$num.'</a></li>';
                }else{
                    echo '<li><a href="'.$url.'">'.$num.'</a></li>';
                }
            }
            ?>
            </ul>
        </div>
    </div>
    <?php
}
?>

<script type="text/javascript">
$(document).ready(function() {
    msnry();
});

function msnry() {
    $('.msnry').imagesLoaded(function() {
        $('.msnry').masonry({
            itemSelector  : '.item',
            columnWidth   : '.item',
            isAnimated    : true
        });
    });
}
</script>