<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-message panel-form">
                <div class="panel-heading">
                    <h1><i class="fa fa-comments-o fa-fw"></i> <?php echo __('Add Message'); ?></h1>
                </div>
                
                <div class="panel-body content">
                    <form id="MessageAddForm" action="/messages/add" method="post">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="MessageTitle"><?php echo __('Subject'); ?></label>
                            <input name="data[Message][title]" id="MessageTitle" type="text" class="form-control" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="MessageContent"><?php echo __('Message'); ?></label>
                            <textarea name="data[Message][content]" id="MessageContent" class="form-control wysiwyg" style="height:200px;"></textarea>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 form-row">
                            <div class="control-group">
                                <div class="checkbox check-form"> 
                                    <input type="checkbox" name="data[Message][notify]" id="MessageNotify" value="1" checked="checked">
                                    <label for="MessageNotify"><?php echo (Configure::read('CFG.users_follow')) ? __('Notify followers') : __('Notify other members'); ?></label>
                                </div>
                            </div>
                        </div>
                        <?php
                        if ($this->Session->read('Auth.User.role') == 'admin') {
                        ?>
                        <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 form-row">
                            <div class="control-group">
                                <div class="checkbox check-form"> 
                                    <input type="checkbox" name="data[Message][admin]" id="MessageAdmin" value="1">
                                    <label for="MessageAdmin"><?php echo __('Only available for administrators'); ?></label>
                                </div>
                            </div>
                        </div>
                        <?php
                        }
                        ?>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-right form-row">
                            <button type="reset" class="btn btn-warning" onclick="window.location='<?php echo $referer; ?>';"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save'); ?></button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {    
    $("#MessageAddForm").validate({
        rules: {
            'data[Message][title]': {
                required: true
            }
        }
    });
});
</script>