<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <!-- BEGIN WEBAPP -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="<?php echo Configure::read('CFG.site_short_name'); ?>">
    <meta name="format-detection" content="telephone=no">
    
    <!-- ICONS -->
    <!-- iOS 7 iPad (retina) -->
    <link href="/assets/images/apple-touch/icon-152x152.png" sizes="152x152" rel="apple-touch-icon">
     <!-- iOS 6 iPad (retina) -->
    <link href="/assets/images/apple-touch/icon-144x144.png" sizes="144x144" rel="apple-touch-icon">
    <!-- iOS 7 iPhone (retina) -->
    <link href="/assets/images/apple-touch/icon-120x120.png" sizes="120x120" rel="apple-touch-icon">
    <!-- iOS 6 iPhone (retina) -->
    <link href="/assets/images/apple-touch/icon-114x114.png" sizes="114x114" rel="apple-touch-icon">
    <!-- iOS 7 iPad -->
    <link href="/assets/images/apple-touch/icon-76x76.png" sizes="76x76" rel="apple-touch-icon">
    <!-- iOS 6 iPad -->
    <link href="/assets/images/apple-touch/icon-72x72.png" sizes="72x72" rel="apple-touch-icon">
    <!-- iOS 6 iPhone -->
    <link href="/assets/images/apple-touch/icon-57x57.png" sizes="57x57" rel="apple-touch-icon">
    
    <!-- STARTUP IMAGES -->
    <!-- iOS 6 & 7 iPad (retina, portrait) -->
    <link href="/assets/images/apple-touch/startup-image-1536x2008.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: portrait)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 & 7 iPad (retina, landscape) -->
    <link href="/assets/images/apple-touch/startup-image-1496x2048.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: landscape)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 iPad (portrait) -->
    <link href="/assets/images/apple-touch/startup-image-768x1004.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: portrait)
             and (-webkit-device-pixel-ratio: 1)">

    <!-- iOS 6 iPad (landscape) -->
    <link href="/assets/images/apple-touch/startup-image-748x1024.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: landscape)
             and (-webkit-device-pixel-ratio: 1)">

    <!-- iOS 6 & 7 iPhone 5 -->
    <link href="/assets/images/apple-touch/startup-image-640x1096.png" rel="apple-touch-startup-image"
          media="(device-width: 320px) and (device-height: 568px)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 & 7 iPhone (retina) -->
    <link href="/assets/images/apple-touch/startup-image-640x920.png" rel="apple-touch-startup-image"
          media="(device-width: 320px) and (device-height: 480px)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 iPhone -->
    <link href="/assets/images/apple-touch/startup-image-320x460.png" rel="apple-touch-startup-image"
          media="(device-width: 320px) and (device-height: 480px)
             and (-webkit-device-pixel-ratio: 1)">
    <!-- END WEBAPP -->
    
    <title><?php echo $title_for_layout; ?> | <?php echo Configure::read('CFG.site_title'); ?></title>
    
    <!-- BEGIN CORE FRAMEWORK CSS -->
    <link rel="stylesheet" type="text/css" href="/assets/plugins/ui/css/flat/jquery-ui-1.10.4.custom.css" />
    <link rel="stylesheet" type="text/css" href="/assets/plugins/bootstrap/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/jasny-bootstrap/css/jasny-bootstrap.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/vertical-timeline/component.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/fullcalendar/fullcalendar.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/datepicker/css/datepicker3.css">
    <!-- END CORE FRAMEWORK CSS -->
    
    <!-- BEGIN TEMPLATE CSS -->
    <link rel="stylesheet" type="text/css" href="/assets/css/animate.min.css" />
    <link rel="stylesheet" type="text/css" href="/assets/css/home.css?v=1">
    <!-- END TEMPLATE CSS -->
    
    <!-- BEGIN PAGE LEVEL CSS -->
    <!-- END PAGE LEVEL CSS -->
    
    <!-- BEGIN CORE FRAMEWORK JS -->
    <script type="text/javascript" src="/assets/plugins/jquery/jquery-1.11.0.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/ui/js/jquery-ui-1.10.4.custom.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/standalone/standalone.js"></script>
    <script type="text/javascript" src="/assets/plugins/touch-punch/jquery.ui.touch-punch.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/bootstrap/js/tab.js"></script>
    <script type="text/javascript" src="/assets/plugins/jasny-bootstrap/js/jasny-bootstrap.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/imagesloaded/imagesloaded.pkgd.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/masonry/masonry.pkgd.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script type="text/javascript" src="/assets/plugins/tinymce/tinymce.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/moment/moment-with-langs.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/fullcalendar/fullcalendar.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/fullcalendar/lang/nl.js"></script>
    <script type="text/javascript" src="/assets/plugins/password/password.js"></script>
    <script type="text/javascript" src="/assets/plugins/datepicker/js/bootstrap-datepicker.js"></script>
    <!-- END CORE FRAMEWORK JS -->
    
    
    
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
    <!-- Fixed navbar -->
    <div class="navbar navbar-default navbar-fixed-top">
      <div class="container">
        <div class="navbar-header">
          <span class="navbar-brand"><i class="fa fa-cubes"></i> <?php echo Configure::read('CFG.site_name'); ?></span>
        </div>
        
          <ul class="nav navbar-nav navbar-right">
            <li><a href="/users/login"><?php echo __('Login') ?></a></li>
            <li><a href="/users/register"><?php echo (Configure::read('CFG.users_register') ? __('Sign Up') : __('Request account')) ?></a></li>
          </ul>
      </div>
    </div>

    <?php echo $this->fetch('content'); ?>
    
    <!-- BEGIN PAGE LEVEL JS -->

    <!-- END PAGE LEVEL JS -->
</body>
</html>