<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <!-- BEGIN WEBAPP -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="<?php echo Configure::read('CFG.site_short_name'); ?>">
    <meta name="format-detection" content="telephone=no">
    
    <!-- ICONS -->
    <!-- iOS 7 iPad (retina) -->
    <link href="/assets/images/apple-touch/icon-152x152.png" sizes="152x152" rel="apple-touch-icon">
     <!-- iOS 6 iPad (retina) -->
    <link href="/assets/images/apple-touch/icon-144x144.png" sizes="144x144" rel="apple-touch-icon">
    <!-- iOS 7 iPhone (retina) -->
    <link href="/assets/images/apple-touch/icon-120x120.png" sizes="120x120" rel="apple-touch-icon">
    <!-- iOS 6 iPhone (retina) -->
    <link href="/assets/images/apple-touch/icon-114x114.png" sizes="114x114" rel="apple-touch-icon">
    <!-- iOS 7 iPad -->
    <link href="/assets/images/apple-touch/icon-76x76.png" sizes="76x76" rel="apple-touch-icon">
    <!-- iOS 6 iPad -->
    <link href="/assets/images/apple-touch/icon-72x72.png" sizes="72x72" rel="apple-touch-icon">
    <!-- iOS 6 iPhone -->
    <link href="/assets/images/apple-touch/icon-57x57.png" sizes="57x57" rel="apple-touch-icon">
    
    <!-- STARTUP IMAGES -->
    <!-- iOS 6 & 7 iPad (retina, portrait) -->
    <link href="/assets/images/apple-touch/startup-image-1536x2008.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: portrait)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 & 7 iPad (retina, landscape) -->
    <link href="/assets/images/apple-touch/startup-image-1496x2048.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: landscape)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 iPad (portrait) -->
    <link href="/assets/images/apple-touch/startup-image-768x1004.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: portrait)
             and (-webkit-device-pixel-ratio: 1)">

    <!-- iOS 6 iPad (landscape) -->
    <link href="/assets/images/apple-touch/startup-image-748x1024.png" rel="apple-touch-startup-image"
          media="(device-width: 768px) and (device-height: 1024px)
             and (orientation: landscape)
             and (-webkit-device-pixel-ratio: 1)">

    <!-- iOS 6 & 7 iPhone 5 -->
    <link href="/assets/images/apple-touch/startup-image-640x1096.png" rel="apple-touch-startup-image"
          media="(device-width: 320px) and (device-height: 568px)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 & 7 iPhone (retina) -->
    <link href="/assets/images/apple-touch/startup-image-640x920.png" rel="apple-touch-startup-image"
          media="(device-width: 320px) and (device-height: 480px)
             and (-webkit-device-pixel-ratio: 2)">

    <!-- iOS 6 iPhone -->
    <link href="/assets/images/apple-touch/startup-image-320x460.png" rel="apple-touch-startup-image"
          media="(device-width: 320px) and (device-height: 480px)
             and (-webkit-device-pixel-ratio: 1)">
    <!-- END WEBAPP -->
    
    <title><?php echo $title_for_layout; ?> | <?php echo Configure::read('CFG.site_title'); ?></title>
    
    <!-- BEGIN CORE FRAMEWORK CSS -->
    <link rel="stylesheet" type="text/css" href="/assets/plugins/ui/css/flat/jquery-ui-1.10.4.custom.css" />
    <link rel="stylesheet" type="text/css" href="/assets/plugins/bootstrap/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/jasny-bootstrap/css/jasny-bootstrap.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/vertical-timeline/component.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/fullcalendar/fullcalendar.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/datepicker/css/datepicker3.css">
    <link rel="stylesheet" type="text/css" href="/assets/plugins/colorbox/colorbox.css">
    <!-- END CORE FRAMEWORK CSS -->
    
    <!-- BEGIN TEMPLATE CSS -->
    <link rel="stylesheet" type="text/css" href="/assets/css/animate.min.css" />
    <link rel="stylesheet" type="text/css" href="/assets/css/default.css">
    <!-- END TEMPLATE CSS -->
    
    <!-- BEGIN PAGE LEVEL CSS -->
    <!-- END PAGE LEVEL CSS -->
    
    <!-- BEGIN CORE FRAMEWORK JS -->
    <script type="text/javascript" src="/assets/plugins/jquery/jquery-1.11.0.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/ui/js/jquery-ui-1.10.4.custom.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/standalone/standalone.js"></script>
    <script type="text/javascript" src="/assets/plugins/touch-punch/jquery.ui.touch-punch.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/bootstrap/js/tab.js"></script>
    <script type="text/javascript" src="/assets/plugins/jasny-bootstrap/js/jasny-bootstrap.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/imagesloaded/imagesloaded.pkgd.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/masonry/masonry.pkgd.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script type="text/javascript" src="/assets/plugins/tinymce/tinymce.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/moment/moment-with-langs.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/fullcalendar/fullcalendar.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/password/password.js"></script>
    <script type="text/javascript" src="/assets/plugins/datepicker/js/bootstrap-datepicker.js"></script>
    <script type="text/javascript" src="/assets/plugins/jquery-validation/jquery.validate.min.js"></script>
    <script type="text/javascript" src="/assets/plugins/multifile/jquery.MultiFile.js"></script>
    <script type="text/javascript" src="/assets/plugins/colorbox/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/assets/plugins/countto/jquery.countTo.js"></script>
    <?php if ($this->Session->read('Auth.UserSetting.language') != 'eng') { ?>
    <script type="text/javascript" src="/assets/plugins/fullcalendar/lang/<?php echo $this->Session->read('Auth.UserSetting.language'); ?>.js"></script>
    <script type="text/javascript" src="/assets/plugins/datepicker/js/locales/bootstrap-datepicker.<?php echo $this->Session->read('Auth.UserSetting.language'); ?>.js"></script>
    <script type="text/javascript" src="/assets/plugins/jquery-validation/localization/messages_<?php echo $this->Session->read('Auth.UserSetting.language'); ?>.js"></script>
    <?php } ?>
    <!-- END CORE FRAMEWORK JS -->
    
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
    
    <div id="wrapper">

        <nav class="navbar navbar-default navbar-static-top" role="navigation" style="margin-bottom: 0">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".sidebar-collapse">
                    <span class="sr-only"><?php echo __('Toggle navigation'); ?></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <div class="navbar-brand xs hidden-xs"><i class="fa fa-cubes"></i> <?php echo Configure::read('CFG.site_short_name'); ?></div>
                <div class="navbar-brand visible-xs"><i class="fa fa-cubes"></i> <?php echo Configure::read('CFG.site_name'); ?></div>
            </div>
            <!-- /.navbar-header -->
            
            <div class="navbar-top-links-xs">                
                <ul class="nav navbar-top-links navbar-right">
                    <li class="dropdown" style="float:left;">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                            <div class="dropdown-item"><i class="fa fa-plus fa-fw"></i> <?php echo __('Add'); ?> <span class="chevron"><i class="fa fa-chevron-down"></i></span></div>
                        </a>
                        <ul class="dropdown-menu dropdown-user">
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-bullhorn fa-fw"></i> ' . __('News'), array('controller'=>'news', 'action'=>'add'), array('escape' => false)); ?>
                            </li>
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-calendar fa-fw"></i> ' . __('Event'), array('controller'=>'events', 'action'=>'add'), array('escape' => false)); ?>
                            </li>
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-file-o fa-fw"></i> ' . __('File'), array('controller'=>'files', 'action'=>'add'), array('escape' => false)); ?>
                            </li>
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-comments-o fa-fw"></i> ' . __('Message'), array('controller'=>'messages', 'action'=>'add'), array('escape' => false)); ?>
                            </li>
                            <?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
                            <li class="divider"></li>
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-user fa-fw"></i> ' . __('Member'), array('controller'=>'users', 'action'=>'add'), array('escape' => false)); ?>
                            </li>
                            <?php } ?>
                        </ul>
                        <!-- /.dropdown-user -->
                    </li>
                    <!-- /.dropdown -->
                    <li class="dropdown" style="float:left;">
                        <a class="dropdown-toggle" data-toggle="dropdown" href="#">
                            <div class="profile-wrapper"><img src="<?php echo $this->Session->read('Auth.Profile.photo'); ?>" width="30" height="30" /></div> 
                            <div class="profile-name"><?php echo $this->Session->read('Auth.Profile.first_name'); ?> <span class="semi-bold"><?php echo $this->Session->read('Auth.Profile.last_name'); ?></span> <span class="chevron"><i class="fa fa-chevron-down"></i></span></div>
                            <div class="clearfix"></div>
                        </a>
                        <ul class="dropdown-menu dropdown-user">
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-user fa-fw"></i> ' . __('Profile'), array('controller'=>'users', 'action'=>'view', $this->Session->read('Auth.User.id')), array('escape' => false)); ?>
                            </li>
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-gear fa-fw"></i> ' . __('Settings'), '#', array('escape' => false, 'data-toggle' => 'modal', 'data-target' => '#userSettingsModal')); ?>
                            </li>
                            <?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
                            <li>
                                <?php echo $this->Html->link('<i class="fa fa-gears fa-fw"></i> ' . __('Admin Settings'), '#', array('escape' => false, 'data-toggle' => 'modal', 'data-target' => '#adminSettingsModal')); ?>
                            </li>
                            <?php } ?>
                            <li class="divider"></li>
                            <li><?php echo $this->Html->link('<i class="fa fa-sign-out fa-fw"></i> ' . __('Log Out'), array('controller'=>'users', 'action'=>'logout'), array('escape' => false)); ?></li>
                        </ul>
                        <!-- /.dropdown-user -->
                    </li>
                    <!-- /.dropdown -->
                </ul>
                <div class="clearfix"></div>
            </div>
            <!-- /.navbar-top-links -->

        </nav>
        <!-- /.navbar-static-top -->

        <nav class="navbar-default navbar-static-side" role="navigation">
            <div class="sidebar-collapse">
                <?php echo $this->element('nav'); ?>
                <!-- /#side-menu -->
            </div>
            <!-- /.sidebar-collapse -->
        </nav>
        <!-- /.navbar-static-side -->

        <div id="page-wrapper">        
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <?php
                echo $this->Session->flash('auth');
                echo $this->Session->flash(); 
                ?>
                </div>
            </div>
            
            <?php echo $this->fetch('content'); ?>
            <!-- /.row -->
            
            <?php
            // Add debug info
            if (Configure::read('debug') > 0) {
            ?>      
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <hr style="border-color:#333333;" />
                    <h1>Debug</h1>
                    <?php echo $this->element('sql_dump'); ?>
                    <hr style="border-color:#333333;" />
                    total render time (sec): 
                    <?php echo microtime(true) - $_SERVER['REQUEST_TIME']; ?><br />
                    total memory allocated to script:
                    <?php echo $this->Number->toReadableSize(memory_get_usage(true)); ?>
        
                </div>
            </div>
            <?php 
            }
            ?>
        </div>
        <!-- /#page-wrapper -->

    </div>
    <!-- /#wrapper -->
    
    <!-- Modals -->
    <?php echo $this->element('settings_user'); ?>
    <?php echo $this->element('settings_admin'); ?>
    
    <div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel"><?php echo __('Confirmation'); ?></h4>
                </div>
                <div class="modal-body">
                    <p><?php echo __('Are you sure you want to delete this item?'); ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-warning" data-dismiss="modal"><?php echo __('Cancel'); ?></button>
                    <button type="button" class="btn btn-primary" id="confirmSubmit"><?php echo __('Confirm'); ?></button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- BEGIN PAGE LEVEL JS -->
    <script type="text/javascript" src="/assets/js/lang/<?php echo $this->Session->read('Auth.UserSetting.language'); ?>.js"></script>
    <script type="text/javascript" src="/assets/js/default.js"></script>
    <?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
    <script type="text/javascript" src="/assets/js/admin.js"></script>
    <?php } ?>
    <!-- END PAGE LEVEL JS -->
</body>
</html>