<div class="panel">
    <div class="panel-body">
        <?php
        if (!$start) {
            echo '<div class="alert alert-danger text-center">' . __('Make sure all files are uploaded and permissions are set properly.') . '</div>';
        }
        ?>
        <div class="row">
            <div class="col-md-6 col-md-offset-3">
                <table class="table table-striped">
                <?php
                foreach ($files as $file) { 
                    echo '<tr>';   
                    if ($file['error'] == 'exists') {
                        echo '<td class="text-danger"><i class="fa fa-fw fa-times"></td><td>' . __($file['file'] . ' ' . $file['type'] . ' does not exist') . '</td>';
                    } elseif ($file['error'] == 'writable') {
                        echo '<td class="text-danger"><i class="fa fa-fw fa-times"></i></td><td>' . __($file['file'] . ' ' . $file['type'] . ' is not writeable') . '</td>';
                    } else {
                        echo '<td><i class="fa fa-fw fa-check"></i></td><td>' . __($file['file'] . ' ' . $file['type'] . ' exists and is writeable') . '</td>';
                    }
                    echo '</tr>';
                }
                ?>
                </table>
            </div>
        </div>
        
        <div class="text-center">
        <?php
        if ($start) {
            echo '<button id="open-wizard" class="btn btn-primary">' . __('Start installation') . '</button>';
        } else {
            echo '<button onclick="javascript:location.reload();" class="btn btn-primary">' . ('Refresh') . '</button>'; 
        }
        ?>
        </div>
    </div>
</div>

<div class="wizard" id="feral-wizard" data-title="Feral <?php echo __('Installation Wizard'); ?>">
    <div class="wizard-card">
        <h3>1. <?php echo __('Welcome'); ?></h3>
        
        <p><?php echo __('Welcome to the Feral Installation Wizard.'); ?><br>
        <?php echo __("It's important that you first read the documentation before you continue with this wizard. If you are in need for support, you can contact"); ?> <a href="mailto:support@inrainbo.ws">support@inrainbo.ws</a></p>
    </div>
    
    <div class="wizard-card" data-validate="validateStep2">
        <h3>2. <?php echo __('Database'); ?></h3>
        
        <div class="alert alert-danger" style="display:none;"></div>
        
        <form id="wizard-step2">
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 form-row">
                    <label for="DatabaseSource"><?php echo __('DataSource'); ?></label>
                    <select name="data[Database][database_source]" id="DatabaseSource" class="form-control" >
                        <option value="Mysql">MySQL</option>
                    </select>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="DatabaseHost"><?php echo __('Host'); ?></label>
                    <input name="data[Database][database_host]" id="DatabaseHost" type="text" class="form-control" value="" />
                </div>
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 form-row">
                    <label for="DatabaseHost"><?php echo __('Port'); ?></label>
                    <input name="data[Database][database_port]" id="DatabasePort" type="text" class="form-control" value="" />
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="DatabaseUser"><?php echo __('User'); ?></label>
                    <input name="data[Database][database_user]" id="DatabaseUser" type="text" class="form-control" value="" />
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="DatabasePassword"><?php echo __('Password'); ?></label>
                    <input name="data[Database][database_password]" id="DatabasePassword" type="password" class="form-control" value="" />
                </div>
                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 form-row">
                    <label for="DatabaseName"><?php echo __('Name'); ?></label>
                    <input name="data[Database][database_name]" id="DatabaseName" type="text" class="form-control" value="" />
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 form-row">
                    <label for="DatabasePrefix"><?php echo __('Prefix'); ?></label>
                    <input name="data[Database][database_prefix]" id="DatabasePrefix" type="text" class="form-control" value="feral_" />
                </div>
            </div>
        </form>
    </div>
    
    <div class="wizard-card" data-validate="validateStep3">
        <h3>3. <?php echo __('General'); ?></h3>
        
        <form id="wizard-step3">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationSiteUrl"><?php echo __('Website URL'); ?></label>
                    <input name="data[Configuration][site_url]" id="ConfigurationSiteUrl" type="text" class="form-control" value="http://<?php echo $_SERVER['HTTP_HOST']; ?>" />
                </div>
                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 form-row">
                    <label for="ConfigurationSiteName"><?php echo __('Website name'); ?></label>
                    <input name="data[Configuration][site_name]" id="ConfigurationSiteName" type="text" class="form-control" value="" />
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 form-row">
                    <label for="ConfigurationSiteShortName"><?php echo __('Website short name'); ?></label>
                    <input name="data[Configuration][site_short_name]" id="ConfigurationSiteShortName" type="text" class="form-control" maxlength="8" value="" />
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationSiteTitle"><?php echo __('Website window title'); ?></label>
                    <input name="data[Configuration][site_title]" id="ConfigurationSiteTitle" type="text" class="form-control" value="" />
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationSiteDescription"><?php echo __('Website description'); ?></label>
                    <textarea name="data[Configuration][site_description]" id="ConfigurationSiteDescription" class="form-control" style="height:80px;"></textarea>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationFrontend"><?php echo __('Show frontend'); ?></label>
                    <select name="data[Configuration][frontend]" id="ConfigurationFrontend" class="form-control">
                        <option value="1"><?php echo __('Yes'); ?></option>
                        <option value="0"><?php echo __('No'); ?></option>
                    </select>
                </div>
            </div>
        </form>
    </div>
    
    <div class="wizard-card" data-validate="validateStep4">
        <h3>4. <?php echo __('Display'); ?></h3>
        
        <form id="wizard-step4">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationLanguage"><?php echo __('Default language'); ?></label>
                    <select name="data[Configuration][language]" id="ConfigurationLanguage" class="form-control">
                        <?php
                        if (Configure::read('CFG.language')) {
                            $select = Configure::read('CFG.language');
                        } else {
                            $select = 'eng';
                        }
                        foreach($languages as $key => $val) {
                            ?>
                            <option value="<?php echo $key; ?>" <?php echo $select == $key ? ' selected' : null; ?>><?php echo $val; ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationTimezone"><?php echo __('Default time zone'); ?></label>
                    <select name="data[Configuration][timezone]" id="ConfigurationTimezone" class="form-control">
                        <?php
                        if (Configure::read('CFG.timezone')) {
                            $select = Configure::read('CFG.timezone');
                        } else {
                            $select = 'Europe/Amsterdam';
                        }
                        $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                        foreach($timezones as $timezone) {
                            ?>
                            <option value="<?php echo $timezone; ?>" <?php echo $select == $timezone ? ' selected' : null; ?>><?php echo $timezone; ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="ConfigurationDateFormat"><?php echo __('Date format'); ?></label>
                    <select name="data[Configuration][date_format]" id="ConfigurationDateFormat" class="form-control">
                        <option value="Y/m/d"<?php echo Configure::read('CFG.date_format') == 'Y/m/d' ? ' selected' : null; ?>><?php echo date('Y/m/d'); ?></option>
                        <option value="Y-m-d"<?php echo Configure::read('CFG.date_format') == 'Y-m-d' ? ' selected' : null; ?>><?php echo date('Y-m-d'); ?></option>
                        <option value="F d, Y"<?php echo Configure::read('CFG.date_format') == 'F d, Y' ? ' selected' : null; ?>><?php echo date('F d, Y'); ?></option>
                        <option value="d/m/Y"<?php echo Configure::read('CFG.date_format') == 'd/m/Y' ? ' selected' : null; ?>><?php echo date('d/m/Y'); ?></option>
                        <option value="d-m-Y"<?php echo Configure::read('CFG.date_format') == 'd-m-Y' ? ' selected' : null; ?>><?php echo date('d-m-Y'); ?></option>
                        <option value="d F Y"<?php echo Configure::read('CFG.date_format') == 'd F Y' ? ' selected' : null; ?>><?php echo date('d F Y'); ?></option>
                    </select>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="ConfigurationTimeFormat"><?php echo __('Time format'); ?></label>
                    <select name="data[Configuration][time_format]" id="ConfigurationTimeFormat" class="form-control">
                        <option value="g:i A"<?php echo Configure::read('CFG.time_format') == 'g:i A' ? ' selected' : null; ?>><?php echo __('12-Hour format'); ?></option>
                        <option value="H:i"<?php echo Configure::read('CFG.time_format') == 'H:i' ? ' selected' : null; ?>><?php echo __('24-Hour format'); ?></option>
                    </select>
                </div>
            </div>
        </form>
    </div>
    
    <div class="wizard-card" data-validate="validateStep5">
        <h3>5. <?php echo __('Email'); ?></h3>
        
        <form id="wizard-step5">
            <h4><?php echo __('Incoming'); ?></h4>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationEmailToEmail"><?php echo __('Email address'); ?></label>
                    <input name="data[Configuration][email_to_email]" id="ConfigurationEmailToEmail" type="text" class="form-control" value="<?php echo Configure::read('CFG.email_to_email'); ?>" />
                </div>
            </div>
            <hr>
            <h4><?php echo __('Outgoing'); ?></h4>
            <div class="row">
                <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 form-row">
                    <label for="ConfigurationEmailFromName"><?php echo __('Name'); ?></label>
                    <input name="data[Configuration][email_from_name]" id="ConfigurationEmailFromName" type="text" class="form-control" value="<?php echo Configure::read('CFG.email_from_name'); ?>" />
                </div>
                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 form-row">
                    <label for="ConfigurationEmailFromEmail"><?php echo __('Email address'); ?></label>
                    <input name="data[Configuration][email_from_email]" id="ConfigurationEmailFromEmail" type="text" class="form-control" value="<?php echo Configure::read('CFG.email_from_email'); ?>" />
                </div>
            </div>
        </form>
    </div>
    <div class="wizard-card" data-validate="validateStep6">
        <h3>6. <?php echo __('User'); ?></h3>
        
        <div class="alert alert-danger" style="display:none;"></div>
        
        <form id="wizard-step6">
            <h4><?php echo __('Settings'); ?></h4>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationUsersRegister"><?php echo __('Visitors can sign up'); ?></label>
                    <?php
                    if (Configure::read('CFG.users_register')) {
                        $select = Configure::read('CFG.users_register');
                    } else {
                        $select = '0';
                    }
                    ?>
                    <select name="data[Configuration][users_register]" id="ConfigurationUsersRegister" class="form-control">
                        <option value="1"<?php echo $select == '1' ? ' selected' : null; ?>><?php echo __('Yes'); ?></option>
                        <option value="0"<?php echo $select == '0' ? ' selected' : null; ?>><?php echo __('No'); ?></option>
                    </select>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                    <label for="ConfigurationUsersFollow"><?php echo __('Members can follow eachother'); ?></label>
                    <?php
                    if (Configure::read('CFG.users_follow')) {
                        $select = Configure::read('CFG.users_follow');
                    } else {
                        $select = '0';
                    }
                    ?>
                    <select name="data[Configuration][users_follow]" id="ConfigurationUsersFollow" class="form-control">
                        <option value="1"<?php echo $select == '1' ? ' selected' : null; ?>><?php echo __('Yes'); ?></option>
                        <option value="0"<?php echo $select == '0' ? ' selected' : null; ?>><?php echo __('No'); ?></option>
                    </select>
                </div>
            </div>
            <hr>
            <h4><?php echo __('Account'); ?></h4>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                    <label for="ProfileFirstName"><?php echo __('First name'); ?></label>
                    <input name="data[Profile][first_name]" id="ProfileFirstName" type="text" class="form-control" />
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                    <label for="ProfileLastName"><?php echo __('Last name'); ?></label>
                    <input name="data[Profile][last_name]" id="ProfileLastName" type="text" class="form-control" />
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                    <label for="ProfileFirstName"><?php echo __('Email address'); ?></label>
                    <input name="data[User][email]" id="UserEmail" type="text" class="form-control" />
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-row">
                    <label for="ProfileFirstName"><?php echo __('Password'); ?></label>
                    <input name="data[User][password]" id="UserPassword" type="password" class="form-control" />
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="UserSettingLanguage"><?php echo __('Language'); ?></label>
                    <select name="data[UserSetting][language]" id="UserSettingLanguage" class="form-control">
                        <?php
                        if (Configure::read('CFG.language')) {
                            $select = Configure::read('CFG.language');
                        } else {
                            $select = 'eng';
                        }
                        foreach($languages as $key => $val) {
                            ?>
                            <option value="<?php echo $key; ?>" <?php echo $select == $key ? ' selected' : null; ?>><?php echo $val; ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                    <label for="UserSettingTimezone"><?php echo __('Time zone'); ?></label>
                    <select name="data[UserSetting][timezone]" id="UserSettingTimezone" class="form-control">
                        <?php
                        if (Configure::read('CFG.timezone')) {
                            $select = Configure::read('CFG.timezone');
                        } else {
                            $select = 'Europe/Amsterdam';
                        }
                        $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                        foreach($timezones as $timezone) {
                            ?>
                            <option value="<?php echo $timezone; ?>" <?php echo $select == $timezone ? ' selected' : null; ?>><?php echo $timezone; ?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
            </div>
            <input name="data[User][role]" id="UserRole" type="hidden" class="form-control" value="admin" />
        </form>
    </div>
</div>