<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="panel panel-file">
                <div class="panel-heading">
                    <?php if (($this->Session->read('Auth.User.id') == $item['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons">
                        <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'files', 'action'=>'edit', $item['File']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'files', 'data-action' => 'delete', 'data-item_id' => $item['File']['id'])); ?>
                    </div>
                    <?php } ?>
                    <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['File']['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['File']['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                    <h2><?php echo $item['File']['title']; ?></h2>
                    
                    <div class="profile-wrapper">                        
                        <?php echo $this->Html->link('<img src="' . $item['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div> 
                    <div class="profile-name">
                        <?php echo $this->Html->link($item['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <?php echo $item['File']['content']; ?>
                    <ul class="files">
                        <?php
                        foreach ($item['FileAttachment'] as $file) {
                            $filename = explode('/', $file['file']);
                            ?>
                            <li><a href="<?php echo $file['file']; ?>" target="_blank"><?php echo wordwrap(end($filename), 30, "-<br>\n", true); ?></a></li>
                            <?php
                        } 
                        ?>
                    </ul>
                </div>
                <div class="panel-footer">
                    <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-left"></i> ' . __('Back'), $referer, array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    <div class="pull-right">
                        <?php echo $this->Html->link('<i class="fa fa-comment"></i> ' . __('Add comment'), array('controller'=>'files', 'action'=>'view', $item['File']['id'], '#'=>'comment'), array('class'=>'btn btn-primary btn-comment', 'escape'=>false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<a name="comment"></a>
<div class="row row-comment" style="display:none;">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="panel panel-main panel-form">
            <div class="panel-body ">
                <form action="/files/comment/<?php echo $item['File']['id']; ?>" method="post">
                <fieldset>
                    <ul>
                        <li>
                            <label for="FileContent"><?php echo __('Comment'); ?></label>
                            <textarea name="data[FileComment][content]" id="CommentContent" class="form-control wysiwyg"></textarea>
                        </li>
                        <li class="submit">
                            <input name="data[FileComment][id]" id="CommentId" type="hidden" value="" />
                            <button type="reset" class="btn btn-warning btn-comment-cancel"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save comment'); ?></button>
                        </li>
                    </ul>
                </fieldset>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if (count($item['FileComment']) > 0) { ?>
<a name="comments"></a>
<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="panel panel-file panel-comment">
                <div class="panel-body">
                    <h2><?php echo __('Comments'); ?></h2>
                    <?php 
                    foreach ($item['FileComment'] as $comment) {
                        ?>
                        <div class="separator">
                            <?php if (($this->Session->read('Auth.User.id') == $comment['user_id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                            <div class="icons pull-right">
                                <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'files', 'action'=>'view', $item['File']['id'], '#'=>'comment'), array('class'=>'btn-comment-edit', 'data-id'=>$comment['id'], 'escape'=>false)); ?>
                                <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'files', 'data-action' => 'comment_delete', 'data-item_id' => $comment['id'])); ?>
                            </div>
                            <?php } ?>
                            <div class="profile-wrapper">
                                <?php echo $this->Html->link('<img src="' . $comment['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                            </div> 
                            <div class="profile-name">
                                <?php echo $this->Html->link($comment['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $comment['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>

                            </div>
                            <div class="clearfix"></div>
                            <small class="datetime">
                                <i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $comment['created'], null, Configure::read('CFG.timezone')); ?>
                            </small>
                            <div class="clearfix"></div>
                            <div class="comment-content">
                                <?php echo $comment['content']; ?>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>