<div class="row">
    <div class="msnry animated fadeInUp">
        <?php foreach ($items->data as $item) { ?>
        <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 item">
            <div class="panel panel-file">
                <div class="panel-heading">
                    <?php if (($this->Session->read('Auth.User.id') == $item['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons">
                            <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'files', 'action'=>'edit', $item['File']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'files', 'data-action' => 'delete', 'data-item_id' => $item['File']['id'])); ?>
                    </div>
                    <?php } ?>
                    <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['File']['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['File']['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                    <h2><?php echo $item['File']['title']; ?></h2>
                    
                    <div class="profile-wrapper">                        
                        <?php echo $this->Html->link('<img src="' . $item['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div> 
                    <div class="profile-name">
                        <?php echo $this->Html->link($item['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <?php echo $this->Text->truncate(
                        $item['File']['content'],
                        100,
                        array(
                            'ellipsis' => '...',
                            'exact' => false,
                            'html' => true
                        )
                    ); ?>
                    <ul class="files">
                        <?php
                        foreach ($item['FileAttachment'] as $file) {
                            $filename = explode('/', $file['file']);
                            ?>
                            <li><a href="<?php echo $file['file']; ?>" target="_blank"><?php echo wordwrap(end($filename), 30, "-<br>\n", true); ?></a></li>
                            <?php
                        } 
                        ?>
                    </ul>
                </div>
                <div class="panel-footer">
                    <div class="icons">
                        <?php echo $this->Html->link('<i class="fa fa-comment" title="' . __('Comments') . '"></i> ' . count($item['FileComment']), array('controller'=>'files', 'action'=>'view', $item['File']['id'], '#'=>'comments'), array('escape' => false)); ?>
                    </div>
                    <div class="pull-right">
                        <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-right"></i> ' . __('More info'), array('controller'=>'files', 'action'=>'view', $item['File']['id']), array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</div>

<?php
if(count($items->numbers) > 1) {
    ?>
    <div class="row">
        <div class="col-xs-12 text-center paginate">
            <hr class="colered">
            <ul class="pagination">
            <?php
            foreach($items->numbers as $num) {
                $url = '/files/?p=' . $num;
                
                if((isset($_GET['p']) && $num == $_GET['p']) || ($num == 1 && !isset($_GET['p']))) {
                    echo '<li class="active"><a href="'.$url.'">'.$num.'</a></li>';
                }else{
                    echo '<li><a href="'.$url.'">'.$num.'</a></li>';
                }
            }
            ?>
            </ul>
        </div>
    </div>
    <?php
}
?>