<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-file panel-form">
                <div class="panel-heading">
                    <h1><i class="fa fa-file-o fa-fw"></i> <?php echo __('Edit File'); ?></h1>
                </div>
                
                <div class="panel-body content">
                    <form id="FileEditForm" action="/files/edit/<?php echo $item['File']['id']; ?>" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="FileTitle"><?php echo __('Title'); ?></label>
                            <input name="data[File][title]" id="FileTitle" type="text" class="form-control" value="<?php echo $item['File']['title'] ?>" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="FileContent"><?php echo __('Description'); ?></label>
                            <textarea name="data[File][content]" id="FileContent" class="form-control wysiwyg" style="height:200px;"><?php echo $item['File']['content'] ?></textarea>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <span class="btn btn-primary fileinput-button">
                                <i class="glyphicon glyphicon-plus"></i>
                                <span>Add files...</span>
                                <input type="file" name="data[FileAttachment][][file]" multiple>
                            </span>
                            <div class="table-responsive">
                                <table id="FileAttachmentFiles" class="table table-striped table-files">
                                <?php
                                foreach ($item['FileAttachment'] as $file) {
                                    $filename = explode('/', $file['file']);
                                    ?>
                                    <tr class="MultiFile-label">
                                        <td style="width:50px;">
                                            <button type="button" class="btn btn-danger deleteFile" data-id="<?php echo $file['id']; ?>"><i class="fa fa-times"></i></button>
                                        </td>
                                        <td>
                                            <span class="MultiFile-title"><?php echo end($filename); ?></span>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                                </table>
                            </div>
                        </div>
                        <?php
                        if ($this->Session->read('Auth.User.role') == 'admin') {
                        ?>
                        <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 form-row">
                            <div class="control-group">
                                <div class="checkbox check-form"> 
                                    <input type="checkbox" name="data[File][admin]" id="FileAdmin" value="1"<?php echo $item['File']['admin'] ? ' checked' : null; ?>>
                                    <label for="FileAdmin"><?php echo __('Only available for administrators'); ?></label>
                                </div>
                            </div>
                        </div>
                        <?php
                        }
                        ?>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-right form-row">
                            <button type="button" class="btn btn-warning" onclick="window.location='<?php echo $referer; ?>';"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save'); ?></button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {    
    $("#FileEditForm").validate({
        rules: {
            'data[File][title]': {
                required: true
            }
        }
    });
});

$('input[name="data[FileAttachment][][file]"]').MultiFile({
    list: '#FileAttachmentFiles',
    max: 10,
    maxsize: 10240,
    STRING: {
      remove: '<button class="btn btn-danger"><i class="fa fa-times"></i></button'
    }
});

$('.deleteFile').click(function() {
    id = $(this).attr('data-id');
    $('<input name="data[FileAttachment][100' + id + '][id]" value="' + id + '">').attr('type','hidden').appendTo('#FileEditForm');
    $('<input name="data[FileAttachment][100' + id + '][deleted]" value="1">').attr('type','hidden').appendTo('#FileEditForm');
    $(this).parent().parent().hide();
});
</script>