<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
            <div class="panel panel-event">
                <div class="panel-heading" style="position:relative;">
                    <div class="pull-right" style="position:absolute; right:15px; bottom:15px;">
                        <?php echo $this->Html->link(__('Download ICS'), array('action'=>'calendar', 'ext'=>'ics', $item['Event']['id']), array('class' => 'btn btn-heading', 'escape' => false)); ?>
                    </div>
                    <?php if (($this->Session->read('Auth.User.id') == $item['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                    <div class="icons">
                        <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'events', 'action'=>'edit', $item['Event']['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'events', 'data-action' => 'delete', 'data-item_id' => $item['Event']['id'])); ?>
                    </div>
                    <?php } ?>
                    <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['Event']['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['Event']['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                    <h2><?php echo $item['Event']['title']; ?></h2>
                    
                    <div class="profile-wrapper">                        
                        <?php echo $this->Html->link('<img src="' . $item['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div> 
                    <div class="profile-name">
                        <?php echo $this->Html->link($item['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['User']['id']), array('escape' => false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="panel-body">
                    <div class="pull-right">
                        <button class="btn btn-primary<?php echo isset($item['EventAttendee'][0]['status']) && $item['EventAttendee'][0]['status'] == 'present' ? ' active' : null; ?>" id="btnPresent"><?php echo __('Present'); ?></button> 
                        <button class="btn btn-primary<?php echo isset($item['EventAttendee'][0]['status']) && $item['EventAttendee'][0]['status'] == 'absent' ? ' active' : null; ?>" id="btnAbsent"><?php echo __('Absent'); ?></button>
                    </div>
                    <ul>
                        <?php
                        if ($item['Event']['start_date'] == $item['Event']['end_date']) {
                            ?>
                            <li><i class="fa fa-calendar-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['Event']['start_date'], null, Configure::read('CFG.timezone')); ?></li>
                            <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['Event']['start_time'], null, Configure::read('CFG.timezone')); ?></li>
                            <li><i class="fa fa-arrow-left fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['Event']['end_time'], null, Configure::read('CFG.timezone')); ?></li>
                            <?php
                        } else {
                            ?>
                            <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['Event']['start_date'], null, Configure::read('CFG.timezone')); ?> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['Event']['start_time'], null, Configure::read('CFG.timezone')); ?></li>
                            <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['Event']['end_date'], null, Configure::read('CFG.timezone')); ?> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['Event']['end_time'], null, Configure::read('CFG.timezone')); ?></li>
                            <?php
                        }
                        ?>
                        <?php if ($item['Event']['location']) { ?>
                        <li><i class="fa fa-location-arrow fa-fw"></i> <a href="https://www.google.com/maps/dir//<?php echo str_replace(' ', '+', $item['Event']['location']); ?>" target="_blank"><?php echo $item['Event']['location']; ?></a></li>
                        <?php } ?>
                    </ul>
                    <?php echo $item['Event']['content']; ?>
                </div>
                <div class="panel-footer">
                    <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-left"></i> ' . __('Back'), $referer, array('class' => 'btn btn-primary', 'escape' => false)); ?>
                    <div class="pull-right">
                        <?php echo $this->Html->link('<i class="fa fa-comment"></i> ' . __('Add comment'), array('controller'=>'events', 'action'=>'view', $item['Event']['id'], '#'=>'comment'), array('class'=>'btn btn-primary btn-comment', 'escape'=>false)); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="animated fadeInUp">
        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="panel panel-event">
                        <div class="panel-heading">
                            <div class="pull-right heading_present">
                                <i class="fa fa-refresh fa-spin"></i>
                            </div>
                            <h2><?php echo __('Present'); ?></h2>
                        </div>
                        <div class="panel-body">
                            <div class="event_present">
                            </div>
                        </div>
                        <div class="panel-footer">
                            
                        </div>
                    </div>
                </div>
        
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="panel panel-event">
                        <div class="panel-heading">
                            <div class="pull-right heading_absent">
                                <i class="fa fa-refresh fa-spin"></i>
                            </div>
                            <h2><?php echo __('Absent'); ?></h2>
                        </div>
                        <div class="panel-body">
                            <div class="event_absent">
                            </div>
                        </div>
                        <div class="panel-footer">
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<a name="comment"></a>
<div class="row row-comment" style="display:none;">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="panel panel-main panel-form">
            <div class="panel-body ">
                <form action="/events/comment/<?php echo $item['Event']['id']; ?>" method="post">
                <fieldset>
                    <ul>
                        <li>
                            <label for="EventContent"><?php echo __('Comment'); ?></label>
                            <textarea name="data[EventComment][content]" id="CommentContent" class="form-control wysiwyg"></textarea>
                        </li>
                        <li class="submit">
                            <input name="data[EventComment][id]" id="CommentId" type="hidden" value="" />
                            <button type="reset" class="btn btn-warning btn-comment-cancel"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save comment'); ?></button>
                        </li>
                    </ul>
                </fieldset>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if (count($item['EventComment']) > 0) { ?>
<a name="comments"></a>
<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="panel panel-event panel-comment">
                <div class="panel-body">
                    <h2><?php echo __('Comments'); ?></h2>
                    <?php 
                    foreach ($item['EventComment'] as $comment) {
                        ?>
                        <div class="seperator">
                            <?php if (($this->Session->read('Auth.User.id') == $comment['user_id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                            <div class="icons pull-right">
                                <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>'events', 'action'=>'view', $item['Event']['id'], '#'=>'comment'), array('class'=>'btn-comment-edit', 'data-id'=>$comment['id'], 'escape'=>false)); ?>
                                <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => 'events', 'data-action' => 'comment_delete', 'data-item_id' => $comment['id'])); ?>

                            </div>
                            <?php } ?>
                            <div class="profile-wrapper">
                                <?php echo $this->Html->link('<img src="' . $comment['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                            </div> 
                            <div class="profile-name">
                                <?php echo $this->Html->link($comment['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $comment['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>

                            </div>
                            <div class="clearfix"></div>
                            <small class="datetime">
                                <i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $comment['created'], null, Configure::read('CFG.timezone')); ?>
                            </small>
                            <div class="clearfix"></div>
                            <div class="comment-content">
                                <?php echo $comment['content']; ?>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>

<script type="text/javascript">
function getStatus(status) {
    $('.heading_' + status).show();
    $('.event_' + status).html('');
    
    $.getJSON('/events/attendees/<?php echo $item['Event']['id'] ?>/' + status, function(attendees) {
        $.each(attendees, function() {
            $('.event_' + status).append('<div class="profile-wrapper"><a href="/users/view/' + this.User.id + '"><img src="' + this.User.Profile.photo + '" width="30" height="30" /></a></div><div class="profile-name"><a href="/users/view/' + this.User.id + '">' + this.User.Profile.first_name + ' <span class="semi-bold">' + this.User.Profile.last_name + '</span></a></div><div class="clearfix"></div><br />');
        });
        $('.heading_' + status).hide();
    });
}

getStatus('present');
getStatus('absent');

$('#btnPresent').click(function() {
    $.ajax({ 
        type: "GET", 
        url: "/events/attend/<?php echo $item['Event']['id'] ?>/present",
        success: function(result) {
            if(result == 1) {                    
               $('#btnPresent').addClass("active");
               $('#btnAbsent').removeClass("active");
               
               getStatus('present');
            }else if(result == 2) {                    
               $('#btnPresent').addClass("active");
               $('#btnAbsent').removeClass("active");
               
               getStatus('present');
               getStatus('absent');
            }else if(result == 3) {
               $('#btnPresent').removeClass("active");
               $('#btnAbsent').removeClass("active");
               
               getStatus('present');
            } else {
                alert('<?php echo __('An error has occurred'); ?>');
            }
            
        }
    });
});
$('#btnAbsent').click(function() {
    $.ajax({ 
        type: "GET", 
        url: "/events/attend/<?php echo $item['Event']['id'] ?>/absent",
        success: function(result) {
            if(result == 1) {                    
               $('#btnPresent').removeClass("active");
               $('#btnAbsent').addClass("active");
               
               getStatus('absent');
            }else if(result == 2) {                    
               $('#btnPresent').removeClass("active");
               $('#btnAbsent').addClass("active");
               
               getStatus('present');
               getStatus('absent');
            }else if(result == 3) {
               $('#btnPresent').removeClass("active");
               $('#btnAbsent').removeClass("active");
               
               getStatus('absent');
            } else {
                alert('<?php echo __('An error has occurred'); ?>');
            }
            
        }
    });
});
</script>