<div class="row">
    <div class="animated fadeInUp">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 item">
            <div class="panel panel-event panel-form">
                <div class="panel-heading">
                    <h1><i class="fa fa-calendar fa-fw"></i> <?php echo __('Add Event'); ?></h1>
                </div>
                
                <div class="panel-body content">
                    <form id="EventAddForm" action="/events/add" method="post">
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 form-row">
                            <label for="StartDate"><?php echo __('Start date'); ?></label>
                            <input name="data[Event][start_date]" id="StartDate" type="text" class="form-control datefield" />
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 form-row">
                            <label for="StartTime"><?php echo __('Start time'); ?></label>
                            <input name="data[Event][start_time]" id="StartTime" type="text" class="form-control timefield" />
                        </div>
                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 form-row">
                            <label for="EndDate"><?php echo __('End date'); ?></label>
                            <input name="data[Event][end_date]" id="EndDate" type="text" class="form-control datefield" />
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 form-row">
                            <label for="EndTime"><?php echo __('End time'); ?></label>
                            <input name="data[Event][end_time]" id="EndTime" type="text" class="form-control timefield" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="EventLocation"><?php echo __('Location'); ?></label>
                            <input name="data[Event][location]" id="EventLocation" type="text" class="form-control" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="EventTitle"><?php echo __('Title'); ?></label>
                            <input name="data[Event][title]" id="EventTitle" type="text" class="form-control" />
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                            <label for="EventContent"><?php echo __('Description'); ?></label>
                            <textarea name="data[Event][content]" id="EventContent" class="form-control wysiwyg" style="height:200px;"></textarea>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 form-row">
                            <div class="control-group">
                                <div class="checkbox check-form"> 
                                    <input type="checkbox" name="data[Event][notify]" id="EventNotify" value="1" checked="checked">
                                    <label for="EventNotify"><?php echo (Configure::read('CFG.users_follow')) ? __('Notify followers') : __('Notify other members'); ?></label>
                                </div>
                            </div>
                        </div>
                        <?php
                        if ($this->Session->read('Auth.User.role') == 'admin') {
                        ?>
                        <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12 form-row">
                            <div class="control-group">
                                <div class="checkbox check-form"> 
                                    <input type="checkbox" name="data[Event][admin]" id="EventAdmin" value="1">
                                    <label for="EventAdmin"><?php echo __('Only available for administrators'); ?></label>
                                </div>
                            </div>
                        </div>
                        <?php
                        }
                        ?>
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-right form-row">
                            <button type="reset" class="btn btn-warning" onclick="window.location='<?php echo $referer; ?>';"><i class="fa fa-times fa-fw"></i> <?php echo __('Cancel'); ?></button> <button type="submit" class="btn btn-primary"><i class="fa fa-check fa-fw"></i> <?php echo __('Save'); ?></button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
<?php
$dates = array(
    'en' => array(
        'Y/m/d', 'Y-m-d', 'F d, Y',
    ),
    'uk' => array(
        'd/m/Y', 'd-m-Y', 'd F Y',
    ),
);
if (in_array(Configure::read('CFG.date_format'), $dates['en'])) {
    ?>
    $('.datefield').inputmask({
        mask: '9999/99/99'
    });
    $('.datefield').datepicker({
        format: "yyyy/mm/dd",
        autoclose: true,
        todayHighlight: true
        <?php echo ($this->Session->read('Auth.UserSetting.language') != 'eng') ? ',language: "' . $this->Session->read('Auth.UserSetting.language') . '"' : null; ?>
    });
    <?php
} elseif (in_array(Configure::read('CFG.date_format'), $dates['uk'])) {
    ?>
    $('.datefield').inputmask({
        mask: '99/99/9999'
    });
    $('.datefield').datepicker({
        format: "dd/mm/yyyy",
        autoclose: true,
        todayHighlight: true
        <?php echo ($this->Session->read('Auth.UserSetting.language') != 'eng') ? ',language: "' . $this->Session->read('Auth.UserSetting.language') . '"' : null; ?>
    });
    <?php
}
?>

$('.timefield').inputmask({
    mask: '99:99'
});

$(document).ready(function() {    
    $("#EventAddForm").validate({
        rules: {
            'data[Event][title]': {
                required: true
            },
            'data[Event][start_date]': {
                required: true
            },
            'data[Event][end_date]': {
                required: true
            },
            'data[Event][start_time]': {
                required: true
            },
            'data[Event][end_time]': {
                required: true
            }
        }
    });
});
</script>