<!-- Modal -->
<div class="modal fade" id="userSettingsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel"><?php echo __('Settings'); ?></h4>
            </div>
            <form id="userSettingsForm">
            <div class="modal-body">
                <div class="center">
                    <ul class="nav nav-pills">
                        <li class="active">
                            <a href="#user_display" data-toggle="tab">
                                <i class="fa fa-eye"></i> <?php echo __('Display'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="#user_about" data-toggle="tab">
                                <i class="fa fa-info-circle"></i> <?php echo __('About'); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <hr>
                <div class="tab-content">
                    <div class="tab-pane active" id="user_display">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="UserSettingLanguage"><?php echo __('Language'); ?></label>
                                <select name="data[UserSetting][language]" id="UserSettingLanguage" class="form-control">
                                    <?php
                                    foreach($languages as $key => $val) {
                                        ?>
                                        <option value="<?php echo $key; ?>" <?php echo $this->Session->read('Auth.UserSetting.language') == $key ? ' selected' : null; ?>><?php echo $val; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="UserSettingTimezone"><?php echo __('Time zone'); ?></label>
                                <select name="data[UserSetting][timezone]" id="UserSettingTimezone" class="form-control">
                                    <?php
                                    $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                                    foreach($timezones as $timezone) {
                                        ?>
                                        <option value="<?php echo $timezone; ?>" <?php echo Configure::read('CFG.timezone') == $timezone ? ' selected' : null; ?>><?php echo $timezone; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                <label for="UserSettingDateFormat"><?php echo __('Date format'); ?></label>
                                <select name="data[UserSetting][date_format]" id="UserSettingDateFormat" class="form-control">
                                    <option value="Y/m/d"<?php echo $this->Session->read('Auth.UserSetting.date_format') == 'Y/m/d' ? ' selected' : null; ?>><?php echo date('Y/m/d'); ?></option>
                                    <option value="Y-m-d"<?php echo $this->Session->read('Auth.UserSetting.date_format') == 'Y-m-d' ? ' selected' : null; ?>><?php echo date('Y-m-d'); ?></option>
                                    <option value="F d, Y"<?php echo $this->Session->read('Auth.UserSetting.date_format') == 'F d, Y' ? ' selected' : null; ?>><?php echo date('F d, Y'); ?></option>
                                    <option value="d/m/Y"<?php echo $this->Session->read('Auth.UserSetting.date_format') == 'd/m/Y' ? ' selected' : null; ?>><?php echo date('d/m/Y'); ?></option>
                                    <option value="d-m-Y"<?php echo $this->Session->read('Auth.UserSetting.date_format') == 'd-m-Y' ? ' selected' : null; ?>><?php echo date('d-m-Y'); ?></option>
                                    <option value="d F Y"<?php echo $this->Session->read('Auth.UserSetting.date_format') == 'd F Y' ? ' selected' : null; ?>><?php echo date('d F Y'); ?></option>
                                </select>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                <label for="UserSettingTimeFormat"><?php echo __('Time format'); ?></label>
                                <select name="data[UserSetting][time_format]" id="UserSettingTimeFormat" class="form-control">
                                    <option value="g:i A"<?php echo $this->Session->read('Auth.UserSetting.time_format') == 'g:i A' ? ' selected' : null; ?>><?php echo __('12-Hour format'); ?></option>
                                    <option value="H:i"<?php echo $this->Session->read('Auth.UserSetting.time_format') == 'H:i' ? ' selected' : null; ?>><?php echo __('24-Hour format'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane text-center" id="user_about">
                        <h1 class="logo">
                            <i class="fa fa-cubes"></i> <?php echo Configure::read('CFG.site_name'); ?>
                        </h1>
                        <p>1.2</p>
                        
                        <p>&copy; <?php echo date('Y'); ?> <?php echo Configure::read('CFG.site_name'); ?><br><?php echo __('All Rights Reserved'); ?></p>
                        
                        <?php /* <hr>
                        
                        <h4><?php echo __('Licences'); ?></h4> */ ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="userSettingsCancel" class="btn btn-warning"><?php echo __('Cancel'); ?></button>
                <button type="button" id="userSettingsSubmit" class="btn btn-primary"><?php echo __('Save'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>