<?php if ($this->Session->read('Auth.User.role') == 'admin') { ?>
<!-- Modal -->
<div class="modal fade" id="adminSettingsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel"><?php echo __('Admin Settings'); ?></h4>
            </div>
            <form id="adminSettingsForm">
            <div class="modal-body">
                <div class="center">
                    <ul class="nav nav-pills">
                        <li class="active">
                            <a href="#admin_main" data-toggle="tab">
                                <i class="fa fa-gear"></i> <?php echo __('General'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="#admin_display" data-toggle="tab">
                                <i class="fa fa-eye"></i> <?php echo __('Display'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="#admin_users" data-toggle="tab">
                                <i class="fa fa-users"></i> <?php echo __('Users'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="#admin_email" data-toggle="tab">
                                <i class="fa fa-envelope-o"></i> <?php echo __('Email'); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <hr>
                <div class="tab-content">
                    <div class="tab-pane active" id="admin_main">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationSiteUrl"><?php echo __('Website URL'); ?></label>
                                <input name="data[Configuration][site_url]" id="ConfigurationSiteUrl" type="text" class="form-control" value="<?php echo Configure::read('CFG.site_url'); ?>" />
                            </div>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 form-row">
                                <label for="ConfigurationSiteName"><?php echo __('Website name'); ?></label>
                                <input name="data[Configuration][site_name]" id="ConfigurationSiteName" type="text" class="form-control" value="<?php echo Configure::read('CFG.site_name'); ?>" />
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 form-row">
                                <label for="ConfigurationSiteShortName"><?php echo __('Website short name'); ?></label>
                                <input name="data[Configuration][site_short_name]" id="ConfigurationSiteShortName" type="text" class="form-control" maxlength="8" value="<?php echo Configure::read('CFG.site_short_name'); ?>" />
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationSiteTitle"><?php echo __('Website window title'); ?></label>
                                <input name="data[Configuration][site_title]" id="ConfigurationSiteTitle" type="text" class="form-control" value="<?php echo Configure::read('CFG.site_title'); ?>" />
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationSiteDescription"><?php echo __('Website description'); ?></label>
                                <textarea name="data[Configuration][site_description]" id="ConfigurationSiteDescription" class="form-control" style="height:100px;"><?php echo Configure::read('CFG.site_description'); ?></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="admin_display">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationLanguage"><?php echo __('Default language'); ?></label>
                                <select name="data[Configuration][language]" id="ConfigurationLanguage" class="form-control">
                                    <?php
                                    foreach($languages as $key => $val) {
                                        ?>
                                        <option value="<?php echo $key; ?>" <?php echo Configure::read('CFG.language') == $key ? ' selected' : null; ?>><?php echo $val; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationTimezone"><?php echo __('Default time zone'); ?></label>
                                <select name="data[Configuration][timezone]" id="ConfigurationTimezone" class="form-control">
                                    <?php
                                    $timezones = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                                    foreach($timezones as $timezone) {
                                        ?>
                                        <option value="<?php echo $timezone; ?>" <?php echo Configure::read('CFG.timezone') == $timezone ? ' selected' : null; ?>><?php echo $timezone; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                <label for="ConfigurationDateFormat"><?php echo __('Date format'); ?></label>
                                <select name="data[Configuration][date_format]" id="ConfigurationDateFormat" class="form-control">
                                    <option value="Y/m/d"<?php echo Configure::read('CFG.date_format') == 'Y/m/d' ? ' selected' : null; ?>><?php echo date('Y/m/d'); ?></option>
                                    <option value="Y-m-d"<?php echo Configure::read('CFG.date_format') == 'Y-m-d' ? ' selected' : null; ?>><?php echo date('Y-m-d'); ?></option>
                                    <option value="F d, Y"<?php echo Configure::read('CFG.date_format') == 'F d, Y' ? ' selected' : null; ?>><?php echo date('F d, Y'); ?></option>
                                    <option value="d/m/Y"<?php echo Configure::read('CFG.date_format') == 'd/m/Y' ? ' selected' : null; ?>><?php echo date('d/m/Y'); ?></option>
                                    <option value="d-m-Y"<?php echo Configure::read('CFG.date_format') == 'd-m-Y' ? ' selected' : null; ?>><?php echo date('d-m-Y'); ?></option>
                                    <option value="d F Y"<?php echo Configure::read('CFG.date_format') == 'd F Y' ? ' selected' : null; ?>><?php echo date('d F Y'); ?></option>
                                </select>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 form-row">
                                <label for="ConfigurationTimeFormat"><?php echo __('Time format'); ?></label>
                                <select name="data[Configuration][time_format]" id="ConfigurationTimeFormat" class="form-control">
                                    <option value="g:i A"<?php echo Configure::read('CFG.time_format') == 'g:i A' ? ' selected' : null; ?>><?php echo __('12-Hour format'); ?></option>
                                    <option value="H:i"<?php echo Configure::read('CFG.time_format') == 'H:i' ? ' selected' : null; ?>><?php echo __('24-Hour format'); ?></option>
                                </select>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-6 col-xs-12 form-row">
                                <hr>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationFrontend"><?php echo __('Show frontend'); ?></label>
                                <select name="data[Configuration][frontend]" id="ConfigurationFrontend" class="form-control">
                                    <option value="1"<?php echo Configure::read('CFG.frontend') == '1' ? ' selected' : null; ?>><?php echo __('Yes'); ?></option>
                                    <option value="0"<?php echo Configure::read('CFG.frontend') == '0' ? ' selected' : null; ?>><?php echo __('No'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="admin_users">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationUsersRegister"><?php echo __('Visitors can sign up'); ?></label>
                                <select name="data[Configuration][users_register]" id="ConfigurationUsersRegister" class="form-control">
                                    <option value="1"<?php echo Configure::read('CFG.users_register') == '1' ? ' selected' : null; ?>><?php echo __('Yes'); ?></option>
                                    <option value="0"<?php echo Configure::read('CFG.users_register') == '0' ? ' selected' : null; ?>><?php echo __('No'); ?></option>
                                </select>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationUsersFollow"><?php echo __('Members can follow eachother'); ?></label>
                                <select name="data[Configuration][users_follow]" id="ConfigurationUsersFollow" class="form-control">
                                    <option value="1"<?php echo Configure::read('CFG.users_follow') == '1' ? ' selected' : null; ?>><?php echo __('Yes'); ?></option>
                                    <option value="0"<?php echo Configure::read('CFG.users_follow') == '0' ? ' selected' : null; ?>><?php echo __('No'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="admin_email">
                        <h4><?php echo __('Incoming'); ?></h4>
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 form-row">
                                <label for="ConfigurationEmailToEmail"><?php echo __('Email address'); ?></label>
                                <input name="data[Configuration][email_to_email]" id="ConfigurationEmailToEmail" type="text" class="form-control" value="<?php echo Configure::read('CFG.email_to_email'); ?>" />
                            </div>
                        </div>
                        <hr>
                        <h4><?php echo __('Outgoing'); ?></h4>
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 form-row">
                                <label for="ConfigurationEmailFromName"><?php echo __('Name'); ?></label>
                                <input name="data[Configuration][email_from_name]" id="ConfigurationEmailFromName" type="text" class="form-control" value="<?php echo Configure::read('CFG.email_from_name'); ?>" />
                            </div>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 form-row">
                                <label for="ConfigurationEmailFromEmail"><?php echo __('Email address'); ?></label>
                                <input name="data[Configuration][email_from_email]" id="ConfigurationEmailFromEmail" type="text" class="form-control" value="<?php echo Configure::read('CFG.email_from_email'); ?>" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="adminSettingsCancel" class="btn btn-warning"><?php echo __('Cancel'); ?></button>
                <button type="button" id="adminSettingsSubmit" class="btn btn-primary"><?php echo __('Save'); ?></button>
            </div>
            </form>
        </div>
    </div>
</div>
<?php } ?>