<?php
$items = array(
    'dashboard'   => array(
        'icon' => 'home',
        'title' => __('Dashboard'),
    ),
    'news'   => array(
        'icon' => 'bullhorn',
        'title' => __('News'),
    ),
    'events'   => array(
        'icon' => 'calendar',
        'title' => __('Calendar'),
    ),
    'files'   => array(
        'icon' => 'file-o',
        'title' => __('Files'),
    ),
    'messages'   => array(
        'icon' => 'comments-o',
        'title' => __('Forum'),
    ),
    'users'   => array(
        'icon' => 'users',
        'title' => __('Members'),
    ),
);
?>
<ul class="nav" id="side-menu">
                    <li class="sidebar-search">
                        <form action="/dashboard/" method="get">
                            <input name="q" id="Search" type="text" class="form-control" placeholder="<?php echo __('Search Dashboard'); ?>..." value="<?php echo isset($_GET['q']) ? $_GET['q'] : null; ?>">
                        </form>
                    </li>
                <?php
                foreach ($items as $key => $value) {
                    echo '    <li' . ($this->params['controller'] == $key ? ' class="active"' : null) . '>';
                    echo "\n                        ";
                    echo $this->Html->link('<i class="fa fa-' . $value['icon'] . ' fa-fw"></i> ' . $value['title'], "/" . $key, array(
                        'escape' => false,
                        'title' => $value['title'],
                    ));
                    echo "\n                    ";
                    echo '</li>';
                    echo "\n                ";
                }
                ?>
</ul>