<div class="row">
    <div class="msnry animated fadeInUp">
        <?php
        foreach ($items->data as $item) {
            $modelName = $item['modelName'];
            $controllerlName = $item['controllerName'];
            ?>
            <div class="col-lg-4 col-md-6 col-sm-12 col-xs-12 item">
                <div class="panel panel-<?php echo strtolower($modelName); ?>">
                    <div class="panel-heading">
                        <?php if (($this->Session->read('Auth.User.id') == $item['associated']['User']['id']) || ($this->Session->read('Auth.User.role') == 'admin')) { ?>
                        <div class="icons">
                            <?php echo $this->Html->link('<i class="fa fa-pencil" title="' . __('Edit') . '"></i>', array('controller'=>strtolower($controllerlName), 'action'=>'edit', $item['id']), array('escape' => false)); ?>
                        <?php echo $this->Html->link('<i class="fa fa-times" title="' . __('Delete') . '"></i>', '#', array('escape' => false, 'class' => 'confirm_action', 'data-toggle' => 'modal', 'data-target' => '#confirmModal', 'data-controller' => strtolower($controllerlName), 'data-action' => 'delete', 'data-item_id' => $item['id'])); ?>
                        </div>
                        <?php } ?>
                        <p class="datetime"><i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $item['created'], null, Configure::read('CFG.timezone')); ?><?php echo $item['admin'] ? ' <i class="fa fa-fw fa-lock" title="' . __('Administrators only') . '"></i>' : null; ?></p>
                        <h2><?php echo $item['title']; ?></h2>
                        
                        
                        <div class="profile-wrapper">                        
                            <?php echo $this->Html->link('<img src="' . $item['associated']['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $item['associated']['User']['id']), array('escape' => false)); ?>
                        </div> 
                        <div class="profile-name">
                            <?php echo $this->Html->link($item['associated']['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $item['associated']['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $item['associated']['User']['id']), array('escape' => false)); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-body">
                        <?php
                        if ($modelName == 'News') {
                            echo $this->Text->truncate(
                                $item['content'],
                                300,
                                array(
                                    'ellipsis' => '...',
                                    'exact' => false,
                                    'html' => true
                                )
                            );
                        } elseif ($modelName == 'Event') {
                            ?>
                            <ul>
                                <?php
                                if ($item['start_date'] == $item['end_date']) {
                                    ?>
                                    <li><i class="fa fa-calendar-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['start_date'], null, Configure::read('CFG.timezone')); ?></li>
                                    <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['start_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <li><i class="fa fa-arrow-left fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['end_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <?php
                                } else {
                                    ?>
                                    <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['start_date'], null, Configure::read('CFG.timezone')); ?> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['start_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <li><i class="fa fa-arrow-right fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format'), $item['end_date'], null, Configure::read('CFG.timezone')); ?> <?php echo $this->Time->format(Configure::read('CFG.time_format'), $item['end_time'], null, Configure::read('CFG.timezone')); ?></li>
                                    <?php
                                }
                                ?>
                                <?php if ($item['location']) { ?>
                                <li><i class="fa fa-location-arrow fa-fw"></i> <a href="https://www.google.com/maps/dir//<?php echo str_replace(' ', '+', $item['location']); ?>" target="_blank"><?php echo $item['location']; ?></a></li>
                                <?php } ?>
                            </ul>
                            <?php
                            echo $this->Text->truncate(
                                $item['content'],
                                100,
                                array(
                                    'ellipsis' => '...',
                                    'exact' => false,
                                    'html' => true
                                )
                            );
                        } elseif ($modelName == 'File') {
                            echo $this->Text->truncate(
                                $item['content'],
                                200,
                                array(
                                    'ellipsis' => '...',
                                    'exact' => false,
                                    'html' => true
                                )
                            );
                            ?>
                            <ul class="files">
                                <?php
                                foreach ($item['associated']['FileAttachment'] as $file) {
                                    $filename = explode('/', $file['file']);
                                    ?>
                                    <li><a href="<?php echo $file['file']; ?>" target="_blank"><?php echo wordwrap(end($filename), 30, "-<br>\n", true); ?></a></li>
                                    <?php
                                } 
                                ?>
                            </ul>
                            <?php
                        } elseif ($modelName == 'Message') {
                            ?>
                            <div class="separator">
                                <p><?php echo $this->Text->truncate(
                                    $item['content'],
                                    200,
                                    array(
                                        'ellipsis' => '...',
                                        'exact' => false,
                                        'html' => true
                                    )
                                ); ?></p>
                            </div>
                            <?php
                            $i = 0;
                            foreach ($item['associated']['MessageComment'] as $comment) {
                                if ($i == 2) {
                                    break;
                                }
                                ?>
                                <div class="separator">
                                    <div class="profile-wrapper">
                                        <?php echo $this->Html->link('<img src="' . $comment['User']['Profile']['photo'] . '" width="30" height="30" />', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                                    </div> 
                                    <div class="profile-name">
                                        <?php echo $this->Html->link($comment['User']['Profile']['first_name'] . ' <span class="semi-bold">' . $comment['User']['Profile']['last_name'] . '</span>', array('controller'=>'users', 'action'=>'view', $comment['User']['id']), array('escape' => false)); ?>
                                    </div>
                                    <div class="clearfix"></div>
                                    <small>
                                        <i class="fa fa-clock-o fa-fw"></i> <?php echo $this->Time->format(Configure::read('CFG.date_format') . ' ' . Configure::read('CFG.time_format'), $comment['created'], null, Configure::read('CFG.timezone')); ?>
                                    </small>
                                    <p><?php echo $this->Text->truncate(
                                        $comment['content'],
                                        100,
                                        array(
                                            'ellipsis' => '...',
                                            'exact' => false,
                                            'html' => true
                                        )
                                    ); ?></p>
                                </div>
                                <?php
                                $i++;
                            }
    
                            if (count($item['associated']['MessageComment']) != $i) {
                                ?>
                                <div class="separator">
                                    <p>...</p>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <div class="panel-footer">
                        <div class="icons">
                            <?php echo $this->Html->link('<i class="fa fa-fw fa-comment" title="' . __('Comments') . '"></i> ' . count($item['associated'][$modelName.'Comment']), array('controller'=>strtolower($controllerlName), 'action'=>'view', $item['id'], '#'=>'comments'), array('escape' => false)); ?>
                            <?php 
                            if ($modelName == 'Event') {
                                echo '<i class="fa fa-fw fa-thumbs-up" title="' . __('Present') . '"></i> ' . count($item['associated']['EventAttendeePresent']);
                                echo '<i class="fa fa-fw fa-thumbs-down" title="' . __('Absent') . '"></i> ' . count($item['associated']['EventAttendeeAbsent']);
                            } 
                            ?>
                        </div>
                        <div class="pull-right">
                            <?php echo $this->Html->link('<i class="fa fa-arrow-circle-o-right"></i> ' . __('More info'), array('controller'=>strtolower($controllerlName), 'action'=>'view', $item['id']), array('class' => 'btn btn-primary', 'escape' => false)); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
</div>

<?php
if(count($items->numbers) > 1) {
    ?>
    <div class="row">
        <div class="col-xs-12 text-center paginate">
            <hr class="colered">
            <ul class="pagination">
            <?php
            foreach($items->numbers as $num) {
                $url = '/dashboard/?';
                if(isset($_GET['q'])) {
                    $url .= 'q=' . $_GET['q'] . '&';
                }
                $url .= 'p='.$num;
                
                if((isset($_GET['p']) && $num == $_GET['p']) || ($num == 1 && !isset($_GET['p']))) {
                    echo '<li class="active"><a href="'.$url.'">'.$num.'</a></li>';
                }else{
                    echo '<li><a href="'.$url.'">'.$num.'</a></li>';
                }
            }
            ?>
            </ul>
        </div>
    </div>
    <?php
}
?>

<script type="text/javascript">
$(document).ready(function() {
    msnry();
});

function msnry() {
    $('.msnry').imagesLoaded(function() {
        $('.msnry').masonry({
            itemSelector  : '.item',
            columnWidth   : '.item',
            isAnimated    : true
        });
    });
}
</script>