<?php
App::uses('AppModel', 'Model');
class User extends AppModel 
{
    public $name = 'User';
    public $useTable = 'users';
    public $hasOne = array(
        'Profile' => array(
            'className' => 'Profile',
            'conditions' => array('Profile.deleted' => '0'),
            'dependent' => true
        ),
        'UserSetting' => array(
            'className' => 'UserSetting',
            'dependent' => true
        ),
    );
    public $hasMany = array(
        'UserFollow' => array(
            'className' => 'UserFollow',
            'conditions' => array('UserFollow.deleted' => '0'),
            'order' => 'UserFollow.created DESC'
        ),
        'UserFollower' => array(
            'className' => 'UserFollow',
            'conditions' => array('UserFollower.deleted' => '0'),
            'order' => 'UserFollower.created DESC',
            'foreignKey' => 'follow_user_id'
        ),
        'News' => array(
            'className' => 'News',
            'conditions' => array('News.deleted' => '0'),
            'order' => 'News.created DESC'
        ),
        'Event' => array(
            'className' => 'Event',
            'conditions' => array('Event.deleted' => '0'),
            'order' => 'Event.created DESC'
        ),
        'File' => array(
            'className' => 'File',
            'conditions' => array('File.deleted' => '0'),
            'order' => 'File.created DESC'
        ),
        'Message' => array(
            'className' => 'Message',
            'conditions' => array('Message.deleted' => '0'),
            'order' => 'Message.created DESC'
        ),
    );

    public function afterFind($results, $primary = false) 
    {
        if($primary) {
            $users = array();
            foreach($results as $user) {
                if (isset($user['UserFollow'])) {
                    $array = array();
                    foreach($user['UserFollow'] as $follow) {
                        $array[] = $follow['follow_user_id'];
                    }
                    $user['UserFollow'] = $array;
                }
                if (isset($user['UserFollower'])) {
                    $array = array();
                    foreach($user['UserFollower'] as $follow) {
                        $array[] = $follow['user_id'];
                    }
                    $user['UserFollower'] = $array;
                }
                $users[] = $user;
            }
            $results = $users;
        }

        return $results;
    }

    public function beforeSave($options = array()) 
    {
        if (isset($this->data[$this->alias]['password'])) {
            $this->data[$this->alias]['password'] = AuthComponent::password($this->data[$this->alias]['password']);
        }
        return parent::beforeSave();
    }
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $user)) !== false;
    }
    
    public function getItems($role = 'user', $user_id = null, $order = 'created', $search = null) 
    {        
        $this->News->Behaviors->load('Containable');
        if ($role == 'user') {
            $conditions = array(
                'News.admin' => '0',
                'News.deleted' => 0,
                (!$user_id) ? : 'News.user_id' => $user_id
            ); 
        } else {
            $conditions = array(
                'News.deleted' => 0,
                (!$user_id) ? : 'News.user_id' => $user_id
            ); 
        }
        if ($search) {
            $conditions['OR'] = array(
                'News.title Like' => '%'.$search.'%',
                'News.content Like' => '%'.$search.'%',
                'User.email Like' => '%'.$search.'%',
                'Profile.first_name Like' => '%'.$search.'%',
                'Profile.last_name Like' => '%'.$search.'%',
            );
        }
        
        $news = $this->News->find('all', array(
            'conditions' => $conditions,
            'order' => array('News.created DESC'),
            'contain' => array(
                'User' => array(
                    'Profile',
                ),
                'NewsComment'
            ),
            'recursive' => 1,
            'joins' => array(
                array(
                    'table' => 'profiles',
                    'alias' => 'Profile',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Profile.user_id = News.user_id'
                    )
                )
            ),
        ));
        $this->Event->Behaviors->load('Containable');
        if ($role == 'user') {
            $conditions = array(
                'Event.admin' => '0',
                'Event.deleted' => 0,
                (!$user_id) ? : 'Event.user_id' => $user_id
            ); 
        } else {
            $conditions = array(
                'Event.deleted' => 0,
                (!$user_id) ? : 'Event.user_id' => $user_id
            ); 
        }
        if ($search) {
            $conditions['OR'] = array(
                'Event.title Like' => '%'.$search.'%',
                'Event.content Like' => '%'.$search.'%',
                'Event.location Like' => '%'.$search.'%',
                'User.email Like' => '%'.$search.'%',
                'Profile.first_name Like' => '%'.$search.'%',
                'Profile.last_name Like' => '%'.$search.'%',
            );
        }
        
        $events = $this->Event->find('all', array(
            'conditions' => $conditions,
            'order' => array('Event.created DESC'),
            'contain' => array(
                'User' => array(
                    'Profile',
                ),
                'EventComment',
                'EventAttendeePresent',
                'EventAttendeeAbsent',
            ),
            'recursive' => 1,
            'joins' => array(
                array(
                    'table' => 'profiles',
                    'alias' => 'Profile',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Profile.user_id = Event.user_id'
                    )
                )
            ),
        ));
        $this->File->Behaviors->load('Containable');
        if ($role == 'user') {
            $conditions = array(
                'File.admin' => '0',
                'File.deleted' => 0,
                (!$user_id) ? : 'File.user_id' => $user_id
            ); 
        } else {
            $conditions = array(
                'File.deleted' => 0,
                (!$user_id) ? : 'File.user_id' => $user_id
            ); 
        }
        if ($search) {
            $conditions['OR'] = array(
                'File.title Like' => '%'.$search.'%',
                'File.content Like' => '%'.$search.'%',
                'User.email Like' => '%'.$search.'%',
                'Profile.first_name Like' => '%'.$search.'%',
                'Profile.last_name Like' => '%'.$search.'%',
            );
        }
        
        $files = $this->File->find('all', array(
            'conditions' => $conditions,
            'order' => array('File.created DESC'),
            'contain' => array(
                'User' => array(
                    'Profile',
                ),
                'FileAttachment',
                'FileComment'
            ),
            'recursive' => 1,
            'joins' => array(
                array(
                    'table' => 'profiles',
                    'alias' => 'Profile',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Profile.user_id = File.user_id'
                    )
                )
            ),
        ));
        $this->Message->Behaviors->load('Containable');
        if ($role == 'user') {
            $conditions = array(
                'Message.admin' => '0',
                'Message.deleted' => 0,
                (!$user_id) ? : 'Message.user_id' => $user_id
            ); 
        } else {
            $conditions = array(
                'Message.deleted' => 0,
                (!$user_id) ? : 'Message.user_id' => $user_id
            ); 
        }
        if ($search) {
            $conditions['OR'] = array(
                'Message.title Like' => '%'.$search.'%',
                'Message.content Like' => '%'.$search.'%',
                'User.email Like' => '%'.$search.'%',
                'Profile.first_name Like' => '%'.$search.'%',
                'Profile.last_name Like' => '%'.$search.'%',
            );
        }
        
        $messages = $this->Message->find('all', array(
            'conditions' => $conditions,
            'order' => array('Message.created DESC'),
            'contain' => array(
                'User' => array(
                    'Profile',
                ),
                'MessageComment' => array(
                    'User' => array(
                        'Profile',
                    ),
                ),
            ),
            'recursive' => 1,
            'joins' => array(
                array(
                    'table' => 'profiles',
                    'alias' => 'Profile',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Profile.user_id = Message.user_id'
                    )
                )
            ),
        ));
        
        $items = array();
        foreach ($news as $key => $value) {
            $value['News']['modelName'] = 'News';
            $value['News']['controllerName'] = 'News';
            $value['News']['icon'] = 'bullhorn';
            $associated = $value;
            unset($associated['News']);
            $value['News']['associated'] = $associated;
            $items[] = $value['News'];
        }
        foreach ($events as $key => $value) {
            $value['Event']['modelName'] = 'Event';
            $value['Event']['controllerName'] = 'Events';
            $value['Event']['icon'] = 'calendar';
            $associated = $value;
            unset($associated['Event']);
            $value['Event']['associated'] = $associated;
            $items[] = $value['Event'];
        }
        foreach ($files as $key => $value) {
            $value['File']['modelName'] = 'File';
            $value['File']['controllerName'] = 'Files';
            $value['File']['icon'] = 'file-o';
            $associated = $value;
            unset($associated['File']);
            $value['File']['associated'] = $associated;
            $items[] = $value['File'];
        }
        foreach ($messages as $key => $value) {
            $value['Message']['modelName'] = 'Message';
            $value['Message']['controllerName'] = 'Messages';
            $value['Message']['icon'] = 'comments-o';
            $associated = $value;
            unset($associated['Message']);
            $value['Message']['associated'] = $associated;
            $items[] = $value['Message'];
        }      
        
        if (sizeof($items) > 1) {
            $items = Set::sort($items, '/' . $order, 'DESC');
        }
        
        return $items;
    }
    
    public function access($user_id) 
    {
        if (!$user_id) {
            return false;
        }
        $user = $this->find('first', array(
                'conditions' => array('User.id' => $user_id, 'User.deleted' => 0),
            )
        );
        if (!$user) {
            return $this->redirect(array('action'=>'logout'));
        }
        
        if (
            (empty($user['Profile']['first_name'])) ||
            (empty($user['Profile']['last_name'])) ||
            (empty($user['Profile']['address'])) ||
            (empty($user['Profile']['zip'])) ||
            (empty($user['Profile']['city']))
        ) {
            return false;
        }
        
        return true;
    }
}