<?php
App::uses('AppModel', 'Model');
class Profile extends AppModel 
{
    public $name = 'Profile';
    public $useTable = 'profiles';
    public $belongsTo = array('User');
    public $actsAs = array(
        'Upload.Upload' => array(
            'photo' => array(
                'path' => '{ROOT}webroot{DS}data{DS}profiles{DS}{field}{DS}',
                'fields' => array(
                    'dir' => 'photo_dir'
                ),
                'thumbnailMethod' => 'php',
                'thumbnailSizes' => array(
                    'thumb' => '200x200'
                )
            ),
            'banner' => array(
                'path' => '{ROOT}webroot{DS}data{DS}profiles{DS}{field}{DS}',
                'fields' => array(
                    'dir' => 'banner_dir'
                )
            )
        ),
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'first_name', 'middle_name', 'last_name', 'company', 'function', 'address', 'zip', 'city', 'country', 
                'phone', 'linkedin', 'twitter', 'facebook', 'hobbies', 'knowledge', 'references'
            )
        )
    );
    public $virtualFields = array(
        'name' => 'CONCAT(Profile.first_name, " ", Profile.last_name)'
    );
    
    public function afterFind($results, $primary = false) 
    {
        if (array_key_exists(0, $results)) {
            if ((!empty($results[0]['Profile']['photo'])) && (!empty($results[0]['Profile']['photo_dir']))) {
                $big_photo = 'data/profiles/photo/' . $results[0]['Profile']['photo_dir'] . '/' . $results[0]['Profile']['photo'];
                if (file_exists(WWW_ROOT.$big_photo)) {
                    $results[0]['Profile']['big_photo'] = '/' . $big_photo;
                } else {
                    $results[0]['Profile']['big_photo'] = '/assets/images/photo.png';
                }
                $photo = 'data/profiles/photo/' . $results[0]['Profile']['photo_dir'] . '/thumb_' . $results[0]['Profile']['photo'];
                if (file_exists(WWW_ROOT.$photo)) {
                    $results[0]['Profile']['photo'] = '/' . $photo;
                } else {
                    $results[0]['Profile']['photo'] = '/assets/images/photo.png';
                }
            } else {
                $results[0]['Profile']['photo'] = '/assets/images/photo.png';
            }
            if ((!empty($results[0]['Profile']['banner'])) && (!empty($results[0]['Profile']['banner_dir']))) {
                $banner = 'data/profiles/banner/' . $results[0]['Profile']['banner_dir'] . '/' . $results[0]['Profile']['banner'];
                if (file_exists(WWW_ROOT.$banner)) {
                    $results[0]['Profile']['banner'] = '/' . $banner;
                } else {
                    $results[0]['Profile']['banner'] = '';
                }
            }
        } else {
            if ((!empty($results['photo'])) && (!empty($results['photo_dir']))) {
                $big_photo = 'data/profiles/photo/' . $results['photo_dir'] . '/' . $results['photo'];
                if (file_exists(WWW_ROOT.$big_photo)) {
                    $results['big_photo'] = '/' . $big_photo;
                } else {
                    $results['big_photo'] = '/assets/images/photo.png';
                }
                $photo = 'data/profiles/photo/' . $results['photo_dir'] . '/thumb_' . $results['photo'];
                if (file_exists(WWW_ROOT.$photo)) {
                    $results['photo'] = '/' . $photo;
                } else {
                    $results['photo'] = '/assets/images/photo.png';
                }
            } else {
                $results['big_photo'] = '/assets/images/photo.png';
                $results['photo'] = '/assets/images/photo.png';
            }
            if ((!empty($results['banner'])) && (!empty($results['banner_dir']))) {
                $banner = 'data/profiles/banner/' . $results['banner_dir'] . '/' . $results['banner'];
                if (file_exists(WWW_ROOT.$banner)) {
                    $results['banner'] = '/' . $banner;
                } else {
                    $results['banner'] = '';
                }
            }
        }

        return $results;
    }
    
}
