<?php
App::uses('AppModel', 'Model');
class NewsComment extends AppModel 
{
    public $name = 'NewsComment';
    public $useTable = 'news_comments';
    
    public $belongsTo = array('News','User');
    
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'content'
            )
        )
    );
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }
}