<?php
App::uses('AppModel', 'Model');
class News extends AppModel 
{
    public $name = 'News';
    public $useTable = 'news';
    
    public $belongsTo = array('User');
    public $hasMany = array(
        'NewsComment' => array(
            'className' => 'NewsComment',
            'conditions' => array('NewsComment.deleted' => '0'),
            'order' => 'NewsComment.created DESC'
        )
    );
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'title', 'content'
            )
        )
    );
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }
}