<?php
App::uses('AppModel', 'Model');
class MessageComment extends AppModel 
{
    public $name = 'MessageComment';
    public $useTable = 'message_comments';
    
    public $belongsTo = array('Message','User');
    
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'content'
            )
        )
    );
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }    
}