<?php
App::uses('AppModel', 'Model');
class Message extends AppModel 
{
    public $name = 'Message';
    public $useTable = 'messages';
    
    public $belongsTo = array('User');
    public $hasMany = array(
        'MessageComment' => array(
            'className' => 'MessageComment',
            'conditions' => array('MessageComment.deleted' => '0'),
            'order' => 'MessageComment.created DESC'
        )
    );
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'title', 'content'
            )
        )
    );
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }
}