<?php
App::uses('AppModel', 'Model');
class Install extends AppModel 
{
    public $name = 'Install';
    public $useTable = false;
    
    public function import_structure($prefix = '') 
    {
        if (!Configure::read('install')) {
            return false;
        }
        
        $sql = "DROP TABLE IF EXISTS `%prefix%activities`;
            CREATE TABLE `%prefix%activities` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `model` varchar(100) NOT NULL,
              `method` varchar(100) NOT NULL,
              `item_id` int(11) DEFAULT NULL,
              `description` text NOT NULL,
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

            DROP TABLE IF EXISTS `%prefix%configurations`;
            CREATE TABLE `%prefix%configurations` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `key` varchar(50) NOT NULL,
              `value` text NOT NULL,
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`),
              UNIQUE KEY `name` (`key`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%events`;
            CREATE TABLE `%prefix%events` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `title` text NOT NULL,
              `content` text NOT NULL,
              `start_date` date NOT NULL,
              `end_date` date NOT NULL,
              `start_time` time NOT NULL,
              `end_time` time NOT NULL,
              `location` text NOT NULL,
              `admin` tinyint(1) NOT NULL DEFAULT '0',
              `deleted` tinyint(1) DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%event_attendees`;
            CREATE TABLE `%prefix%event_attendees` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `event_id` int(11) NOT NULL,
              `user_id` int(11) NOT NULL,
              `status` enum('present','absent') NOT NULL,
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%event_comments`;
            CREATE TABLE `%prefix%event_comments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `event_id` int(11) NOT NULL,
              `user_id` int(11) NOT NULL,
              `content` text NOT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%files`;
            CREATE TABLE `%prefix%files` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `title` text NOT NULL,
              `content` text NOT NULL,
              `file` varchar(255) NOT NULL,
              `file_dir` varchar(255) NOT NULL,
              `admin` tinyint(1) NOT NULL DEFAULT '0',
              `deleted` tinyint(1) DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%file_attachments`;
            CREATE TABLE `%prefix%file_attachments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `file_id` int(11) NOT NULL,
              `file` text NOT NULL,
              `file_dir` text NOT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%file_comments`;
            CREATE TABLE `%prefix%file_comments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `file_id` int(11) NOT NULL,
              `user_id` int(11) NOT NULL,
              `content` text NOT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%messages`;
            CREATE TABLE `%prefix%messages` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `title` text NOT NULL,
              `content` text NOT NULL,
              `admin` tinyint(1) NOT NULL DEFAULT '0',
              `deleted` tinyint(1) DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%message_comments`;
            CREATE TABLE `%prefix%message_comments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `message_id` int(11) NOT NULL,
              `user_id` int(11) NOT NULL,
              `content` text NOT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%news`;
            CREATE TABLE `%prefix%news` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `title` text NOT NULL,
              `content` text NOT NULL,
              `admin` tinyint(1) NOT NULL DEFAULT '0',
              `deleted` tinyint(1) DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%news_comments`;
            CREATE TABLE `%prefix%news_comments` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `news_id` int(11) NOT NULL,
              `user_id` int(11) NOT NULL,
              `content` text NOT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%profiles`;
            CREATE TABLE `%prefix%profiles` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `first_name` varchar(255) NOT NULL,
              `middle_name` varchar(255) NOT NULL,
              `last_name` varchar(255) NOT NULL,
              `company` varchar(255) NOT NULL,
              `function` varchar(255) NOT NULL,
              `address` varchar(255) NOT NULL,
              `zip` varchar(50) NOT NULL,
              `city` varchar(255) NOT NULL,
              `country` varchar(255) NOT NULL,
              `phone` varchar(50) NOT NULL,
              `linkedin` text NOT NULL,
              `twitter` text NOT NULL,
              `facebook` text NOT NULL,
              `hobbies` text NOT NULL,
              `knowledge` text NOT NULL,
              `references` text NOT NULL,
              `photo` varchar(255) NOT NULL,
              `photo_dir` varchar(255) NOT NULL,
              `banner` varchar(255) NOT NULL,
              `banner_dir` varchar(255) NOT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%users`;
            CREATE TABLE `%prefix%users` (
              `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
              `email` varchar(255) DEFAULT NULL,
              `password` varchar(50) DEFAULT NULL,
              `role` enum('admin','user') DEFAULT NULL,
              `confirmed` tinyint(1) NOT NULL DEFAULT '1',
              `confirm_token` varchar(50) DEFAULT NULL,
              `deleted` tinyint(1) NOT NULL DEFAULT '0',
              `last_login` datetime NOT NULL,
              `created` datetime DEFAULT NULL,
              `modified` datetime DEFAULT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%user_follows`;
            CREATE TABLE `%prefix%user_follows` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `follow_user_id` int(11) NOT NULL,
              `deleted` tinyint(4) NOT NULL DEFAULT '0',
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            DROP TABLE IF EXISTS `%prefix%user_settings`;
            CREATE TABLE `%prefix%user_settings` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `user_id` int(11) NOT NULL,
              `date_format` varchar(255) NOT NULL,
              `time_format` varchar(255) NOT NULL,
              `language` varchar(10) NOT NULL,
              `timezone` varchar(255) NOT NULL,
              `created` datetime NOT NULL,
              `modified` datetime NOT NULL,
              PRIMARY KEY (`id`)
            ) ENGINE=InnoDB  DEFAULT CHARSET=latin1;
            
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(1, 'site_url', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(2, 'site_name', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(3, 'site_short_name', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(4, 'site_description', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(5, 'site_title', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(6, 'email_from_email', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(7, 'email_from_name', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(8, 'email_to_email', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(9, 'mailserver_transport', 'Mail', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(10, 'mailserver_host', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(11, 'mailserver_port', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(12, 'mailserver_username', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(13, 'mailserver_password', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(14, 'date_format', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(15, 'time_format', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(16, 'frontend', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(17, 'language', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(18, 'timezone', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(19, 'users_register', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');
            INSERT INTO `%prefix%configurations` (`id`, `key`, `value`, `created`, `modified`) VALUES(20, 'users_follow', '', '2014-01-01 00:00:00', '2014-01-01 00:00:00');";
            
        $sql = str_replace('%prefix%', $prefix, $sql);
        if ($this->query($sql)) {
            return true;
        }
        return false;
    }

}