<?php
App::uses('AppModel', 'Model');
class FileComment extends AppModel 
{
    public $name = 'FileComment';
    public $useTable = 'file_comments';
    
    public $belongsTo = array('File','User');
    
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'content'
            )
        )
    );
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }
}