<?php
App::uses('AppModel', 'Model');
class FileAttachment extends AppModel 
{
    public $name = 'FileAttachment';
    public $useTable = 'file_attachments';
    
    public $belongsTo = array('File');
    
    public $actsAs = array(
        'Upload.Upload' => array(
            'file' => array(
                'path' => '{ROOT}webroot{DS}data{DS}files{DS}{field}{DS}',
                'fields' => array(
                    'dir' => 'file_dir'
                )
            )
        )
    );
    
    public function afterFind($results, $primary = false) 
    {
        if (count($results) > 1) {
            foreach ($results as $key => $result) {
                if ((!empty($result['FileAttachment']['file'])) && (!empty($result['FileAttachment']['file_dir']))) {
                    $file = 'data/files/file/' . $result['FileAttachment']['file_dir'] . '/' . $result['FileAttachment']['file'];
                    if (file_exists(WWW_ROOT.$file)) {
                        $results[$key]['FileAttachment']['file'] = '/' . $file;
                    } else {
                        $results[$key]['FileAttachment']['file'] = '';
                    }
                }
            }
        } elseif (array_key_exists(0, $results)) {
            if ((!empty($results[0]['FileAttachment']['file'])) && (!empty($results[0]['FileAttachment']['file_dir']))) {
                $file = 'data/files/file/' . $results[0]['FileAttachment']['file_dir'] . '/' . $results[0]['FileAttachment']['file'];
                if (file_exists(WWW_ROOT.$file)) {
                    $results[0]['FileAttachment']['file'] = '/' . $file;
                } else {
                    $results[0]['FileAttachment']['file'] = '';
                }
            }
        } else {
            if ((!empty($results['file'])) && (!empty($results['file_dir']))) {
                $file = 'data/files/file/' . $results['file_dir'] . '/' . $results['file'];
                if (file_exists(WWW_ROOT.$file)) {
                    $results['file'] = '/' . $file;
                } else {
                    $results['file'] = '';
                }
            }
        }

        return $results;
    }
}