<?php
App::uses('AppModel', 'Model');
class EventComment extends AppModel 
{
    public $name = 'EventComment';
    public $useTable = 'event_comments';
    
    public $belongsTo = array('Event','User');
    
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'content'
            )
        )
    );
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }
}