<?php
App::uses('AppModel', 'Model');
class Event extends AppModel 
{
    public $name = 'Event';
    public $useTable = 'events';
    
    public $belongsTo = array('User');
    public $hasMany = array(
        'EventComment' => array(
            'className' => 'EventComment',
            'conditions' => array('EventComment.deleted' => '0'),
            'order' => 'EventComment.created DESC'
        ),
        'EventAttendee' => array(
            'className' => 'EventAttendee',
            'order' => 'EventAttendee.created ASC'
        ),
        'EventAttendeePresent' => array(
            'className' => 'EventAttendee',
            'conditions' => array('EventAttendeePresent.status' => 'present'),
            'order' => 'EventAttendeePresent.created ASC'
        ),
        'EventAttendeeAbsent' => array(
            'className' => 'EventAttendee',
            'conditions' => array('EventAttendeeAbsent.status' => 'absent'),
            'order' => 'EventAttendeeAbsent.created ASC'
        ),
    );
    public $actsAs = array(
        'HtmlPurifier.HtmlPurifier' => array(
            'config' => 'basic',
            'fields' => array(
                'title', 'content', 'start_date', 'start_time', 'end_date', 'end_time', 'location'
            )
        )
    );
    
    /*
    public function beforeSave($options = array()) 
    {
        $dates = array(
            'en' => array(
                'Y/m/d', 'Y-m-d', 'F d, Y',
            ),
            'uk' => array(
                'd/m/Y', 'd-m-Y', 'd F Y',
            ),
        );

        if (isset($this->data[$this->alias]['start_date'])) {
            if (in_array(Configure::read('CFG.date_format'), $dates['en'])) {
                $this->data[$this->alias]['start_date'] = date('Y-m-d', strtotime($this->data[$this->alias]['start_date']));
            } elseif (in_array(Configure::read('CFG.date_format'), $dates['uk'])) {
                $explode = explode('/',$this->data[$this->alias]['start_date']);
                $date = $explode[2].'/'.$explode[1].'/'.$explode[0];
                $this->data[$this->alias]['start_date'] = date('Y-m-d', strtotime($date));
            }
        }
        if (isset($this->data[$this->alias]['end_date'])) {
            if (in_array(Configure::read('CFG.date_format'), $dates['en'])) {
                $this->data[$this->alias]['end_date'] = date('Y-m-d', strtotime($this->data[$this->alias]['end_date']));
            } elseif (in_array(Configure::read('CFG.date_format'), $dates['uk'])) {
                $explode = explode('/',$this->data[$this->alias]['end_date']);
                $date = $explode[2].'/'.$explode[1].'/'.$explode[0];
                $this->data[$this->alias]['end_date'] = date('Y-m-d', strtotime($date));
            }
        }
        return parent::beforeSave();
    }
    */
    
    public function isOwnedBy($item, $user) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }
    
    public function isAdmin($item, $role) 
    {
        return $this->field('id', array('id' => $item, 'user_id' => $user)) !== false;
    }    
}