<?php
App::uses('AppModel', 'Model');
class Activity extends AppModel 
{
    public $name = 'Activity';
    public $useTable = 'activities';
    
    public $belongsTo = array(
        'ActivityUser' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
        ),
        'News' => array(
            'className' => 'News',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'News'
            )
        ),
        'NewsComment' => array(
            'className' => 'NewsComment',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'NewsComment'
            )
        ),
        'Event' => array(
            'className' => 'Event',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'Event'
            )
        ),
        'EventComment' => array(
            'className' => 'EventComment',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'EventComment'
            )
        ),
        'EventAttendee' => array(
            'className' => 'EventAttendee',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'EventAttendee'
            )
        ),
        'File' => array(
            'className' => 'File',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'File'
            )
        ),
        'FileComment' => array(
            'className' => 'FileComment',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'FileComment'
            )
        ),
        'Message' => array(
            'className' => 'Message',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'Message'
            )
        ),
        'MessageComment' => array(
            'className' => 'MessageComment',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'MessageComment'
            )
        ),
        'User' => array(
            'className' => 'User',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'User'
            )
        ),
        'Profile' => array(
            'className' => 'Profile',
            'foreignKey' => 'item_id',
            'conditions' => array(
                'Activity.model' => 'Profile'
            )
        ),
    );

}