<?php
class Pagination {
    var $data;
    var $result;
    var $numbers;
    
    public function __construct($data, $per_page) {
        $this->numbers = $this->Paginate($data, $per_page);
        $this->result = $this->fetchResult();
    }

    function Paginate($values, $per_page) {
        $total_values = count($values);
        
        if(isset($_GET['p'])){
            $current_page = $_GET['p'];
        }else{
            $current_page = 1;
        }
        $counts = ceil($total_values / $per_page);
        $param1 = ($current_page - 1) * $per_page;
        $this->data = array_slice($values, $param1, $per_page);
        
        $numbers = array();
        for($x = 1; $x <= $counts; $x++) {
            $numbers[] = $x;
        }
        return $numbers;
    }
    
    function fetchResult() {
        $resultValues = $this->data;
        return $resultValues;
    }
}