<?php
class PagesController extends AppController 
{
    public $name = 'Pages';
    public $uses = array('User', 'News', 'Event', 'File', 'Message');

    public function beforeFilter() 
    {
        parent::beforeFilter();
        
        //Everyone has access to all actions
        $this->Auth->allow();
        
        //If members is logged in redirect to back end
        if ($this->Auth->login()) {
            $this->redirect($this->Auth->redirect());
        }
    }
    
    public function home() 
    {
        //If front end in set to false in settings redirect to login screen; Else show front end
        if (Configure::read('CFG.frontend') == '0') {
            return $this->redirect(array('controller' => 'users', 'action' => 'login'));
        }
        
        $this->layout = "home";
        $this->set('title_for_layout', __('Home'));
        
        $users = $this->User->find('all', array(
            'conditions' => array('User.role' => 'admin', 'User.deleted' => 0),
            'order' => array('Profile.last_name ASC'),
            'recursive' => 1
            )
        );
        $this->set('users', $users);
    }
}
