<?php
class InstallController extends AppController 
{
    public $uses = false;
    public $files = array(
        'tmp', 
        'tmp/cache', 
        'tmp/cache/models', 
        'tmp/cache/persistent', 
        'tmp/logs', 
        'Config/core.php', 
        'Config/database.php', 
        'Config/email.php', 
        'webroot/data', 
        'webroot/data/files', 
        'webroot/data/profiles'
    );
    
    public function beforeFilter() 
    {
        parent::beforeFilter();
        
        $this->Auth->allow();
        
        if ($this->Auth->login()) {
            $this->redirect($this->Auth->redirect());
        }
    }
    
    public function index() 
    {
        if (!Configure::read('install')) {
            return $this->redirect(array('controller' => 'users', 'action' => 'login'));
        }
        $this->layout = "install";
        $this->set('title_for_layout', __('Installation'));
        
        $start = 1;
        foreach ($this->files as $file) {
            if (strpos($file, '.') !== false) {
                $type = 'file';
            } else {
                $type = 'folder';
            }
            
            if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/app/' . $file)) {
                $files[] = array(
                    'file' => $file,
                    'type' => $type,
                    'error' => 'exists',
                );
                $start = 0;
            } elseif (!is_writable($_SERVER['DOCUMENT_ROOT'] . '/app/' . $file)) {
                $files[] = array(
                    'file' => $file,
                    'type' => $type,
                    'error' => 'writable',
                );
                $start = 0;
            } else {
                $files[] = array(
                    'file' => $file,
                    'type' => $type,
                    'error' => false,
                );
            }
        }
        
        $this->set('files', $files);
        $this->set('start', $start);
    }
	
	public function create_datasource() 
	{
	    if (!Configure::read('install')) {
            return false;
        }
	    
	    $this->layout = false;
	    $this->autoRender = false;

        $db_connection = mysql_connect($this->data['Database']['database_host'], $this->data['Database']['database_user'], $this->data['Database']['database_password']);
        if (!$db_connection) {
            parent::returnJson('error', __('Failed to connect to server'));
    	    return;
        } else {
            if (!mysql_select_db($this->data['Database']['database_name'], $db_connection)) {
                parent::returnJson('error', __('Failed to connect to database'));
                return;
            }
        }
        mysql_close($db_connection);
	    
	    $content  = '<?php' . "\n";
        $content .= 'class DATABASE_CONFIG {' . "\n";
        $content .= '	public $default = array(' . "\n";
        $content .= "		'datasource' => 'Database/" . $this->data['Database']['database_source'] . "'," . "\n";
        $content .= "		'persistent' => false," . "\n";
        $content .= "		'host' => '" . $this->data['Database']['database_host'] . "'," . "\n";
        if ($this->data['Database']['database_port']) {
            $content .= "		'port' => '" . $this->data['Database']['database_port'] . "'," . "\n";
        }
        $content .= "		'login' => '" . $this->data['Database']['database_user'] . "'," . "\n";
        $content .= "		'password' => '" . $this->data['Database']['database_password'] . "'," . "\n";
        $content .= "		'database' => '" . $this->data['Database']['database_name'] . "'," . "\n";
        $content .= "		'prefix' => '" . $this->data['Database']['database_prefix'] . "'," . "\n";
        $content .= '	);' . "\n";
        $content .= '}' . "\n";
	    
	    if (file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/app/Config/database.php', $content)) {
    	    parent::returnJson('ok', __('Successfully connected to database'));
    	    return;
	    }
	    parent::returnJson('error', __('An error has occurred'));
	}
	
	public function fill_datasource() 
	{
	    if (!Configure::read('install')) {
            return false;
        }
	    
	    $this->layout = false;
	    $this->autoRender = false;
	    
	    $this->loadModel('Install');
	    if ($this->Install->import_structure($this->data['Database']['database_prefix'])) {
    	    parent::returnJson('ok', __('Successfully created database structure'));
    	    return;
	    }
	    parent::returnJson('error', __('An error has occurred'));
	}
	
	public function finish() 
	{
	    if (!Configure::read('install')) {
            return $this->redirect(array('controller' => 'users', 'action' => 'login'));
        }
        
	    $content = file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/app/Config/core.php');
	    $content = str_replace("Configure::write('install', true);", "Configure::write('install', false);", $content);
	    file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/app/Config/core.php', $content);
	    
	    return $this->redirect(array('controller' => 'users', 'action' => 'login'));
	}

}