<?php
class DashboardController extends AppController 
{
    public $name = 'Dashboard';
    public $uses = array('Dashboard', 'Activity', 'User', 'Profile', 'News', 'Event', 'File', 'Message');
    
    public function beforeFilter() 
    {
        parent::beforeFilter();
    }
    
    public function isAuthorized($user) 
    {
        if (!$this->User->access($this->Auth->user('id'))) {
            $this->Session->setFlash(__('You must first complete your profile.'), 
                'default', array('class' => 'alert alert-danger'));
            return $this->redirect(array('controller' => 'users', 'action' => 'edit', $this->Auth->user('id')));
        }
        
        return true;
    }
    
    public function index() 
    {
        if (Configure::read('CFG.users_follow')) {
            $user = $this->User->find('first', array(
                    'conditions' => array('User.id' => $this->Auth->user('id'), 'User.deleted' => 0),
                )
            );            
            $user_id = $user['UserFollow'];
            $user_id[] = $this->Auth->user('id');
        } else {
            $user_id = null;
        }
        
        if (isset($this->request->query['q'])) {
            if (empty($this->request->query['q'])) {
                return $this->redirect(array('action' => 'index'));
            }
            $items = $this->User->getItems($this->Auth->user('role'), $user_id, 'created', $this->request->query['q']);
        } else {
            //Get all items from all categories based on member role (administrator/user)
            $items = $this->User->getItems($this->Auth->user('role'), $user_id);
        }
        
        App::uses('Pagination', 'Lib');
        $paginate = new Pagination($items, 12);
        if (isset($this->request->query['p']) && empty($paginate->data)) {
            return $this->redirect(array('action' => 'index'));
        }
        
        $this->set('items', $paginate);
        $this->set('title_for_layout', __('Dashboard'));
    }
}
