<?php
class ConfigurationsController extends AppController 
{
    public $name = 'Configurations';
    public $uses = array('Configuration', 'Install');
    public $helpers = array('Html', 'Form');

    public function beforeFilter() 
    {
        parent::beforeFilter();
        
        //If user is installing Feral allow edit action
        if (Configure::read('install')) {
            $this->Auth->allow('edit'); 
        }
    }
    
    public function isAuthorized($user) 
    {
        return parent::isAuthorized($user);
    }

    function edit() 
    {
        $this->layout = false;
        
        //If data submitted save settings
        if ($this->request->is('post')) {
            foreach ($this->data['Configuration'] as $key => $value) { 
                $configuration = $this->Configuration->findByKey($key);
                if (!empty($configuration)) {
                    $configuration['Configuration']['value'] = $value;
                    $this->Configuration->save($configuration);
                }
            } 
            
            parent::returnJson('ok', __('Settings saved'));
            return;
        } else {
            $this->autoRender = false;
        }
    }
}
?>