<?php
App::uses('Component', 'Controller');
App::uses('CakeEmail', 'Network/Email');
class NotificationComponent extends Component {
    public $components = array('Auth');
    public $users = array();
    public $admins = array();
    
    public function startup(Controller $controller) {
        $userInstance = ClassRegistry::init('User');
        $userInstance->Behaviors->load('Containable');
        
        if (Configure::read('CFG.users_follow')) {
            $user = $userInstance->find('first', array(
                'conditions' => array(
                    'User.id' => $this->Auth->user('id'), 
                    'User.deleted' => 0,
                ),
                'recursive' => 2,
            ));
            if (!empty($user['UserFollower'])) {
                $this->users = $userInstance->find('all', array(
                    'conditions' => array(
                        'User.id' => $user['UserFollower'],
                        'User.deleted' => 0,
                    ),
                    'contain' => array(
                        'Profile',
                        'UserSetting',
                    ),
                    'recursive' => 1,
                ));
                $this->admins = $userInstance->find('all', array(
                    'conditions' => array(
                        'User.id' => $user['UserFollower'],
                        'User.role' => 'admin',
                        'User.deleted' => 0,
                    ),
                    'contain' => array(
                        'Profile',
                        'UserSetting',
                    ),
                    'recursive' => 1,
                ));
            }
        } else {
            $this->users = $userInstance->find('all', array(
                'conditions' => array(
                    'User.id !=' => $this->Auth->user('id'),
                    'User.deleted' => 0,
                ),
                'contain' => array(
                    'Profile',
                    'UserSetting',
                ),
                'recursive' => 1,
            ));
            $this->admins = $userInstance->find('all', array(
                'conditions' => array(
                    'User.id !=' => $this->Auth->user('id'),
                    'User.role' => 'admin',
                    'User.deleted' => 0,
                ),
                'contain' => array(
                    'Profile',
                    'UserSetting',
                ),
                'recursive' => 1,
            ));
        }
    }
    
    public function push($template, $subject = null, $view_vars = array(), $admin = false) {
        if ($admin) {
            $users = $this->admins;
        } else {
            $users = $this->users;
        }
        if(!$subject) {
            $subject = Configure::read('CFG.site_name') . ' - ' . __('Notification');
        }
        foreach ($users as $user) {
            $view_vars['name'] = $user['Profile']['name'];
            // if ($user['UserSetting']['email']) { <= Ready for notification types (e.g. email/growl/prowl/pushover/etc)
                $this->email($template, $user['User']['email'], $subject, $view_vars);
            // }
        }
        return true;
    }
    
    private function email($template, $to, $subject, $view_vars = array()) {
        $email = new CakeEmail('default');
        $email->viewVars($view_vars);
        $email->emailFormat('both');
        $email->template($template);
        $email->from(array(Configure::read('CFG.email_from_email') => Configure::read('CFG.email_from_name')));
        $email->to($to);
        $email->subject($subject);
        if ($email->send()) {
            return true;
        }
        return false;
    }
}
