<?php
App::uses('Controller', 'Controller');
class AppController extends Controller 
{
    public $components = array('Session', 'Auth');
    public $uses = array('Configuration');
    public $helpers = array('Html', 'Form', 'Time', 'Session');
    
    public $languages = array(
        'deu' => 'Deutsch',
        'eng' => 'English',
        //'spa' => 'Español',
        //'fra' => 'Français',
        //'ita' => 'Italiano',
        'nld' => 'Nederlands',
        //'por' => 'Português',
        //'tur' => 'Türkçe',
    );
    
    /**
     * Indicates whether a saving operation was blocked due to the system being in demo-mode
     * @var boolean
     */
    public static $demoBlocked = false;
 
    /**
     * Indicates whether the demo-block should be ignored for the current operation
     * @var boolean
     */
    public static $demoBlockIgnore = false;
    
    
    public function beforeFilter() 
    {
        //Load Configurations
        if (in_array('Configuration', $this->uses)) {
            $this->Configuration->load(); //$prefix is 'CFG' by default
        }
        
        $session = $this->Session->read('Auth');
        
        if (!empty($session['UserSetting']['language'])) {
            $language = $session['UserSetting']['language'];
        }
        if (!isset($language)) {
            if (Configure::read('CFG.language')) {
                $language = Configure::read('CFG.language');
            } else {
                $language = 'eng';
            }
        }
        if (!array_key_exists($language, $this->languages())) {
            $language = 'eng';
        }
        Configure::write('Config.language', $language);
        CakeSession::write('Config.language', $language);
        
        if (!empty($session['UserSetting']['date_format'])) {
            Configure::write('CFG.date_format', $session['UserSetting']['date_format']);
        }
        if (!empty($session['UserSetting']['time_format'])) {
            Configure::write('CFG.time_format', $session['UserSetting']['time_format']);
        }
        if (!empty($session['UserSetting']['timezone'])) {
            Configure::write('CFG.timezone', $session['UserSetting']['timezone']);
        }

        $this->Auth->autoRedirect = false;
        $this->Auth->loginRedirect = array(
            'controller' => 'dashboard', 'action' => 'index'
        );
        $this->Auth->logoutRedirect = array(
            'controller' => 'users', 'action' => 'login'
        );
        $this->Auth->authError = __('You have no access to this page'); 
        $this->Auth->flash['params']['class'] = 'alert alert-danger';
        $this->Auth->authorize = array('Controller');
    }
    
    public function beforeRender() 
    {
        if ($this->name == 'CakeError') {
            $this->layout = 'error';
        }
        
        //Only for demo purposes
        if (self::$demoBlocked === true) {
            $this->Session->setFlash(__('You cannot perform any changes in the demonstration system'), 
                'default', array('class' => 'alert alert-danger'));
        }
        
        $languages = $this->languages();
        
        $this->set('languages', $languages);
        $this->set('referer', $this->referer());
    }
    
    public function beforeRedirect($url, $status = null, $exit = true) 
    {
        //Only for demo purposes
        if (self::$demoBlocked === true) {
            $this->Session->setFlash(__('You cannot perform any changes in the demonstration system'), 
                'default', array('class' => 'alert alert-danger'));
        }
    }
    
    public function isAuthorized($user) 
    {
        // Admin can access every action
        if (isset($user['role']) && $user['role'] === 'admin') {
            return true;
        }
    
        // Default deny access
        return false;
    }
    
    function returnJson($status, $message = null, $other = null) 
    {
        $data = array(
            'status' => strtoupper($status),
            'msg' => $message,
            'other' => $other
        );
        $this->set(compact('data'));
    
        $this->layout = 'json';
        $this->render(false);
    }
    
    public function languages($language = null) 
    {
        if (isset($lang) && in_array($language, $this->languages)) {
            return $this->languages[$language];
        }
        return $this->languages;
    }
}
