/*
 * Fancy Text Widget
 * (c) Web factory Ltd, 2011 - 2018
 */


jQuery(function($) {
    if (typeof ftw === 'undefined') {
      return;
    } 
  
    // init JS UI for an individual FTW
    function ftw_init_widget_ui(widget) {
      $('.ftw-colorpicker', widget).not('.ftw-skip-colorpicker-init').wpColorPicker({ change: function(event, picker) { $(event.target, widget).val(picker.color.toString()).trigger('change'); } });
    }

    $(".widget-liquid-right [id*='" + ftw.id_base + "-'].widget, .inactive-sidebar [id*='" + ftw.id_base + "'].widget").each(function (i, widget) {
        ftw_init_widget_ui(widget);
    });

    $(document).on('widget-updated', function(event, widget) {
        id = $(widget).attr('id');
        if (id.indexOf(ftw.id_base) != -1) {
            ftw_init_widget_ui(widget);
        }
    });

    $(document).on('widget-added', function(event, widget) {
        id = $(widget).attr('id');
        if (id.indexOf(ftw.id_base) != -1) {
            ftw_init_widget_ui(widget);
        }
    }); // refresh GUI on widget add/update
      
  }); // onload
  