<?php
/*
Plugin Name: Fancy Text Widget
Plugin URI: http://fancy-text-widget.webfactoryltd.com
Description: Fancy, colorful, customizable text widget that fits any theme.
Author: اسکریپت دات کام
Version: 1.5
Author URI: http://www.اسکریپت.com
*/

// this is an include only WP file
if (!defined('ABSPATH')) {
  die;
}

define('WF_FTW_CORE_VER', 1.5);

global $wf_ftw_do_footer, $wf_ftw_active_fonts, $wf_ftw_nb;
$wf_ftw_do_footer = false;
$wf_ftw_active_fonts = array();
$wf_ftw_nb = 0;


class wf_ftw {
  // add hooks and filters
  static function init() {
    if (is_admin()) {
      // enqueue scripts
      add_action('admin_enqueue_scripts', array(__CLASS__, 'enqueue_scripts'));

      // aditional links in plugin description
      add_filter('plugin_action_links_' . basename(dirname(__FILE__)) . '/' . basename(__FILE__),
                 array(__CLASS__, 'plugin_action_links'));
      add_filter('plugin_row_meta', array(__CLASS__, 'plugin_meta_links'), 10, 2);

      // check if minimal required WP version is used
      self::check_wp_version(2.8);
    } else {
      add_action('wp_footer', array(__CLASS__, 'wp_footer'));
    }
  } // init


  // check if user has the minimal WP version required by the plugin
  static function check_wp_version($min_version) {
    if (!version_compare(get_bloginfo('version'), $min_version,  '>=')) {
        add_action('admin_footer', array(__CLASS__, 'min_version_error'));
    }
  } // check_wp_version


  // display error message if WP version is too low
  static function min_version_error() {
    echo '<div id="message" class="error"><p>Fancy Text Widget <b>requires WordPress version 2.8</b> or higher to function properly. You\'re using WordPress version ' . get_bloginfo('version') . '. Please upgrade.</p></div>';

    return;
  } // min_version_error


  // initialize widgets
  static function widgets_init() {
    register_widget('fancy_text');
  } // widgets init


  // enqueue CSS and JS scripts on widgets pages
  static function enqueue_scripts() {
    $uri = $_SERVER['REQUEST_URI'];

    if (strpos($uri, 'widgets.php') !== false) {
      wp_enqueue_style( 'wp-color-picker' );
      wp_enqueue_style('ftw-admin', plugin_dir_url(__FILE__) . 'css/ftw-admin.css', array(), '1.0');
      
      wp_enqueue_script( 'wp-color-picker');
      wp_enqueue_script('ftw-admin', plugin_dir_url(__FILE__) . 'js/ftw-admin.js', array('jquery'), '1.0', true);

      wp_localize_script('ftw-admin', 'ftw', array('id_base'=>'fancy_text'));
      
      
    } // if
  } // enqueue_scripts


  // add settings link to plugins page
  static function plugin_action_links($links) {
    $settings_link = '<a href="widgets.php" title="Configure your site\'s widgets">Widgets</a>';
    array_unshift($links, $settings_link);

    return $links;
  } // plugin_action_links


  // add links to plugin's description in plugins table
  static function plugin_meta_links($links, $file) {
    $documentation_link = '<a target="_blank" href="' . plugin_dir_url(__FILE__) . 'documentation/' .
                          '" title="View documentation">Documentation</a>';

    if ($file == plugin_basename(__FILE__)) {
      $links[] = $documentation_link;
    }

    return $links;
  } // plugin_meta_links
  
  // inject CSS in theme footer
  static function wp_footer() {
    global $wf_ftw_do_footer, $wf_ftw_active_fonts;
    $out = '';

    $font_files['ftw-font-waiting-for-the-sunrise'] = 'Waiting+for+the+Sunrise';
    $font_files['ftw-font-the-girl-next-door'] = 'The+Girl+Next+Door';
    $font_files['ftw-font-sue-ellen-francisco'] = 'Sue+Ellen+Francisco';
    $font_files['ftw-font-annie-use-your-telescope'] = 'Annie+Use+Your+Telescope';
    $font_files['ftw-font-indie-flower'] = 'Indie+Flower';
    $font_files['ftw-font-architects-daughter'] = 'Architects+Daughter';
    $font_files['ftw-font-just-me-again-down-here'] = 'Just+Me+Again+Down+Here';
    $font_files['ftw-font-just-another-hand'] = 'Just+Another+Hand';
    $font_files['ftw-font-covered-by-your-grace'] = 'Covered+By+Your+Grace';
    $font_files['ftw-font-schoolbell'] = 'Schoolbell';
    $font_files['ftw-font-mountains-of-christmas'] = 'Mountains+of+Christmas';
    $font_files['ftw-font-shadows-into-light'] = 'Shadows+Into+Light';
    $font_files['ftw-font-emilys-candy'] = 'Emilys+Candy';
    $font_files['ftw-font-irish-grover'] = 'Irish+Grover';
    $font_files['ftw-font-griffy'] = 'Griffy';
    $font_files['ftw-font-courgette'] = 'Courgette';
    $font_files = apply_filters('wf_ftw_font_files_list', $font_files);

    if ($wf_ftw_do_footer) {
      $css_files[] = plugins_url('/css/ftw.css', __FILE__);
      $css_files = apply_filters('wf_ftw_css_files_list', $css_files);

      foreach ($css_files as $css_file) {
        $out .= '<style type="text/css">@import url("' . $css_file . '");</style>' . "\n";
      }

      if ($wf_ftw_active_fonts) {
        foreach ($wf_ftw_active_fonts as $font => $tmp) {
          $font = '//fonts.googleapis.com/css?family=' . $font_files[$font];
          $out .= '<style type="text/css">@import url("' . $font . '");</style>' . "\n";
        }
      } // if fonts

      $out = apply_filters('wf_ftw_do_footer', $out);
      echo $out;
    } // if do_footer
  } // wp_footer


  // helper function for creating dropdowns
  static function create_select_options($options, $selected = null, $output = true) {
    $out = "\n";

    foreach ($options as $tmp) {
      if ($selected == $tmp['val']) {
        $out .= "<option selected=\"selected\" value=\"{$tmp['val']}\">{$tmp['label']}&nbsp;</option>\n";
      } else {
        $out .= "<option value=\"{$tmp['val']}\">{$tmp['label']}&nbsp;</option>\n";
      }
    } // foreach

    if ($output) {
      echo $out;
    } else {
      return $out;
    }
  } // create_select_options
} // class wf_ftw


// main widget class
class fancy_text extends WP_Widget {
  // constructor method
  function __construct() {
    $widget_ops = array('classname' => 'fancy_text', 'description' => "Fancy, colorful arbitrary text or HTML.");
    $control_ops = array('width' => 400, 'height' => 350);
    $widget_name = 'Fancy Text';

    parent::__construct('fancy_text', $widget_name, $widget_ops, $control_ops);
  } // fancy_text


  // widget HTML generator
  function widget($args, $instance) {
    global $wf_ftw_active_fonts, $wf_ftw_do_footer, $wf_ftw_nb;
    $out = '';

    extract($args);
    extract($instance);

    $wf_ftw_do_footer = true;
    if (!empty($font)) {
      $wf_ftw_active_fonts[$font] = true;
    }
    $wf_ftw_nb++;

    $title = apply_filters('widget_title', empty($instance['title']) ? '' : $instance['title'], $instance, $this->id_base);
    $text = do_shortcode($instance['text']);
    if ($instance['filter']) {
      $text = wpautop($text);
    }

    if ($font_color) {
      $font_color = ' color:' . $font_color . ' !important;';
    }

    $container_class = apply_filters('wf_ftw_container_class', '', $args, $instance);
    
    if (strpos($corners, 'snow') !== false) {
      $container_class .= ' ' . $corners;
    }

    $out .= $before_widget;
    $out .= '<div id="ftw-' . $wf_ftw_nb . '" class="ftw-container' . $container_class . '">';
    $out = apply_filters('wf_ftw_html_container_begin', $out, $args, $instance);
    $out .= '<div class="ftw-body ' . $background . ' ' . $font . '" style="background-color: ' . $instance['color'] . ' !important;' . $font_color . '"><div class="ftw-spacing">';
    if (!empty($title)) {
      $out .= '<strong>' . $title . '</strong><br />';
    }
    $out .= $text . '</div></div>';
    $out .= '<div class="ftw-footer">';
    if ($corners == 'both') {
      $out .= '<div class="ftw-footer-left"></div>';
      $out .= '<div class="ftw-footer-right"></div>';
    } elseif ($corners == 'left') {
      $out .= '<div class="ftw-footer-left"></div>';
    } elseif ($corners == 'right') {
      $out .= '<div class="ftw-footer-right"></div>';
    }
    $out .= '</div>';
    $out .= '<div class="' . $icon . ' ' . $icon_position . '"></div>';
    $out .= '</div>';
    $out .= $after_widget;

    $out = apply_filters('wf_ftw_html_before_echo', $out, $args, $instance);
    echo $out;
  } // widget


  // update widget settings
  function update($new_instance, $old_instance) {
    $instance = $new_instance;

    $instance['title'] = strip_tags($new_instance['title']);
    if (current_user_can('unfiltered_html')) {
      $instance['text'] = $new_instance['text'];
    } else {
      $instance['text'] = stripslashes(wp_filter_post_kses(addslashes($new_instance['text'])));
    }
    $instance['filter'] = isset($new_instance['filter']);
    $instance['color'] = substr($instance['color'], 0, 7);

    $instance = apply_filters('wf_ftw_update_widget', $instance, $new_instance, $old_instance);

    return $instance;
  } // update


  // widget customization form
  function form($instance) {
    $out = '';
    $default_options = array('title' => 'Widget title',
                             'text' => 'You are reading text inside a fancy text widget. There\'s no real purpose to it. It\'s just <strong>fancy</strong>!',
                             'filter' => 0,
                             'background' => 'ftw-body-horizontal-vertical-lines-paper',
                             'icon' => 'ftw-graphics-tape-2',
                             'icon_position' => 'ftw-graphics-right',
                             'font' => 'ftw-font-schoolbell',
                             'corners' => 'both',
                             'font_color' => '',
                             'color' => '#57bdcf');
    $default_options = apply_filters('wf_ftw_default_options', $default_options);

    $instance = wp_parse_args((array) $instance, $default_options);
    $title = strip_tags($instance['title']);

    $backgrounds[] = array('val' => '', 'label' => 'Plain');
    $backgrounds[] = array('val' => 'ftw-body-crumbled-paper-1', 'label' => 'Crumbled paper, less');
    $backgrounds[] = array('val' => 'ftw-body-crumbled-paper-2', 'label' => 'Crumbled paper, more');
    $backgrounds[] = array('val' => 'ftw-body-sand-paper-1', 'label' => 'Sand paper, fine');
    $backgrounds[] = array('val' => 'ftw-body-sand-paper-2', 'label' => 'Sand paper, more grainy');
    $backgrounds[] = array('val' => 'ftw-body-horizontal-lines-paper', 'label' => 'Paper with horizontal lines');
    $backgrounds[] = array('val' => 'ftw-body-horizontal-vertical-lines-paper', 'label' => 'Paper with horizontal and vertical lines');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-6', 'label' => 'Big tree');
    $backgrounds[] = array('val' => 'ftw-body-bokeh-1', 'label' => 'Bokeh, not transparent');
    $backgrounds[] = array('val' => 'ftw-body-bokeh-2', 'label' => 'Bokeh');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-5', 'label' => 'Fancy Stars');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-7', 'label' => 'Frozen window');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-8', 'label' => 'Frost');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-1', 'label' => 'Snow crystals');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-2', 'label' => 'Snow crystals, darker');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-11', 'label' => 'Snow, not transparent');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-9', 'label' => 'Snowflakes');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-4', 'label' => 'Snowflakes #2');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-10', 'label' => 'Squares');
    $backgrounds[] = array('val' => 'ftw-body-wrapping-paper-3', 'label' => 'Trees');
    $backgrounds = apply_filters('wf_ftw_backgrounds_list', $backgrounds);

    $icons[] = array('val' => '', 'label' => 'None');
    $icons[] = array('val' => 'ftw-graphics-tape-1', 'label' => 'Sticky tape vertical');
    $icons[] = array('val' => 'ftw-graphics-tape-2', 'label' => 'Stick type diagonal');
    $icons[] = array('val' => 'ftw-graphics-paperclip', 'label' => 'Paper clip');
    $icons[] = array('val' => 'ftw-graphics-paperclip-oldschool', 'label' => 'Old school paper clip');
    $icons[] = array('val' => 'ftw-graphics-pinup', 'label' => 'Safety pin');
    $icons[] = array('val' => 'ftw-graphics-pin-blue', 'label' => 'Blue pin');
    $icons[] = array('val' => 'ftw-graphics-pin-red', 'label' => 'Red pin');
    $icons[] = array('val' => 'ftw-graphics-pin-white', 'label' => 'White pin');
    $icons[] = array('val' => 'ftw-graphics-pin-green', 'label' => 'Green pin');
    $icons[] = array('val' => 'ftw-graphics-pin-black', 'label' => 'Black pin');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-16', 'label' => 'Blue ornament sticker');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-12', 'label' => 'Gingerbread cookie');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-20', 'label' => 'Gold bell sticker');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-4', 'label' => 'Green ribbon');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-6', 'label' => 'Green ornament');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-17', 'label' => 'Mistletoe sticker');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-7', 'label' => 'Orange ornament');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-9', 'label' => 'Reindeer');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-19', 'label' => 'Raindeer sticker');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-5', 'label' => 'Red gift');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-13', 'label' => 'Santa\'s little helper');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-14', 'label' => 'Santa sticker');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-1', 'label' => 'Snowman');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-11', 'label' => 'Snowman #2');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-10', 'label' => 'Snow globe');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-2', 'label' => 'Sock');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-18', 'label' => 'Sock sticker');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-3', 'label' => 'Tree');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-8', 'label' => 'Tree, animated');
    $icons[] = array('val' => 'ftw-graphics-xmas-pin-15', 'label' => 'Tree sticker');
    $icons = apply_filters('wf_ftw_icons_list', $icons);

    $icon_positions[] = array('val' => 'ftw-graphics-left', 'label' => 'Top left');
    $icon_positions[] = array('val' => 'ftw-graphics-right', 'label' => 'Top right');
    $icon_positions[] = array('val' => 'ftw-graphics-left-bottom', 'label' => 'Bottom left');
    $icon_positions[] = array('val' => 'ftw-graphics-right-bottom', 'label' => 'Bottom right');
    $icon_positions = apply_filters('wf_ftw_icon_positions_list', $icon_positions);

    $corners[] = array('val' => '', 'label' => 'Both straight');
    $corners[] = array('val' => 'both', 'label' => 'Both folded');
    $corners[] = array('val' => 'left', 'label' => 'Left folded');
    $corners[] = array('val' => 'right', 'label' => 'Right folded');
    $corners[] = array('val' => 'ftw-snow-footer-1', 'label' => 'A little bit of snow');
    $corners[] = array('val' => 'ftw-snow-footer-2', 'label' => 'A fair amount of snow');
    $corners[] = array('val' => 'ftw-snow-footer-3', 'label' => 'Snow, like there\'s a blizzard!');
    $corners = apply_filters('wf_ftw_corners_list', $corners);

    $fonts[] = array('val' => '', 'label' => 'Default, theme defined');
    $fonts[] = array('val' => 'ftw-font-the-girl-next-door', 'label' => 'The Girl Next Door');
    $fonts[] = array('val' => 'ftw-font-sue-ellen-francisco', 'label' => 'Sue Ellen Francisco');
    $fonts[] = array('val' => 'ftw-font-annie-use-your-telescope', 'label' => 'Annie Use Your Telescope');
    $fonts[] = array('val' => 'ftw-font-waiting-for-the-sunrise', 'label' => 'Waiting for the Sunrise');
    $fonts[] = array('val' => 'ftw-font-indie-flower', 'label' => 'Indie Flower');
    $fonts[] = array('val' => 'ftw-font-architects-daughter', 'label' => 'Architects Daughter');
    $fonts[] = array('val' => 'ftw-font-just-me-again-down-here', 'label' => 'Just Me Again Down Here');
    $fonts[] = array('val' => 'ftw-font-just-another-hand', 'label' => 'Just Another Hand');
    $fonts[] = array('val' => 'ftw-font-covered-by-your-grace', 'label' => 'Covered By Your Grace');
    $fonts[] = array('val' => 'ftw-font-schoolbell', 'label' => 'School bell');
    $fonts[] = array('val' => 'ftw-font-courgette', 'label' => 'Courgette');
    $fonts[] = array('val' => 'ftw-font-emilys-candy', 'label' => 'Emily\'s Candy');
    $fonts[] = array('val' => 'ftw-font-griffy', 'label' => 'Griffy');
    $fonts[] = array('val' => 'ftw-font-irish-grover', 'label' => 'Irish Grover');
    $fonts[] = array('val' => 'ftw-font-mountains-of-christmas', 'label' => 'Mountains of Christmas');
    $fonts[] = array('val' => 'ftw-font-shadows-into-light', 'label' => 'Shadows Into Light');
    $fonts = apply_filters('wf_ftw_fonts_list', $fonts);

    
    $out = apply_filters('wf_ftw_form_out_pre', $out, $this, $instance);

    $out .= '<div class="ftw-widget-container">';

    $out .= '<p><label for="' . $this->get_field_id('title') . '">Title</label>';
    $out .= '<input class="widefat" id="' . $this->get_field_id('title') . '" name="' . $this->get_field_name('title') . '" type="text" value="'. esc_attr($title) . '" /></p>';

    $out .= '<p><textarea class="widefat" rows="16" cols="20" id="' . $this->get_field_id('text') . '" name="' . $this->get_field_name('text') . '">' . $instance['text'] . '</textarea></p>';

    $out .= '<p><label style="width:auto;" for="' . $this->get_field_id('filter') . '">Automatically add paragraphs to text</label>&nbsp;&nbsp;';
    $out .= '<input id="' . $this->get_field_id('filter') . '" name="' . $this->get_field_name('filter') . '" type="checkbox" ' . checked(isset($instance['filter'])? $instance['filter']: 0, true, false) . ' /></p>';

    $out .= '<p><label for="' . $this->get_field_id('background') . '">Background:</label>&nbsp;&nbsp;';
    $out .= '<select name="' . $this->get_field_name('background') . '" id="' . $this->get_field_id('background') . '">';
    $out .= wf_ftw::create_select_options($backgrounds, $instance['background'], false);
    $out .= '</select></p>';

    $out .= '<p class="ftw-colorpicker-container"><label for="' . $this->get_field_id('color') . '">Background Color:</label>&nbsp;&nbsp;';
    $out .= '<input  class="medium-text ftw-colorpicker" data-specialtype="colorpicker" id="' . $this->get_field_id('color') . '" name="' . $this->get_field_name('color') . '" type="text" value="'. $instance['color'] . '" /></p>';

    $out .= '<p class="ftw-colorpicker-container"><label for="' . $this->get_field_id('font_color') . '">Font Color:</label>&nbsp;&nbsp;';
    $out .= '<input class="medium-text ftw-colorpicker ftw-font-color" id="' . $this->get_field_id('font_color') . '" name="' . $this->get_field_name('font_color') . '" type="text" value="'. @$instance['font_color'] . '" /></p>';

    $out .= '<p><label for="' . $this->get_field_id('font') . '">Font:</label>&nbsp;&nbsp;';
    $out .= '<select name="' . $this->get_field_name('font') . '" id="' . $this->get_field_id('font') . '">';
    $out .= wf_ftw::create_select_options($fonts, $instance['font'], false);
    $out .= '</select></p>';

    $out .= '<p><label for="' . $this->get_field_id('icon') . '">Icon:</label>&nbsp;&nbsp;';
    $out .= '<select name="' . $this->get_field_name('icon') . '" id="' . $this->get_field_id('icon') . '">';
    $out .= wf_ftw::create_select_options($icons, $instance['icon'], false);
    $out .= '</select></p>';

    $out .= '<p><label for="' . $this->get_field_id('icon_position') . '">Icon Position:</label>&nbsp;&nbsp;';
    $out .= '<select name="' . $this->get_field_name('icon_position') . '" id="' . $this->get_field_id('icon_position') . '">';
    $out .= wf_ftw::create_select_options($icon_positions, $instance['icon_position'], false);
    $out .= '</select></p>';

    $out .= '<p><label for="' . $this->get_field_id('corners') . '">Corners:</label>&nbsp;&nbsp;';
    $out .= '<select name="' . $this->get_field_name('corners') . '" id="' . $this->get_field_id('corners') . '">';
    $out .= wf_ftw::create_select_options($corners, $instance['corners'], false);
    $out .= '</select></p>';

    $out .= '</div>';

    $out = apply_filters('wf_ftw_form_out_post', $out, $this, $instance);
    echo $out;
  } // form
} // class fancy_text


// hook everything up
add_action('init',         array('wf_ftw', 'init'));
add_action('widgets_init', array('wf_ftw', 'widgets_init'));
