<?php
/*
Plugin Name: Elfsight Countdown Timer CC
Description: Create various counters and timers to stimulate purchasing on your website
Plugin URI: https://elfsight.com/countdown-timer-widget/codecanyon/?utm_source=markets&utm_medium=codecanyon&utm_campaign=countdown-timer&utm_content=plugin-site
Version: 1.0.0
Author: اسکریپت دات کام
Author URI: https://www.اسکریپت.com
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_countdown_timer_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_countdown_timer_config = json_decode(file_get_contents($elfsight_countdown_timer_config_path), true);

new ElfsightCountdownTimerPlugin(
    array(
        'name' => 'Countdown Timer',
        'description' => 'Create various counters and timers to stimulate purchasing on your website',
        'slug' => 'elfsight-countdown-timer',
        'version' => '1.0.0',
        'text_domain' => 'elfsight-countdown-timer',
        'editor_settings' => $elfsight_countdown_timer_config['settings'],
        'editor_preferences' => $elfsight_countdown_timer_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-countdown-timer.js', __FILE__),

        'plugin_name' => 'Elfsight Countdown Timer',
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => 'https://a.elfsight.com/updates/v1/',

        'preview_url' => plugins_url('preview/index.html', __FILE__),
        'observer_url' => plugins_url('preview/countdown-timer-observer.js', __FILE__),

        'product_url' => 'https://codecanyon.net/user/elfsight/portfolio?ref=Elfsight',
        'support_url' => 'https://elfsight.ticksy.com/submit/#100014349',
    )
);

?>