SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


CREATE TABLE `addon` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `installed` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `event` (
  `app_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `platform` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `etl_tstamp` int(11) DEFAULT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `dvce_tstamp` int(11) DEFAULT NULL,
  `event` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_id` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `txn_id` int(11) DEFAULT NULL,
  `name_tracker` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `v_tracker` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `v_collector` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `v_etl` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_ipaddress` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_fingerprint` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domain_userid` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domain_sessionidx` smallint(6) DEFAULT NULL,
  `network_userid` varchar(38) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_region` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_city` varchar(75) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_zipcode` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_latitude` double DEFAULT NULL,
  `geo_longitude` double DEFAULT NULL,
  `geo_region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_url` text COLLATE utf8_unicode_ci,
  `page_title` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_referrer` text COLLATE utf8_unicode_ci,
  `page_urlscheme` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlhost` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlport` int(11) DEFAULT NULL,
  `page_urlpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlquery` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlfragment` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlscheme` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlhost` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlport` int(11) DEFAULT NULL,
  `refr_urlpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlquery` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlfragment` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_medium` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_source` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_term` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_medium` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_source` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_term` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_campaign` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contexts` text COLLATE utf8_unicode_ci,
  `se_category` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_action` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_label` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_property` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_value` double DEFAULT NULL,
  `unstruct_event` text COLLATE utf8_unicode_ci,
  `tr_orderid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_affiliation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_total` decimal(18,2) DEFAULT NULL,
  `tr_tax` decimal(18,2) DEFAULT NULL,
  `tr_shipping` decimal(18,2) DEFAULT NULL,
  `tr_city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_orderid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_sku` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_category` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_price` decimal(18,2) DEFAULT NULL,
  `ti_quantity` int(11) DEFAULT NULL,
  `pp_xoffset_min` int(11) DEFAULT NULL,
  `pp_xoffset_max` int(11) DEFAULT NULL,
  `pp_yoffset_min` int(11) DEFAULT NULL,
  `pp_yoffset_max` int(11) DEFAULT NULL,
  `useragent` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_family` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_renderengine` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_lang` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_features_pdf` tinyint(1) DEFAULT NULL,
  `br_features_flash` tinyint(1) DEFAULT NULL,
  `br_features_java` tinyint(1) DEFAULT NULL,
  `br_features_director` tinyint(1) DEFAULT NULL,
  `br_features_quicktime` tinyint(1) DEFAULT NULL,
  `br_features_realplayer` tinyint(1) DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) DEFAULT NULL,
  `br_features_gears` tinyint(1) DEFAULT NULL,
  `br_features_silverlight` tinyint(1) DEFAULT NULL,
  `br_cookies` tinyint(1) DEFAULT NULL,
  `br_colordepth` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_viewwidth` int(11) DEFAULT NULL,
  `br_viewheight` int(11) DEFAULT NULL,
  `os_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_family` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_manufacturer` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_timezone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_ismobile` tinyint(1) DEFAULT NULL,
  `dvce_screenwidth` int(11) DEFAULT NULL,
  `dvce_screenheight` int(11) DEFAULT NULL,
  `doc_charset` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_width` int(11) DEFAULT NULL,
  `doc_height` int(11) DEFAULT NULL,
  `geo_timezone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_clickid` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_network` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `etl_tags` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_sent_tstamp` int(11) DEFAULT NULL,
  `domain_sessionid` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `use_password` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `authorized_urls` tinyint(1) NOT NULL DEFAULT '0',
  `urls` varchar(2555) COLLATE utf8_unicode_ci DEFAULT NULL,
  `schedule` tinyint(1) NOT NULL DEFAULT '0',
  `schedule_start_date` int(11) DEFAULT NULL,
  `schedule_end_date` int(11) DEFAULT NULL,
  `total_limit` tinyint(1) NOT NULL DEFAULT '0',
  `total_limit_number` int(11) DEFAULT NULL,
  `total_limit_period` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip_limit` tinyint(1) NOT NULL DEFAULT '0',
  `ip_limit_number` int(11) DEFAULT NULL,
  `ip_limit_period` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `save` tinyint(1) NOT NULL DEFAULT '1',
  `resume` tinyint(1) NOT NULL DEFAULT '0',
  `autocomplete` tinyint(1) NOT NULL DEFAULT '1',
  `novalidate` tinyint(1) NOT NULL DEFAULT '0',
  `analytics` tinyint(1) NOT NULL DEFAULT '1',
  `honeypot` tinyint(1) NOT NULL DEFAULT '1',
  `recaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `language` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en-US',
  `message` text COLLATE utf8_unicode_ci,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_chart` (
  `form_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `gsX` int(11) DEFAULT NULL,
  `gsY` int(11) DEFAULT NULL,
  `gsW` int(11) DEFAULT NULL,
  `gsH` int(11) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_confirmation` (
  `id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `type` int(1) NOT NULL DEFAULT '0',
  `message` text COLLATE utf8_unicode_ci,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `send_email` tinyint(1) NOT NULL DEFAULT '0',
  `mail_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_message` text COLLATE utf8_unicode_ci,
  `mail_from_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_receipt_copy` tinyint(1) DEFAULT '0',
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_data` (
  `id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `builder` mediumtext COLLATE utf8_unicode_ci,
  `fields` mediumtext COLLATE utf8_unicode_ci,
  `html` mediumtext COLLATE utf8_unicode_ci,
  `height` int(5) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_email` (
  `id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` int(1) NOT NULL DEFAULT '0',
  `message` text COLLATE utf8_unicode_ci,
  `plain_text` tinyint(1) NOT NULL DEFAULT '0',
  `attach` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_rule` (
  `id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `opposite` tinyint(1) NOT NULL DEFAULT '1',
  `conditions` mediumtext COLLATE utf8_unicode_ci,
  `actions` mediumtext COLLATE utf8_unicode_ci,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_submission` (
  `id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `new` tinyint(1) NOT NULL DEFAULT '1',
  `important` tinyint(1) NOT NULL DEFAULT '0',
  `sender` text COLLATE utf8_unicode_ci,
  `data` text COLLATE utf8_unicode_ci,
  `ip` tinytext COLLATE utf8_unicode_ci,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_submission_file` (
  `id` int(11) NOT NULL,
  `submission_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `field` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `extension` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `size` int(11) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_ui` (
  `id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `theme_id` int(11) DEFAULT NULL,
  `js_file` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `form_user` (
  `form_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `log_event` (
  `app_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `platform` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `etl_tstamp` int(11) DEFAULT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `dvce_tstamp` int(11) DEFAULT NULL,
  `event` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `event_id` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `txn_id` int(11) DEFAULT NULL,
  `name_tracker` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `v_tracker` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `v_collector` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `v_etl` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_ipaddress` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user_fingerprint` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domain_userid` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domain_sessionidx` smallint(6) DEFAULT NULL,
  `network_userid` varchar(38) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_region` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_city` varchar(75) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_zipcode` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_latitude` double DEFAULT NULL,
  `geo_longitude` double DEFAULT NULL,
  `geo_region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_url` text COLLATE utf8_unicode_ci,
  `page_title` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_referrer` text COLLATE utf8_unicode_ci,
  `page_urlscheme` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlhost` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlport` int(11) DEFAULT NULL,
  `page_urlpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlquery` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `page_urlfragment` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlscheme` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlhost` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlport` int(11) DEFAULT NULL,
  `refr_urlpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlquery` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlfragment` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_medium` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_source` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_term` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_medium` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_source` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_term` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_campaign` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contexts` text COLLATE utf8_unicode_ci,
  `se_category` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_action` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_label` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_property` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `se_value` double DEFAULT NULL,
  `unstruct_event` text COLLATE utf8_unicode_ci,
  `tr_orderid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_affiliation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_total` decimal(18,2) DEFAULT NULL,
  `tr_tax` decimal(18,2) DEFAULT NULL,
  `tr_shipping` decimal(18,2) DEFAULT NULL,
  `tr_city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tr_country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_orderid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_sku` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_category` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ti_price` decimal(18,2) DEFAULT NULL,
  `ti_quantity` int(11) DEFAULT NULL,
  `pp_xoffset_min` int(11) DEFAULT NULL,
  `pp_xoffset_max` int(11) DEFAULT NULL,
  `pp_yoffset_min` int(11) DEFAULT NULL,
  `pp_yoffset_max` int(11) DEFAULT NULL,
  `useragent` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_family` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_renderengine` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_lang` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_features_pdf` tinyint(1) DEFAULT NULL,
  `br_features_flash` tinyint(1) DEFAULT NULL,
  `br_features_java` tinyint(1) DEFAULT NULL,
  `br_features_director` tinyint(1) DEFAULT NULL,
  `br_features_quicktime` tinyint(1) DEFAULT NULL,
  `br_features_realplayer` tinyint(1) DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) DEFAULT NULL,
  `br_features_gears` tinyint(1) DEFAULT NULL,
  `br_features_silverlight` tinyint(1) DEFAULT NULL,
  `br_cookies` tinyint(1) DEFAULT NULL,
  `br_colordepth` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_viewwidth` int(11) DEFAULT NULL,
  `br_viewheight` int(11) DEFAULT NULL,
  `os_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_family` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_manufacturer` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_timezone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_ismobile` tinyint(1) DEFAULT NULL,
  `dvce_screenwidth` int(11) DEFAULT NULL,
  `dvce_screenheight` int(11) DEFAULT NULL,
  `doc_charset` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `doc_width` int(11) DEFAULT NULL,
  `doc_height` int(11) DEFAULT NULL,
  `geo_timezone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_clickid` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkt_network` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `etl_tags` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_sent_tstamp` int(11) DEFAULT NULL,
  `domain_sessionid` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `mail_queue` (
  `id` int(11) NOT NULL,
  `from` text COLLATE utf8_unicode_ci,
  `to` text COLLATE utf8_unicode_ci,
  `cc` text COLLATE utf8_unicode_ci,
  `bcc` text COLLATE utf8_unicode_ci,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `html_body` text COLLATE utf8_unicode_ci,
  `text_body` text COLLATE utf8_unicode_ci,
  `reply_to` text COLLATE utf8_unicode_ci,
  `charset` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attachments` text COLLATE utf8_unicode_ci,
  `created_at` datetime NOT NULL,
  `attempts` int(11) DEFAULT NULL,
  `last_attempt_time` datetime DEFAULT NULL,
  `sent_time` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `migration` (
  `version` varchar(180) COLLATE utf8_unicode_ci NOT NULL,
  `apply_time` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `migration` (`version`, `apply_time`) VALUES
('m000000_000000_base', 1467935764),
('m150214_044830_init_user', 1467935892),
('m150410_183765_init_setting', 1467935892),
('m150412_184646_init_theme', 1467935892),
('m150415_183345_init_form', 1467935895),
('m150420_183546_init_stats', 1467935896),
('m150420_183547_init_template', 1467935897),
('m150420_183548_init_mailqueue', 1467935897),
('m150420_183550_init_addon', 1467935897),
('m160104_150526_add_slug_to_form', 1467935897),
('m160110_151514_add_password_novalidate_to_form', 1467935897),
('m160118_171459_upgrade_user_module', 1467935899),
('m160630_181205_upgrade_to_136', 1467935899);

CREATE TABLE `profile` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `full_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timezone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `role` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `can_admin` smallint(6) NOT NULL DEFAULT '0',
  `can_edit_own_content` smallint(6) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `role` (`id`, `name`, `created_at`, `updated_at`, `can_admin`, `can_edit_own_content`) VALUES
(1, 'Admin', '2016-07-08 04:58:12', NULL, 1, 1),
(2, 'Basic User', '2016-07-08 04:58:12', NULL, 0, 0),
(3, 'Advanced User', '2016-07-08 04:58:19', NULL, 0, 1);

CREATE TABLE `setting` (
  `id` int(11) NOT NULL,
  `type` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `category` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `setting` (`id`, `type`, `category`, `key`, `value`, `status`, `created_at`, `updated_at`) VALUES
(1, 'string', 'app', 'name', 'Easy Forms', 1, 1467935892, 1467935892),
(2, 'string', 'app', 'description', 'The easiest way to build and manage your online forms', 1, 1467935892, 1467935892),
(3, 'string', 'app', 'adminEmail', 'admin@example.com', 1, 1467935892, 1467935892),
(4, 'string', 'app', 'supportEmail', 'support@example.com', 1, 1467935892, 1467935892),
(5, 'string', 'app', 'noreplyEmail', 'no-reply@example.com', 1, 1467935892, 1467935892),
(6, 'string', 'app', 'reCaptchaSecret', 'your_secret', 1, 1467935892, 1467935892),
(7, 'string', 'app', 'reCaptchaSiteKey', 'your_site_key', 1, 1467935892, 1467935892),
(8, 'string', 'smtp', 'host', 'localhost', 1, 1467935892, 1467935892),
(9, 'string', 'smtp', 'port', '25', 1, 1467935892, 1467935892),
(10, 'string', 'smtp', 'encryption', 'none', 1, 1467935892, 1467935892),
(11, 'string', 'smtp', 'username', 'Username', 1, 1467935892, 1467935892),
(12, 'string', 'smtp', 'password', 'Password', 1, 1467935892, 1467935892),
(13, 'integer', 'app', 'anyoneCanRegister', '0', 1, 1467935899, 1467935899),
(14, 'integer', 'app', 'loginWithoutPassword', '0', 1, 1467935899, 1467935899),
(15, 'integer', 'app', 'useCaptcha', '0', 1, 1467935899, 1467935899),
(16, 'integer', 'app', 'defaultUserRole', '2', 1, 1467935899, 1467935899);

CREATE TABLE `stats_performance` (
  `day` date NOT NULL,
  `app_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `users` int(11) DEFAULT NULL,
  `fills` int(11) DEFAULT NULL,
  `conversions` int(11) DEFAULT NULL,
  `conversionTime` bigint(20) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `stats_submissions` (
  `app_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `domain_sessionidx` smallint(6) DEFAULT NULL,
  `geo_country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `geo_city` varchar(75) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_urlhost` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refr_medium` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `br_family` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `os_family` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dvce_ismobile` tinyint(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `template` (
  `id` int(11) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `builder` mediumtext COLLATE utf8_unicode_ci,
  `html` mediumtext COLLATE utf8_unicode_ci,
  `promoted` tinyint(1) DEFAULT '0',
  `slug` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(1, 1, 'Basic Contact Form', 'Contact information is important for business owners, professionals, and other organizations. This form allows you to collect name, email addresses and other information so that you can reach personal or business contacts in the future.', '{"settings":{"name":"Contact Form","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Contact Us","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Let us know your questions, suggestions and concerns by filling out the contact form below.","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Message","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":412}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Contact Us&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;Let us know your questions, suggestions and concerns by filling out the contact form below.&lt;/p&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Message&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 1, 'basic-contact-form', 1, 1, 1467934996, 1467935896),
(2, 2, 'Customer Satisfaction Survey', 'You don''t need an expensive marketing research team to gather detailed information about your customers. Instead, use this survey for a quick and easy way to get invaluable feedback from customers on the quality of your product or service.', '{"settings":{"name":"Customer Satisfaction Survey","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Customer Satisfaction Survey","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Please take a few moments to complete this satisfaction survey.","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Overall, how satisfied were you with the product \\/ service?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Very Satisfied","Satisfied","Neutral","Unsatisfied","Very Unsatisfied","N\\/A"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Would you recommend our product \\/ service to colleagues or contacts within your industry?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Definitely","Probably","Not Sure","Probably Not","Definitely Not"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Would you use our product \\/ service in the future?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Less than a month","1-6 months","1-3 years","Over 3 Years","Never used"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_3","name":"id"},"label":{"label":"component.label","type":"input","value":"How often do you use product \\/ service?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Once a week","2 to 3 times a month","Once a month","Less than once a month"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_4","name":"id"},"label":{"label":"component.label","type":"input","value":"What aspect of the product \\/ service were you most satisfied by?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Quality","Price","Purchase Experience","Installation or First Use Experience","Usage Experience","Customer Service","Repeat Purchase Experience"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"What do you like about the product \\/ service?","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"What do you dislike about the product \\/ service?","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_5","name":"id"},"label":{"label":"component.label","type":"input","value":"Thinking of similar products \\/ services offered by other companies, how would you compare the product \\/ service offered by our company?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Much Better","Somewhat Better","About the Same","Somewhat Worse","Much Worse","Don\\u0027t Know"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":1526}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Customer Satisfaction Survey&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;Please take a few moments to complete this satisfaction survey.&lt;/p&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Overall, how satisfied were you with the product / service?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Very Satisfied&quot;&gt; Very Satisfied &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;Satisfied&quot;&gt; Satisfied &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;Neutral&quot;&gt; Neutral &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_3&quot; value=&quot;Unsatisfied&quot;&gt; Unsatisfied &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_4&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_4&quot; value=&quot;Very Unsatisfied&quot;&gt; Very Unsatisfied &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_5&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_5&quot; value=&quot;N/A&quot;&gt; N/A &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;Would you recommend our product / service to colleagues or contacts within your industry?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;Definitely&quot;&gt; Definitely &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;Probably&quot;&gt; Probably &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;Not Sure&quot;&gt; Not Sure &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; value=&quot;Probably Not&quot;&gt; Probably Not &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_4&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; value=&quot;Definitely Not&quot;&gt; Definitely Not &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_2&quot;&gt;Would you use our product / service in the future?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; value=&quot;Less than a month&quot;&gt; Less than a month &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; value=&quot;1-6 months&quot;&gt; 1-6 months &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; value=&quot;1-3 years&quot;&gt; 1-3 years &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_3&quot; value=&quot;Over 3 Years&quot;&gt; Over 3 Years &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_4&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_4&quot; value=&quot;Never used&quot;&gt; Never used &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_3&quot;&gt;How often do you use product / service?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; value=&quot;Once a week&quot;&gt; Once a week &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; value=&quot;2 to 3 times a month&quot;&gt; 2 to 3 times a month &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; value=&quot;Once a month&quot;&gt; Once a month &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; value=&quot;Less than once a month&quot;&gt; Less than once a month &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_4&quot;&gt;What aspect of the product / service were you most satisfied by?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_0&quot; value=&quot;Quality&quot;&gt; Quality &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_1&quot; value=&quot;Price&quot;&gt; Price &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_2&quot; value=&quot;Purchase Experience&quot;&gt; Purchase Experience &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_3&quot; value=&quot;Installation or First Use Experience&quot;&gt; Installation or First Use Experience &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_4&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_4&quot; value=&quot;Usage Experience&quot;&gt; Usage Experience &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_5&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_5&quot; value=&quot;Customer Service&quot;&gt; Customer Service &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_4_6&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_6&quot; value=&quot;Repeat Purchase Experience&quot;&gt; Repeat Purchase Experience &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_4&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;What do you like about the product / service?&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;What do you dislike about the product / service?&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_5&quot;&gt;Thinking of similar products / services offered by other companies, how would you compare the product / service offered by our company?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_5_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_0&quot; value=&quot;Much Better&quot;&gt; Much Better &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_5_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_1&quot; value=&quot;Somewhat Better&quot;&gt; Somewhat Better &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_5_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_2&quot; value=&quot;About the Same&quot;&gt; About the Same &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_5_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_3&quot; value=&quot;Somewhat Worse&quot;&gt; Somewhat Worse &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_5_4&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_4&quot; value=&quot;Much Worse&quot;&gt; Much Worse &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_5_5&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_5&quot; value=&quot;Don&#039;t Know&quot;&gt; Don&#039;t Know &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_5&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 1, 'customer-satisfaction-survey', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(3, 1, 'Job Application Form', 'Easy way to apply online. Gather information and upload resume using the form.', '{"settings":{"name":"Job Application Form","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Product Manager","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\\u003Cstrong\\u003EWill you be our next Product Manager?\\u003C\\/strong\\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"snippet","title":"snippet.title","fields":{"id":{"label":"component.id","type":"input","value":"snippet_0","name":"id"},"snippet":{"label":"component.htmlCode","type":"textarea","value":"\\u003Cdiv style=\\u0022border:1px solid #DDD;padding:10px;overflow-y: scroll;height: 200px;margin-bottom:20px\\u0022\\u003E\\n    \\u003Cp\\u003E\\u003Cstrong\\u003EAre you...\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n    \\u003Cul\\u003E\\n        \\u003Cli\\u003EFascinated by software products and how they can impact the lives of their users?\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ESomeone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EA person that enjoys being a vital part of an organization?\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EA believer that great software can provide significant savings of time and money?\\u003C\\/li\\u003E\\n    \\u003C\\/ul\\u003E\\n    \\u003Cp\\u003EIf so, you should consider applying to become our next Product Manager.\\u003C\\/p\\u003E\\n    \\u003Cp\\u003EWe are looking for a high energy and fun person to add to our team.\\u003C\\/p\\u003E\\n    \\u003Cp\\u003EThey will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.\\u003C\\/p\\u003E\\n    \\u003Cp\\u003E\\u003Cstrong\\u003EResponsibilities:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n    \\u003Cul\\u003E\\n        \\u003Cli\\u003EDefining new improvements for our web application, gathering requirements \\u0026 documenting designs\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ECollect and interpret customer feedback and needs but realize the customer might not always know what they need\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EUtilize a healthy amount of intuition but balance that with the appropriate amount of \\u0027data\\u0027 to back your decisions\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EAbility to prioritize\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EManage usability testing of new features to understand the \\u0022how\\u0022 and \\u0022why\\u0022 for people who use the software\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EProject management, seeing all projects from start to finish, new software every week\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ECollaborate with Marketing to define the strategies and define use cases\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EWork with the Customer Experience Team to analyze customer feedback and feature requests\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EInsure the end product is meeting the goals set in the beginning\\u003C\\/li\\u003E\\n    \\u003C\\/ul\\u003E\\n    \\u003Cp\\u003E\\u003Cstrong\\u003ESkills:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n    \\u003Cul\\u003E\\n        \\u003Cli\\u003EKnowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EA background or passion for user experience and design\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ETechnical understanding of the limitations and possibilities within the Web Applications space\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EHighly organized with demonstrated effective verbal and written communication skills\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EAbility to act as a liaison between departments and maintain lines of communication\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EGoal-oriented but able to make changes and pivots when necessary\\u003C\\/li\\u003E\\n    \\u003C\\/ul\\u003E\\n    \\u003Cp\\u003E*we are an Indianapolis-based company but accept applications for remote team members\\u003C\\/p\\u003E\\n\\u003C\\/div\\u003E","name":"snippet"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Last Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Address","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_0","name":"id"},"label":{"label":"component.label","type":"input","value":"How did you find out about this position?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Current Employee","Career Fair","Newspaper Ad","Radio\\/TV Ad","Search Engine","Other"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_3","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"If other, please specify","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Upload your resume","name":"label"},"accept":{"label":"component.accept","type":"input","value":".pdf, .docx, .doc","name":"accept"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Upload a cover letter","name":"label"},"accept":{"label":"component.accept","type":"input","value":".pdf, .docx, .doc","name":"accept"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Additional info","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":1175}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Product Manager&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;&lt;strong&gt;Will you be our next Product Manager?&lt;/strong&gt;&lt;/p&gt;\n\n&lt;!-- Snippet --&gt;\n&lt;div class=&quot;snippet&quot;&gt;&lt;div style=&quot;border:1px solid #DDD;padding:10px;overflow-y: scroll;height: 200px;margin-bottom:20px&quot;&gt;\n    &lt;p&gt;&lt;strong&gt;Are you...&lt;/strong&gt;&lt;/p&gt;\n    &lt;ul&gt;\n        &lt;li&gt;Fascinated by software products and how they can impact the lives of their users?&lt;/li&gt;\n        &lt;li&gt;Someone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?&lt;/li&gt;\n        &lt;li&gt;A person that enjoys being a vital part of an organization?&lt;/li&gt;\n        &lt;li&gt;A believer that great software can provide significant savings of time and money?&lt;/li&gt;\n    &lt;/ul&gt;\n    &lt;p&gt;If so, you should consider applying to become our next Product Manager.&lt;/p&gt;\n    &lt;p&gt;We are looking for a high energy and fun person to add to our team.&lt;/p&gt;\n    &lt;p&gt;They will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.&lt;/p&gt;\n    &lt;p&gt;&lt;strong&gt;Responsibilities:&lt;/strong&gt;&lt;/p&gt;\n    &lt;ul&gt;\n        &lt;li&gt;Defining new improvements for our web application, gathering requirements &amp;amp; documenting designs&lt;/li&gt;\n        &lt;li&gt;Collect and interpret customer feedback and needs but realize the customer might not always know what they need&lt;/li&gt;\n        &lt;li&gt;Utilize a healthy amount of intuition but balance that with the appropriate amount of &#039;data&#039; to back your decisions&lt;/li&gt;\n        &lt;li&gt;Ability to prioritize&lt;/li&gt;\n        &lt;li&gt;Manage usability testing of new features to understand the &quot;how&quot; and &quot;why&quot; for people who use the software&lt;/li&gt;\n        &lt;li&gt;Project management, seeing all projects from start to finish, new software every week&lt;/li&gt;\n        &lt;li&gt;Collaborate with Marketing to define the strategies and define use cases&lt;/li&gt;\n        &lt;li&gt;Work with the Customer Experience Team to analyze customer feedback and feature requests&lt;/li&gt;\n        &lt;li&gt;Insure the end product is meeting the goals set in the beginning&lt;/li&gt;\n    &lt;/ul&gt;\n    &lt;p&gt;&lt;strong&gt;Skills:&lt;/strong&gt;&lt;/p&gt;\n    &lt;ul&gt;\n        &lt;li&gt;Knowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development&lt;/li&gt;\n        &lt;li&gt;A background or passion for user experience and design&lt;/li&gt;\n        &lt;li&gt;Technical understanding of the limitations and possibilities within the Web Applications space&lt;/li&gt;\n        &lt;li&gt;Highly organized with demonstrated effective verbal and written communication skills&lt;/li&gt;\n        &lt;li&gt;Ability to act as a liaison between departments and maintain lines of communication&lt;/li&gt;\n        &lt;li&gt;Goal-oriented but able to make changes and pivots when necessary&lt;/li&gt;\n    &lt;/ul&gt;\n    &lt;p&gt;*we are an Indianapolis-based company but accept applications for remote team members&lt;/p&gt;\n&lt;/div&gt;&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Last Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Address&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;How did you find out about this position?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Current Employee&quot;&gt; Current Employee &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;Career Fair&quot;&gt; Career Fair &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;Newspaper Ad&quot;&gt; Newspaper Ad &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_3&quot; value=&quot;Radio/TV Ad&quot;&gt; Radio/TV Ad &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_4&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_4&quot; value=&quot;Search Engine&quot;&gt; Search Engine &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_5&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_5&quot; value=&quot;Other&quot;&gt; Other &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;If other, please specify&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Upload your resume&lt;/label&gt;\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;file_1&quot;&gt;Upload a cover letter&lt;/label&gt;\n    &lt;input type=&quot;file&quot; id=&quot;file_1&quot; name=&quot;file_1&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Additional info&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 1, 'job-application-form', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(4, 7, 'Bug Tracker', 'Do you need to track bugs for an IT department or a group of developers? With this form, you can collect and track the information you need to quickly and effectively intake clients. ', '{"settings":{"name":"Bug Tracker","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Bug Tracker","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Report all bugs!","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Bug Title","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Issue Description","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Operating System","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Windows XP","Windows Vista","Mac OS X","Linux","Other"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Browser","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Internet Explorer","Chrome","Firefox","Safari","Opera","Other"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_3","name":"id"},"label":{"label":"component.label","type":"input","value":"Assign To","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Team Member #1","Team Member #2","Team Member #3"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-9 no-padding-left","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_8","name":"id"},"label":{"label":"component.label","type":"input","value":"Priority","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Low","Medium","High"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-3 no-padding","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Upload a Screenshot","name":"label"},"accept":{"label":"component.accept","type":"input","value":".gif, .jpg, .png","name":"accept"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_9","name":"id"},"label":{"label":"component.label","type":"input","value":"Status","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["New","Acknowledged","Confirmed","Assigned","Resolved","Closed"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":600}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Bug Tracker&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;Report all bugs!&lt;/p&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Bug Title&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Issue Description&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group required-control col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Operating System&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Windows XP&quot;&gt;Windows XP&lt;/option&gt;\n        &lt;option value=&quot;Windows Vista&quot;&gt;Windows Vista&lt;/option&gt;\n        &lt;option value=&quot;Mac OS X&quot;&gt;Mac OS X&lt;/option&gt;\n        &lt;option value=&quot;Linux&quot;&gt;Linux&lt;/option&gt;\n        &lt;option value=&quot;Other&quot;&gt;Other&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group required-control col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Browser&lt;/label&gt;\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Internet Explorer&quot;&gt;Internet Explorer&lt;/option&gt;\n        &lt;option value=&quot;Chrome&quot;&gt;Chrome&lt;/option&gt;\n        &lt;option value=&quot;Firefox&quot;&gt;Firefox&lt;/option&gt;\n        &lt;option value=&quot;Safari&quot;&gt;Safari&lt;/option&gt;\n        &lt;option value=&quot;Opera&quot;&gt;Opera&lt;/option&gt;\n        &lt;option value=&quot;Other&quot;&gt;Other&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group required-control col-sm-9 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_3&quot;&gt;Assign To&lt;/label&gt;\n    &lt;select id=&quot;selectlist_3&quot; name=&quot;selectlist_3[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Team Member #1&quot;&gt;Team Member #1&lt;/option&gt;\n        &lt;option value=&quot;Team Member #2&quot;&gt;Team Member #2&lt;/option&gt;\n        &lt;option value=&quot;Team Member #3&quot;&gt;Team Member #3&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group required-control col-sm-3 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_8&quot;&gt;Priority&lt;/label&gt;\n    &lt;select id=&quot;selectlist_8&quot; name=&quot;selectlist_8[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Low&quot;&gt;Low&lt;/option&gt;\n        &lt;option value=&quot;Medium&quot;&gt;Medium&lt;/option&gt;\n        &lt;option value=&quot;High&quot;&gt;High&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Upload a Screenshot&lt;/label&gt;\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_9&quot;&gt;Status&lt;/label&gt;\n    &lt;select id=&quot;selectlist_9&quot; name=&quot;selectlist_9[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;New&quot;&gt;New&lt;/option&gt;\n        &lt;option value=&quot;Acknowledged&quot;&gt;Acknowledged&lt;/option&gt;\n        &lt;option value=&quot;Confirmed&quot;&gt;Confirmed&lt;/option&gt;\n        &lt;option value=&quot;Assigned&quot;&gt;Assigned&lt;/option&gt;\n        &lt;option value=&quot;Resolved&quot;&gt;Resolved&lt;/option&gt;\n        &lt;option value=&quot;Closed&quot;&gt;Closed&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'bug-tracker', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(5, 6, 'Event Planner', 'Be it work or play, it is best planned well in advance. Here is an online form to bookmark upcoming events and to verify the checklist of to-do''s. With this, you can be sure not to have left behind anything that adds to the fun.', '{"settings":{"name":"Event Planner","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Event Planner","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event Coordinator","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Event Type","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Banquet","Dinner Party","Wedding"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Status","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Planning","In Progress","Finished"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Event Description","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Does your program involve any type of outside activity?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Yes","No"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"number","title":"number.title","fields":{"id":{"label":"component.id","type":"input","value":"number_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"number","selected":true,"label":"Number"},{"value":"range","selected":false,"label":"Range"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Cost Per Person ($)","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"integerOnly":{"label":"component.integerOnly","type":"checkbox","value":false,"name":"integerOnly"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"min":{"label":"component.minNumber","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxNumber","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"integerPattern":{"label":"component.integerPattern","type":"input","value":"","advanced":true,"name":"integerPattern"},"numberPattern":{"label":"component.numberPattern","type":"input","value":"","advanced":true,"name":"numberPattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"checkbox","title":"checkbox.title","fields":{"id":{"label":"component.groupName","type":"input","value":"checkbox_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Requirements","name":"label"},"checkboxes":{"label":"component.checkboxes","type":"textarea-split","value":["Staffing","Catering","Security"],"name":"checkboxes"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"checkbox-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"date","title":"date.title","fields":{"id":{"label":"component.id","type":"input","value":"date_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"date","selected":false,"label":"Date"},{"value":"datetime-local","selected":true,"label":"DateTime-Local"},{"value":"time","selected":false,"label":"Time"},{"value":"month","selected":false,"label":"Month"},{"value":"week","selected":false,"label":"Week"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event Start Date","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"min":{"label":"component.minDate","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxDate","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"date","title":"date.title","fields":{"id":{"label":"component.id","type":"input","value":"date_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"date","selected":false,"label":"Date"},{"value":"datetime-local","selected":true,"label":"DateTime-Local"},{"value":"time","selected":false,"label":"Time"},{"value":"month","selected":false,"label":"Month"},{"value":"week","selected":false,"label":"Week"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event End Date","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"min":{"label":"component.minDate","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxDate","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Location","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"City","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_3","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"State","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Country","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["United States","United Kingdom","Australia","Canada","France","----","Afghanistan","Albania","Algeria","Andorra","Angola","Antigua & Deps","Argentina","Armenia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina","Burundi","Cambodia","Cameroon","Cape Verde","Central African Rep","Chad","Chile","China","Colombia","Comoros","Congo","Congo {Democratic Rep}","Costa Rica","Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","East Timor","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Fiji","Finland","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala","Guinea","Guinea-Bissau","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland {Republic}","Israel","Italy","Ivory Coast","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea North","Korea South","Kosovo","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Macedonia","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar, {Burma}","Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","Norway","Oman","Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russian Federation","Rwanda","St Kitts & Nevis","St Lucia","Saint Vincent & the Grenadines","Samoa","San Marino","Sao Tome & Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Swaziland","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Togo","Tonga","Trinidad & Tobago","Tunisia","Turkey","Turkmenistan","Tuvalu","Uganda","Ukraine","United Arab Emirates","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam","Yemen","Zambia","Zimbabwe"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-right","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Attach Detailed Itinerary","name":"label"},"accept":{"label":"component.accept","type":"input","value":".txt, .pdf, .doc, .docx","name":"accept"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":1126}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Event Planner&lt;/h3&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Event Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Event Coordinator&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Event Type&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Banquet&quot;&gt;Banquet&lt;/option&gt;\n        &lt;option value=&quot;Dinner Party&quot;&gt;Dinner Party&lt;/option&gt;\n        &lt;option value=&quot;Wedding&quot;&gt;Wedding&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Status&lt;/label&gt;\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Planning&quot;&gt;Planning&lt;/option&gt;\n        &lt;option value=&quot;In Progress&quot;&gt;In Progress&lt;/option&gt;\n        &lt;option value=&quot;Finished&quot;&gt;Finished&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Event Description&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Does your program involve any type of outside activity?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Yes&quot;&gt; Yes &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;No&quot;&gt; No &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Number --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;number_0&quot;&gt;Cost Per Person ($)&lt;/label&gt;\n    &lt;input type=&quot;number&quot; id=&quot;number_0&quot; name=&quot;number_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Checkbox --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;checkbox_0&quot;&gt;Requirements&lt;/label&gt;\n        &lt;div class=&quot;checkbox&quot;&gt;\n            &lt;label for=&quot;checkbox_0_0&quot; class=&quot;checkbox-inline&quot;&gt;\n            &lt;input type=&quot;checkbox&quot; name=&quot;checkbox_0[]&quot; id=&quot;checkbox_0_0&quot; value=&quot;Staffing&quot;&gt; Staffing &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;checkbox&quot;&gt;\n            &lt;label for=&quot;checkbox_0_1&quot; class=&quot;checkbox-inline&quot;&gt;\n            &lt;input type=&quot;checkbox&quot; name=&quot;checkbox_0[]&quot; id=&quot;checkbox_0_1&quot; value=&quot;Catering&quot;&gt; Catering &lt;/label&gt;\n        &lt;/div&gt;\n        &lt;div class=&quot;checkbox&quot;&gt;\n            &lt;label for=&quot;checkbox_0_2&quot; class=&quot;checkbox-inline&quot;&gt;\n            &lt;input type=&quot;checkbox&quot; name=&quot;checkbox_0[]&quot; id=&quot;checkbox_0_2&quot; value=&quot;Security&quot;&gt; Security &lt;/label&gt;\n        &lt;/div&gt;\n    &lt;span id=&quot;checkbox_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Date --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;date_0&quot;&gt;Event Start Date&lt;/label&gt;\n    &lt;input type=&quot;datetime-local&quot; id=&quot;date_0&quot; name=&quot;date_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Date --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;date_1&quot;&gt;Event End Date&lt;/label&gt;\n    &lt;input type=&quot;datetime-local&quot; id=&quot;date_1&quot; name=&quot;date_1&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;Location&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;City&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;State&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-right&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_2&quot;&gt;Country&lt;/label&gt;\n    &lt;select id=&quot;selectlist_2&quot; name=&quot;selectlist_2[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Attach Detailed Itinerary&lt;/label&gt;\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.txt, .pdf, .doc, .docx&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'event-planner', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(6, 7, 'Expense Tracker', 'With this expense tracker at hand, you can instantly record every one of your expenses and on what you spend. That way, you can generate reports to know where you should start cutting down costs.', '{"settings":{"name":"Expense Tracker","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Expense Tracker","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"If you''d like to better manage your expenses fill this form and generate your report.","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"date","title":"date.title","fields":{"id":{"label":"component.id","type":"input","value":"date_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"date","selected":true,"label":"Date"},{"value":"datetime-local","selected":false,"label":"DateTime-Local"},{"value":"time","selected":false,"label":"Time"},{"value":"month","selected":false,"label":"Month"},{"value":"week","selected":false,"label":"Week"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Date","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"min":{"label":"component.minDate","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxDate","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Category","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Option 1","Option 2","Option 3"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Subcategory","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Option 1","Option 2","Option 3"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Amount","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Payment Method","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Cash","Cheque","Credit Card","Debit Card"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Transaction Notes","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Type","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Personal","Bussiness"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":731}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Expense Tracker&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;If you&#039;d like to better manage your expenses fill this form and generate your report.&lt;/p&gt;\n\n&lt;!-- Date --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;date_0&quot;&gt;Date&lt;/label&gt;\n    &lt;input type=&quot;date&quot; id=&quot;date_0&quot; name=&quot;date_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Category&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Option 1&quot;&gt;Option 1&lt;/option&gt;\n        &lt;option value=&quot;Option 2&quot;&gt;Option 2&lt;/option&gt;\n        &lt;option value=&quot;Option 3&quot;&gt;Option 3&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Subcategory&lt;/label&gt;\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Option 1&quot;&gt;Option 1&lt;/option&gt;\n        &lt;option value=&quot;Option 2&quot;&gt;Option 2&lt;/option&gt;\n        &lt;option value=&quot;Option 3&quot;&gt;Option 3&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Amount&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_2&quot;&gt;Payment Method&lt;/label&gt;\n    &lt;select id=&quot;selectlist_2&quot; name=&quot;selectlist_2[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Cash&quot;&gt;Cash&lt;/option&gt;\n        &lt;option value=&quot;Cheque&quot;&gt;Cheque&lt;/option&gt;\n        &lt;option value=&quot;Credit Card&quot;&gt;Credit Card&lt;/option&gt;\n        &lt;option value=&quot;Debit Card&quot;&gt;Debit Card&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Transaction Notes&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Type&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Personal&quot;&gt; Personal &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;Bussiness&quot;&gt; Bussiness &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'expense-tracker', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(7, 5, 'Online Payment Form', 'An online payment form to sell your products securely on any place you want.', '{"settings":{"name":"Online Payment Form","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Online Payment Form","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"What would you like to buy?","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_0","name":"id"},"label":{"label":"component.label","type":"input","value":"How many widgets would you like to buy?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["1 - $10|1","2 - $19|2","3 - $26|3"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_1","name":"id"},"label":{"label":"component.label","type":"input","value":"What color would you like?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Red","Yellow","Blue"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Where would you like the widgets shipped?","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"City","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"State","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Country","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["United States","United Kingdom","Australia","Canada","France","----","Afghanistan","Albania","Algeria","Andorra","Angola","Antigua & Deps","Argentina","Armenia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina","Burundi","Cambodia","Cameroon","Cape Verde","Central African Rep","Chad","Chile","China","Colombia","Comoros","Congo","Congo {Democratic Rep}","Costa Rica","Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","East Timor","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Fiji","Finland","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala","Guinea","Guinea-Bissau","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland {Republic}","Israel","Italy","Ivory Coast","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea North","Korea South","Kosovo","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Macedonia","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar, {Burma}","Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","Norway","Oman","Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russian Federation","Rwanda","St Kitts & Nevis","St Lucia","Saint Vincent & the Grenadines","Samoa","San Marino","Sao Tome & Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Swaziland","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Togo","Tonga","Trinidad & Tobago","Tunisia","Turkey","Turkmenistan","Tuvalu","Uganda","Ukraine","United Arab Emirates","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam","Yemen","Zambia","Zimbabwe"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-right","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Would you like to pay by check or credit card?","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Check","Credit Card"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_1","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\\u003Cstrong\\u003EPlease Read\\u003C\\/strong\\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_2","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\\u003Csmall\\u003EYou will be taken to a secure payment page after submitting this form. Please enter your credit card information on that page to complete your purchase.\\u003C\\/small\\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_3","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\\u003Csmall\\u003EThank you!\\u003C\\/small\\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":891}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Online Payment Form&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;What would you like to buy?&lt;/p&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;How many widgets would you like to buy?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;1&quot;&gt; 1 - $10 &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;2&quot;&gt; 2 - $19 &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;3&quot;&gt; 3 - $26 &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;What color would you like?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;Red&quot;&gt; Red &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;Yellow&quot;&gt; Yellow &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;Blue&quot;&gt; Blue &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Where would you like the widgets shipped?&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;City&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;State&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-right&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Country&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Would you like to pay by check or credit card?&lt;/label&gt;\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Check&quot;&gt;Check&lt;/option&gt;\n        &lt;option value=&quot;Credit Card&quot;&gt;Credit Card&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;&lt;strong&gt;Please Read&lt;/strong&gt;&lt;/p&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;&lt;small&gt;You will be taken to a secure payment page after submitting this form. Please enter your credit card information on that page to complete your purchase.&lt;/small&gt;&lt;/p&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;&lt;small&gt;Thank you!&lt;/small&gt;&lt;/p&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'online-payment-form', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(8, 2, 'Trivia Quiz', 'Create trivia quizes and receive online responses to the quiz.', '{"settings":{"name":"Trivia Quiz","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":["Untitled Step","Untitled Step","Untitled Step","Untitled Step"],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":true,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Trivia Quiz","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\\u003Cstrong\\u003EFill out this trivia quiz for fun!\\u003C\\/strong\\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_1","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\\u003Csmall\\u003EYou will receive 5 points for every correct answer.\\u003C\\/small\\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Which country is also known as the land of the rising sun?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Japan|5","China|0","Australia|0"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"pagebreak","title":"pagebreak.title","fields":{"id":{"label":"component.id","type":"input","value":"pagebreak_0","name":"id"},"prev":{"label":"component.prev","type":"input","value":"","name":"prev"},"next":{"label":"component.next","type":"input","value":"","name":"next"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Which is the smallest country in the world?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Liechtenstein|0","Vatican City|5","Monaco|0"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"pagebreak","title":"pagebreak.title","fields":{"id":{"label":"component.id","type":"input","value":"pagebreak_1","name":"id"},"prev":{"label":"component.prev","type":"input","value":"","name":"prev"},"next":{"label":"component.next","type":"input","value":"","name":"next"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_2","name":"id"},"label":{"label":"component.label","type":"input","value":"What food group has the highest level of protein?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["Bread|0","Vegetables|0","Meat|5"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"pagebreak","title":"pagebreak.title","fields":{"id":{"label":"component.id","type":"input","value":"pagebreak_2","name":"id"},"prev":{"label":"component.prev","type":"input","value":"","name":"prev"},"next":{"label":"component.next","type":"input","value":"","name":"next"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_3","name":"id"},"label":{"label":"component.label","type":"input","value":"How many words are there in the English language?","name":"label"},"radios":{"label":"component.radios","type":"textarea-split","value":["2 Million+|0","170,000|5","70,000|0","500,000|0"],"name":"radios"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"radio-inline","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"snippet","title":"snippet.title","fields":{"id":{"label":"component.id","type":"input","value":"snippet_0","name":"id"},"snippet":{"label":"component.htmlCode","type":"textarea","value":"\\u003Cdiv id=\\u0022result\\u0022 class=\\u0022well\\u0022\\u003EYour score is \\u003Cspan id=\\u0022score\\u0022 class=\\u0022label label-default\\u0022\\u003E0\\u003C\\/span\\u003E. Thanks for your time!\\u003C\\/div\\u003E","name":"snippet"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":883}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;!-- Steps --&gt;\n&lt;div class=&quot;steps&quot;&gt;\n    &lt;div class=&quot;step no-title current&quot;&gt;\n        &lt;div class=&quot;stage&quot;&gt;1&lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;step no-title&quot;&gt;\n        &lt;div class=&quot;stage&quot;&gt;2&lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;step no-title&quot;&gt;\n        &lt;div class=&quot;stage&quot;&gt;3&lt;/div&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;step no-title&quot;&gt;\n        &lt;div class=&quot;stage&quot;&gt;4&lt;/div&gt;\n    &lt;/div&gt;\n&lt;/div&gt;\n\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Trivia Quiz&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;&lt;strong&gt;Fill out this trivia quiz for fun!&lt;/strong&gt;&lt;/p&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;&lt;small&gt;You will receive 5 points for every correct answer.&lt;/small&gt;&lt;/p&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Which country is also known as the land of the rising sun?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;5&quot;&gt; Japan &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;0&quot;&gt; China &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;0&quot;&gt; Australia &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Page Break --&gt;\n&lt;div class=&quot;page-break&quot; data-button-previous=&quot;&quot; data-button-next=&quot;&quot;&gt;&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;Which is the smallest country in the world?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;0&quot;&gt; Liechtenstein &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;5&quot;&gt; Vatican City &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;0&quot;&gt; Monaco &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Page Break --&gt;\n&lt;div class=&quot;page-break&quot; data-button-previous=&quot;&quot; data-button-next=&quot;&quot;&gt;&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_2&quot;&gt;What food group has the highest level of protein?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; value=&quot;0&quot;&gt; Bread &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; value=&quot;0&quot;&gt; Vegetables &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_2_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; value=&quot;5&quot;&gt; Meat &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Page Break --&gt;\n&lt;div class=&quot;page-break&quot; data-button-previous=&quot;&quot; data-button-next=&quot;&quot;&gt;&lt;/div&gt;\n\n&lt;!-- Radio --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_3&quot;&gt;How many words are there in the English language?&lt;/label&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_0&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; value=&quot;0&quot;&gt; 2 Million+ &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_1&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; value=&quot;5&quot;&gt; 170,000 &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_2&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; value=&quot;0&quot;&gt; 70,000 &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;div class=&quot;radio&quot;&gt;\n        &lt;label for=&quot;radio_3_3&quot; class=&quot;radio-inline&quot;&gt;\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; value=&quot;0&quot;&gt; 500,000 &lt;/label&gt;\n    &lt;/div&gt;\n    &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;\n&lt;/div&gt;\n\n&lt;!-- Snippet --&gt;\n&lt;div class=&quot;snippet&quot;&gt;&lt;div id=&quot;result&quot; class=&quot;well&quot;&gt;Your score is &lt;span id=&quot;score&quot; class=&quot;label label-default&quot;&gt;0&lt;/span&gt;. Thanks for your time!&lt;/div&gt;&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 1, 'trivia-quiz', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(9, 7, 'Address Book', 'Use our online address book to easily input, organize, and store your personal contacts.', '{"settings":{"name":"Address Book","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Address Book","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Photo","name":"label"},"accept":{"label":"component.accept","type":"input","value":".gif, .jpg, .png","name":"accept"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Address","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"City","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_3","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"State","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Country","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["United States","United Kingdom","Australia","Canada","France","----","Afghanistan","Albania","Algeria","Andorra","Angola","Antigua \\u0026 Deps","Argentina","Armenia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina","Burundi","Cambodia","Cameroon","Cape Verde","Central African Rep","Chad","Chile","China","Colombia","Comoros","Congo","Congo {Democratic Rep}","Costa Rica","Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","East Timor","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Fiji","Finland","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala","Guinea","Guinea-Bissau","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland {Republic}","Israel","Italy","Ivory Coast","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea North","Korea South","Kosovo","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Macedonia","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar, {Burma}","Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","Norway","Oman","Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russian Federation","Rwanda","St Kitts \\u0026 Nevis","St Lucia","Saint Vincent \\u0026 the Grenadines","Samoa","San Marino","Sao Tome \\u0026 Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Swaziland","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Togo","Tonga","Trinidad \\u0026 Tobago","Tunisia","Turkey","Turkmenistan","Tuvalu","Uganda","Ukraine","United Arab Emirates","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam","Yemen","Zambia","Zimbabwe"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-right","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_4","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":false,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":true,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Web Site","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Email Address","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_5","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":false,"label":"Text"},{"value":"tel","selected":true,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Home Phone","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_6","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":false,"label":"Text"},{"value":"tel","selected":true,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Cell Phone","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"date","title":"date.title","fields":{"id":{"label":"component.id","type":"input","value":"date_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"date","selected":true,"label":"Date"},{"value":"datetime-local","selected":false,"label":"DateTime-Local"},{"value":"time","selected":false,"label":"Time"},{"value":"month","selected":false,"label":"Month"},{"value":"week","selected":false,"label":"Week"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Birthday","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"min":{"label":"component.minDate","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxDate","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Notes","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":792}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Address Book&lt;/h3&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- File --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Photo&lt;/label&gt;\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Address&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;City&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;State&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-right&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Country&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_4&quot;&gt;Web Site&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email Address&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_5&quot;&gt;Home Phone&lt;/label&gt;\n    &lt;input type=&quot;tel&quot; id=&quot;text_5&quot; name=&quot;text_5&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_6&quot;&gt;Cell Phone&lt;/label&gt;\n    &lt;input type=&quot;tel&quot; id=&quot;text_6&quot; name=&quot;text_6&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Date --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;date_0&quot;&gt;Birthday&lt;/label&gt;\n    &lt;input type=&quot;date&quot; id=&quot;date_0&quot; name=&quot;date_0&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Notes&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'address-book', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(10, 3, 'Sales Lead Form', 'Capture your website leads with a simple lead form. Our sales lead form helps you understand where your leads are coming from, and it asks for detailed contact information so that you can reach out to prospects', '{"settings":{"name":"Sales Lead Form","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Sales Lead Form","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Please enter your information below so we can be in touch.","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Company","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Title at Company","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Contact Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_3","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":false,"label":"Text"},{"value":"tel","selected":true,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Contact Phone","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_4","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Contact Address","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_5","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"City","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_6","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"State","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Country","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["United States","United Kingdom","Australia","Canada","France","----","Afghanistan","Albania","Algeria","Andorra","Angola","Antigua \\u0026 Deps","Argentina","Armenia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina","Burundi","Cambodia","Cameroon","Cape Verde","Central African Rep","Chad","Chile","China","Colombia","Comoros","Congo","Congo {Democratic Rep}","Costa Rica","Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","East Timor","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Fiji","Finland","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala","Guinea","Guinea-Bissau","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland {Republic}","Israel","Italy","Ivory Coast","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea North","Korea South","Kosovo","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Macedonia","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar, {Burma}","Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","Norway","Oman","Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russian Federation","Rwanda","St Kitts \\u0026 Nevis","St Lucia","Saint Vincent \\u0026 the Grenadines","Samoa","San Marino","Sao Tome \\u0026 Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Swaziland","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Togo","Tonga","Trinidad \\u0026 Tobago","Tunisia","Turkey","Turkmenistan","Tuvalu","Uganda","Ukraine","United Arab Emirates","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam","Yemen","Zambia","Zimbabwe"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-4 no-padding-right","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_7","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":false,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":true,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Company Website","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Please tell us about your industry.","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Questions or Comments","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":876}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Sales Lead Form&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;Please enter your information below so we can be in touch.&lt;/p&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Company&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Title at Company&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group required-control col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Contact Email&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; value=&quot;&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;Contact Phone&lt;/label&gt;\n    &lt;input type=&quot;tel&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_4&quot;&gt;Contact Address&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_5&quot;&gt;City&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_5&quot; name=&quot;text_5&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_6&quot;&gt;State&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_6&quot; name=&quot;text_6&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-4 no-padding-right&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Country&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_7&quot;&gt;Company Website&lt;/label&gt;\n    &lt;input type=&quot;url&quot; id=&quot;text_7&quot; name=&quot;text_7&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Please tell us about your industry.&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;Questions or Comments&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 1, 'sales-lead-form', 1, 1, 1467934996, 1467934996);
INSERT INTO `template` (`id`, `category_id`, `name`, `description`, `builder`, `html`, `promoted`, `slug`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(11, 1, 'Mailing List', 'A mailing list is a collection of names and addresses used by an individual or an organization to send material to multiple recipients.', '{"settings":{"name":"Mailing List","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"form-inline","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Join our Mailing List","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"heading"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Keep up to date with information about our publishing by joining our mailing list!","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Your Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"Your Name","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Your Email Address","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"Your Email","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":150}', '&lt;form id=&quot;form-app&quot; class=&quot;form-inline&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Join our Mailing List&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;Keep up to date with information about our publishing by joining our mailing list!&lt;/p&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Your Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; placeholder=&quot;Your Name&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Email --&gt;\n&lt;div class=&quot;form-group required-control&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Your Email Address&lt;/label&gt;\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; placeholder=&quot;Your Email&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'mailing-list', 1, 1, 1467934996, 1467934996),
(12, 4, 'Wedding RSVP Form', 'About to get married? Create your own online RSVP to know how many guests would attend your wedding reception. Easy for your guests to read and quickly to fill in!', '{"settings":{"name":"Wedding RSVP Form","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps","name":"id"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[],"name":"steps"},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false,"name":"progressBar"},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false,"name":"noTitles"},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false,"name":"noStages"},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false,"name":"noSteps"}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Caroline & Steven''s Wedding RSVP","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":false,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":true,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"legend","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"We look forward to celebrating with you! Please reply by October 18, 2016","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_0","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"First Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Last Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Are you coming?","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["Can''t Wait!","Sorry To Miss Out"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":true,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding-left","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Persons will atend","name":"label"},"options":{"label":"component.options","type":"textarea-split","value":["1","2"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-sm-6 no-padding","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Guest Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_0","name":"id"},"label":{"label":"component.label","type":"input","value":"Any special dietary requirements","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","advanced":true,"name":"predefinedValue"},"required":{"label":"component.required","type":"checkbox","value":false,"name":"required"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"snippet","title":"snippet.title","fields":{"id":{"label":"component.id","type":"input","value":"snippet_0","name":"id"},"snippet":{"label":"component.htmlCode","type":"textarea","value":"\\u003Cp\\u003E\\u003Cstrong\\u003EHow to get there!\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cp\\u003E\\u003Csmall\\u003EThe Francis Marion Hotel 387 King Street Charleston. South Carolina.\\u003C\\/small\\u003E\\u003C\\/p\\u003E\\n\\u003Cdiv id=\\u0022map\\u0022\\u003E\\u003C\\/div\\u003E\\n\\u003Cstyle type=\\u0022text\\/css\\u0022\\u003E\\n#map {\\n    width: 100%;\\n    height: 300px;\\n    margin-bottom: 15px;\\n    background-color: #f3f5f7;\\n}\\n\\u003C\\/style\\u003E","name":"snippet"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_0","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","label":"Submit","selected":true},{"value":"reset","label":"Reset","selected":false},{"value":"image","label":"Image","selected":false}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"control-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"height":861}', '&lt;form id=&quot;form-app&quot;&gt;\n&lt;fieldset&gt;\n\n&lt;!-- Heading --&gt;\n&lt;h3 class=&quot;legend&quot;&gt;Caroline &amp;amp; Steven&#039;s Wedding RSVP&lt;/h3&gt;\n\n&lt;!-- Paragraph Text --&gt;\n&lt;p&gt;We look forward to celebrating with you! Please reply by October 18, 2016&lt;/p&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;First Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group required-control col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Last Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group required-control col-sm-6 no-padding-left&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Are you coming?&lt;/label&gt;\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;Can&#039;t Wait!&quot;&gt;Can&#039;t Wait!&lt;/option&gt;\n        &lt;option value=&quot;Sorry To Miss Out&quot;&gt;Sorry To Miss Out&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Select List --&gt;\n&lt;div class=&quot;form-group col-sm-6 no-padding&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Persons will atend&lt;/label&gt;\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\n        &lt;option value=&quot;1&quot;&gt;1&lt;/option&gt;\n        &lt;option value=&quot;2&quot;&gt;2&lt;/option&gt;\n    &lt;/select&gt;\n&lt;/div&gt;\n\n&lt;!-- Text --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Guest Name&lt;/label&gt;\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\n&lt;/div&gt;\n\n&lt;!-- Text Area --&gt;\n&lt;div class=&quot;form-group&quot;&gt;\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Any special dietary requirements&lt;/label&gt;\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\n&lt;/div&gt;\n\n&lt;!-- Snippet --&gt;\n&lt;div class=&quot;snippet&quot;&gt;&lt;p&gt;&lt;strong&gt;How to get there!&lt;/strong&gt;&lt;/p&gt;\n&lt;p&gt;&lt;small&gt;The Francis Marion Hotel 387 King Street Charleston. South Carolina.&lt;/small&gt;&lt;/p&gt;\n&lt;div id=&quot;map&quot;&gt;&lt;/div&gt;\n&lt;style type=&quot;text/css&quot;&gt;\n#map {\n    width: 100%;\n    height: 300px;\n    margin-bottom: 15px;\n    background-color: #f3f5f7;\n}\n&lt;/style&gt;&lt;/div&gt;\n\n&lt;!-- Button --&gt;\n&lt;div class=&quot;form-action&quot;&gt;\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\n&lt;/div&gt;\n\n&lt;/fieldset&gt;\n&lt;/form&gt;', 0, 'wedding-rsvp-form', 1, 1, 1467934996, 1467934996);

CREATE TABLE `template_category` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `template_category` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
(1, 'Online Forms', 'If you need a ready-to-go form for your website, you''ve come to the right place.', 1467935896, 1467935896),
(2, 'Surveys', 'Curious what people think? Need to do some polling? Then this online surveys are made for you.', 1467935896, 1467935896),
(3, 'Lead Generation', 'A lead generation template is a critical piece of the puzzle on any website designed to attract customer inquiries for follow up.', 1467934996, 1467934996),
(4, 'Invitation', 'Party? Did someone say party? Add a online invitation to your website, or send it out through email, to make collecting responses a snap.', 1467934996, 1467934996),
(5, 'Online Order', 'Are you looking for a way to take orders online instead of over the phone? Well then, what you need is an online order form template.', 1467934996, 1467934996),
(6, 'Registrations', 'Are you an event planner, or has someone "volunteered" you to organize that ski lodge reservation for all of your friends? This templates will help you to make organizing events a painless process.', 1467934996, 1467934996),
(7, 'Tracking', 'Spreadsheets are so yesterday for inventory and tracking purposes. Instead of a spreadsheet, you need a tracking form to keep tabs on inventory, host evaluations, file addresses, or even to record your exercise habits.', 1467934996, 1467934996);

CREATE TABLE `theme` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `css` text COLLATE utf8_unicode_ci,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `theme` (`id`, `name`, `description`, `color`, `css`, `created_by`, `updated_by`, `created_at`, `updated_at`) VALUES
(1, 'Blue Denim', 'Dark blue body with white big fields.', '#212a3e', '\nbody {\n    background-color: #212a3e;\n    padding: 20px;\n    color: #7b8291;\n}\n\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    body {\n        padding: 50px;\n    }\n}\nstrong {\n    color: #FFFFFF;\n}\n.legend {\n    font-family: "helvetica", "arial", "sans-serif";\n    font-size: 28px;\n    font-weight: 400;\n    line-height: 1.4;\n    color: #fff;\n    margin: 0 0 5px;\n}\np.description {\n    color: #1ec185;\n    background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAPCAYAAAAyPTUwAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4JpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNS1jMDIxIDc5LjE1NTc3MiwgMjAxNC8wMS8xMy0xOTo0NDowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpEQUIyQTJGOUZCNzZERTExQkFGNUUxNDNCMEI4NkZGMSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpFREYxQURBODk5N0YxMUU0OTU0N0EzNkVCREUxQzBFRCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpFREYxQURBNzk5N0YxMUU0OTU0N0EzNkVCREUxQzBFRCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ0MgMjAxNCAoTWFjaW50b3NoKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOmNlOWNlZGU1LTM1YTYtNDFiNi04NDA4LTM2YmIxMjY4NjdhNSIgc3RSZWY6ZG9jdW1lbnRJRD0iYWRvYmU6ZG9jaWQ6cGhvdG9zaG9wOmI2Nzk5MjljLWRmZTMtMTE3Ny1iOGNhLTlmM2YyOWFkM2Y1YiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PoBOvTYAAACrSURBVHjaYpE72MqABKSA2B+IZYH4ERBvAOIXMEkWJIUhQLwIiDmRxHqBOBqqiYEJKiiJpvA/lOaCiosgK/ZFUhgIxKxAHAHl8wKxF7IzZJGs3gCl16L5BW4ystth4A+6AEgRIxBzIIkJYtHICVN8HIjNkSTeYVFcB8QOTGgK8QE7JgYSwCBS/JNItV9BQecJxD5ArAPEikDMB8RsUEM+A/E9IL4EilGAAAMAaCsYB5gwb+gAAAAASUVORK5CYII=") 0 40% no-repeat;\n    font-size: 14px;\n    padding-left: 20px;\n    display: inline-block;\n    margin: 5px auto 0;\n}\n.form-group, .form-action {\n    font-size: 14px;\n    color: #7b8291;\n    margin: 27px 0 9px;\n}\n.control-label {\n    font-size: 16px;\n    color: #fff;\n    margin: 0 5px 9px 0;\n}\n.required-control .control-label:after {\n    color: #e55;\n    margin-left: 5px;\n}\n.form-control {\n    background: #363e51;\n    border-color: transparent;\n    border-radius: 3px;\n    color: #fff;\n    margin: 0;\n    height: 36px;\n    width: 100%;\n    -webkit-transition: background .08s linear;\n    -moz-transition: background .08s linear;\n    -o-transition: background .08s linear;\n    transition: background .08s linear;\n}\n.form-control:hover {\n    background: #424a5b\n}\n.form-control:focus {\n    background: #fff;\n    color: #212a3e\n}\n.form-control::-webkit-input-placeholder {\n    color: #7b8291\n}\n.form-control::-moz-placeholder {\n    color: #7b8291\n}\n.form-control:-ms-input-placeholder {\n    color: #7b8291\n}\n.form-control::placeholder {\n    color: #7b8291\n}\n.btn {\n    border-radius: 4px;\n    border: 0 !important;\n    font-size: 18px;\n    font-weight: 500;\n    width: auto;\n    height: 55px;\n    line-height: 55px;\n    margin: 0;\n    padding: 0 30px;\n    -webkit-transition: background-color .1s ease;\n    -moz-transition: background-color .1s ease;\n    -o-transition: background-color .1s ease;\n    transition: background-color .1s ease;\n}\n.btn-primary {\n    background-color: #1ec185;\n}\n.btn-primary:focus, .btn-primary:active, .btn-primary:hover {\n    background-color: #1baf79 !important;\n    color: #fff;\n    border: 0 !important;\n    outline: 0 none !important;\n    box-shadow: none !important;\n}\n', 1, 1, 1467935892, 1467935892),
(2, 'Sky Blue', 'Blue sky background with clouds around. White form with a thin typography.', '#95D6FE', '\n@import url(https://fonts.googleapis.com/css?family=Roboto:400,300);\nbody {\n    background-color: #95D6FE;\n    overflow-x: hidden;\n    padding: 20px;\n    color: #A9A9A9;\n    color: rgba(255, 255, 255, 0.6);\n    font-family: Roboto, sans-serif;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    body {\n        padding: 50px 25%;\n    }\n}\n/**\n * Form\n */\nh3 {\n    color: #FFFFFF;\n    font-size: 32px;\n    font-weight: 300;\n    text-align: center;\n    margin: .3em 0;\n    -webkit-animation: titleFadein .8s ease;\n    -moz-animation: titleFadein .8s ease;\n    animation: titleFadein .8s ease;\n}\np:first-of-type {\n    color: #FFFFFF;\n    color: rgba(255, 255, 255, 0.92);\n    font-weight: 300;\n    font-size: 20px;\n    text-shadow: none;\n    text-align: center;\n}\n.form-group {\n    background-color: #ffffff;\n    font-size: 14px;\n    padding: 20px 40px 10px;\n    margin: 0;\n}\n.form-group:first-of-type {\n    padding-top: 40px;\n    margin-top: 40px;\n    border-radius: 12px 12px 0 0;\n}\n.form-action {\n    margin: 0;\n    padding: 20px 40px 40px 40px;\n    border-radius: 0 0 12px 12px;\n    background-color: #ffffff;\n    font-size: 14px;\n}\n.control-label {\n    font-weight: 300;\n    font-size: 16px;\n    color: #777777;\n}\n.form-control {\n    width: 100%;\n    height: 48px;\n    -webkit-box-sizing: padding-box;\n    -moz-box-sizing: padding-box;\n    box-sizing: padding-box;\n    -webkit-appearance: none;\n    -moz-appearance: none;\n    appearance: none;\n    background-color: #EFEFEF;\n    background-color: rgba(0, 0, 0, 0.03);\n    border-color: transparent;\n    border-radius: 6px;\n    font-size: 20px;\n    font-family: Roboto, sans-serif;\n    font-weight: 300;\n    box-shadow: inset 0px 2px 1px rgba(0, 0, 0, .03);\n    outline: none;\n    text-overflow: ellipsis;\n    -webkit-font-smoothing: antialiased;\n}\n.form-control:focus {\n    border-color: rgb(138, 197, 65);\n    box-shadow: inset 0 0 0 0,inset 0 1px 2px rgba(138, 197, 65, 0.15),0 0 10px rgba(138, 197, 65, 0.8),0 2px 0 rgba(138, 197, 65,0.1);\n    transition: none;\n}\n.form-control::-webkit-input-placeholder {\n    color: #A9A9A9;\n}\n.form-control::-moz-placeholder {\n    color: #A9A9A9;\n}\n.form-control:-ms-input-placeholder {\n    color: #A9A9A9;\n}\n.form-control::placeholder {\n    color: #A9A9A9;\n}\n.radio label, .checkbox label {\n    color: #7C7C7C;\n    font-weight: 300;\n}\n.btn {\n    display: block;\n    padding: 0 28px;\n    border-radius: 28px;\n    width: auto;\n    height: 56px;\n    margin: 0 auto;\n    overflow: hidden;\n    -webkit-font-smoothing: antialiased;\n    font-size: 24px;\n}\n.btn-primary {\n    background-color: rgb(138, 197, 65);\n    background-color: rgba(138, 197, 65, 0.90);\n    border-color: transparent;\n}\n.btn-primary:focus, .btn-primary:hover {\n    background: rgb(138, 197, 65) !important;\n    border-color: transparent !important;\n    color: rgb(255, 255, 255) !important;\n}\n.info {\n    font-size: 16px;\n    color: rgb(102, 102, 102);\n    color: rgba(102, 102, 102, 0.3);\n    padding: 10px 40px;\n    background-color: #ffffff;\n    margin: 0;\n}\n/**\n * Clouds\n *\n * You must add this snippet to your form:\n *\n * <div id="clouds">\n *   <div class="cloud x1"></div>\n *   <div class="cloud x2"></div>\n *   <div class="cloud x3"></div>\n *   <div class="cloud x4"></div>\n *   <div class="cloud x5"></div>\n * </div>\n *\n * Based on http://thecodeplayer.com/walkthrough/pure-css3-animated-clouds-background\n */\n#clouds{\n    top: 220px;\n    padding: 100px 0;\n    position: absolute;\n    z-index: -1;\n}\n/*Time to finalise the cloud shape*/\n.cloud {\n    width: 200px; height: 60px;\n    background: #fff;\n\n    border-radius: 200px;\n    -moz-border-radius: 200px;\n    -webkit-border-radius: 200px;\n\n    position: relative;\n}\n.cloud:before, .cloud:after {\n    content: "";\n    position: absolute;\n    background: #fff;\n    width: 100px; height: 80px;\n    top: -15px; left: 10px;\n\n    border-radius: 100px;\n    -moz-border-radius: 100px;\n    -webkit-border-radius: 100px;\n\n    -webkit-transform: rotate(30deg);\n    transform: rotate(30deg);\n    -moz-transform: rotate(30deg);\n}\n.cloud:after {\n    width: 120px; height: 120px;\n    top: -55px; left: auto; right: 15px;\n}\n/*Time to animate*/\n.x1 {\n    -webkit-animation: moveclouds 15s linear infinite;\n    -moz-animation: moveclouds 15s linear infinite;\n    -o-animation: moveclouds 15s linear infinite;\n}\n/*variable speed, opacity, and position of clouds for realistic effect*/\n.x2 {\n    left: 200px;\n\n    -webkit-transform: scale(0.6);\n    -moz-transform: scale(0.6);\n    transform: scale(0.6);\n    opacity: 0.6; /*opacity proportional to the size*/\n\n    /*Speed will also be proportional to the size and opacity*/\n    /*More the speed. Less the time in "s" = seconds*/\n    -webkit-animation: moveclouds 25s linear infinite;\n    -moz-animation: moveclouds 25s linear infinite;\n    -o-animation: moveclouds 25s linear infinite;\n}\n.x3 {\n    left: -250px; top: -200px;\n\n    -webkit-transform: scale(0.8);\n    -moz-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0.8; /*opacity proportional to size*/\n\n    -webkit-animation: moveclouds 20s linear infinite;\n    -moz-animation: moveclouds 20s linear infinite;\n    -o-animation: moveclouds 20s linear infinite;\n}\n.x4 {\n    left: 470px; top: -250px;\n\n    -webkit-transform: scale(0.75);\n    -moz-transform: scale(0.75);\n    transform: scale(0.75);\n    opacity: 0.75; /*opacity proportional to size*/\n\n    -webkit-animation: moveclouds 18s linear infinite;\n    -moz-animation: moveclouds 18s linear infinite;\n    -o-animation: moveclouds 18s linear infinite;\n}\n.x5 {\n    left: -150px; top: -150px;\n\n    -webkit-transform: scale(0.8);\n    -moz-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0.8; /*opacity proportional to size*/\n\n    -webkit-animation: moveclouds 20s linear infinite;\n    -moz-animation: moveclouds 20s linear infinite;\n    -o-animation: moveclouds 20s linear infinite;\n}\n@-webkit-keyframes moveclouds {\n    0% {margin-left: 1600px;}\n    100% {margin-left: -1600px;}\n}\n@-moz-keyframes moveclouds {\n    0% {margin-left: 1600px;}\n    100% {margin-left: -1600px;}\n}\n@-o-keyframes moveclouds {\n    0% {margin-left: 1600px;}\n    100% {margin-left: -1600px;}\n}\n', 1, 1, 1467935892, 1467935892),
(3, 'Gray Shadow', 'A gray background with a gray form and a bluish green button.', '#eeeeee', '\nbody {\n    background-color: transparent;\n    padding: 0;\n    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-size: 14px;\n    color: #000;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    body {\n        padding: 50px 25%;\n        background-color: #eeeeee;\n    }\n}\nform {\n    border-style: solid;\n    background-image: -moz-linear-gradient(top, rgba(255, 255, 255, 1), rgba(242, 242, 242, 1));\n    background-image: linear-gradient(top, rgba(255, 255, 255, 1), rgba(242, 242, 242, 1));\n    background-image: -webkit-linear-gradient(top, rgba(255, 255, 255, 1), rgba(242, 242, 242, 1));\n    background-repeat: no-repeat;\n    background-position: center center;\n    background-size: 100% 100%;\n    padding: 15px 25px;\n    border-radius: 1px;\n    box-shadow: 0px 0px 0px 0px rgba(50, 50, 50, 0.75);\n    border-width: 4px;\n    border-color: rgb(232,232,232);\n}\nh3 {\n    text-align: center;\n    color: rgb(89,89,89);\n    font-size: 40px;\n}\np.description {\n    text-align: center;\n    color: rgb(51, 51, 51);\n    font-size: 17px;\n}\np.info {\n    color: rgba(107,107,107,1);\n    font-size: 12px;\n    margin-top: 15px;\n}\n.form-control {\n    width: 100%;\n    height: 100%;\n    -webkit-box-sizing: padding-box;\n    -moz-box-sizing: padding-box;\n    box-sizing: padding-box;\n    -webkit-appearance: none;\n    -moz-appearance: none;\n    appearance: none;\n    padding: 15px;\n    font-size: 15px;\n    line-height: 15px;\n    color: #000;\n}\n.form-control:focus {\n    border-color: rgba(117,194,204,1);\n    box-shadow: 0 1px 1px rgba(117,194,204,0.75) inset, 0 0 8px rgba(134,215,225,1);\n    outline: 0 none;\n}\n.form-control::-webkit-input-placeholder { color: #a1a1a1; }\n.form-control:-moz-placeholder { color: #a1a1a1; }\n.form-control::-moz-placeholder { color: #a1a1a1; }\n.form-control:-ms-input-placeholder { color: #a1a1a1; }\n.btn {\n    width: 100%;\n    color: rgba(255,255,255,1);\n    font-size: 19px;\n    background-image: -webkit-linear-gradient(top, rgba(134,215,225,1), rgba(117,194,204,1));\n    padding: 11px;\n    border-radius: 0px;\n    border: transparent;\n    box-shadow: none;\n}\n.btn:focus, .btn:hover, input.btn:active {\n    background-image: -webkit-linear-gradient(bottom, rgba(134,215,225,1), rgba(117,194,204,1));\n    color: rgba(255, 255, 255, 1);\n    box-shadow: none !important;\n    outline: 0 none !important;\n    border-color: transparent;\n}\n', 1, 1, 1467935892, 1467935892),
(4, 'Light Gray', 'Light gray form over dark gray body, big fields with a green button.', '#a9a9a9', '\n@import url(https://fonts.googleapis.com/css?family=PT+Sans:400);\n@import url(https://fonts.googleapis.com/css?family=Oswald:400);\nbody {\n    font-family: "PT Sans", sans-serif;\n    padding: 0;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    body {\n        padding: 60px 30%;\n        background-color: #a9a9a9;\n    }\n}\nform {\n    padding: 35px;\n    background-color: #f3f3f3;\n    border: 1px solid rgba(0, 0, 0, 0.34);\n    -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.1);\n    -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.1);\n    box-shadow: 0 3px 9px rgba(0, 0, 0, 0.1);\n    border-radius: 10px;\n    color: #555 !important;\n}\nh3, p {\n    text-align: center;\n    font-size: 16px;\n}\nh3 {\n    margin: 5px;\n    padding: 10px 0 0 0;\n    font-size: 28px;\n    font-family: "Oswald", sans-serif;\n    text-shadow: 2px 2px 3px rgba(255,255,255,0.1);\n}\np.description {\n    padding: 5px 0 24px 0;\n}\n.note {\n    padding: 24px;\n    margin: 10px 0;\n}\n.form-group {\n    margin-bottom: 1px;\n    position: relative;\n}\n.form-action {\n    margin-top: 25px;\n}\n.control-label {\n    font-size: 16px;\n    margin: 15px 0 0 0;\n}\n.btn {\n    padding: 12px 18px;\n    width: 100%;\n    border: transparent;\n    -webkit-border-radius: 5px;\n    -moz-border-radius: 5px;\n    border-radius: 5px;\n    height: 60px;\n    font-size: 20px;\n    text-shadow: 0 0 #000;\n    -webkit-transition: background-color .1s ease;\n    transition: background-color .1s ease;\n}\n.btn-primary {\n    background-color: #1ec185;\n}\n.btn-primary:focus, .btn-primary:active, .btn-primary:hover {\n    background-color: #1baf79 !important;\n    border-color: transparent;\n    color: #fff;\n}\n.form-control {\n    font-size: 16px;\n    color: #6f6f6f;\n    border: 2px solid #FFFFFF;\n    height: 52px;\n}\n.form-control:focus {\n    border: 2px solid rgb(30, 193, 133);\n    border: 2px solid rgba(30, 193, 133, 0.8);\n    box-shadow: none;\n    outline: 0 none;\n}\n.form-group-icon:before {\n    position: absolute;\n    font-family: "Glyphicons Regular";\n    font-size: 36px;\n    color: darkgray;\n    top: 38px;\n    left: 10px;\n}\n.form-group-icon .form-control {\n    padding: 15px 12px 12px 52px;\n}\n.user-icon:before {\n    content: "\\e004";\n}\n.email-icon:before {\n    content: "\\2709";\n}\n.phone-icon:before {\n    content: "\\e164";\n}\n', 1, 1, 1467935892, 1467935892),
(5, 'Flower Shop', 'Yellow form over Green texture. Orange header and button.', '#FBEFBF', '\n@import url(https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,700);\n\nbody {\n    font-family: "Source Sans Pro", sans-serif;\n    font-size: 16px;\n    padding: 0;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    body {\n        padding: 50px 25%;\n        background: url("../static_files/images/themes/flower-shop.jpg") repeat #AFC86A;\n    }\n}\nform {\n    background-color: rgb(251, 239, 191);\n    padding-bottom: 50px;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    form {\n        -webkit-box-shadow: 1px 0 11px rgba(50,50,50,0.74);\n        -moz-box-shadow: 1px 0 11px rgba(50,50,50,0.74);\n        box-shadow: 1px 0 11px rgba(50,50,50,0.74);\n    }\n}\n.legend {\n    font-size: 33px;\n    margin: 0 0 25px 0;\n    padding: 15px 0;\n    text-align: center;\n    background-color: rgba(251, 89, 39, 0.9);\n    color: white;\n    font-weight: 700;\n    text-shadow: -1px -1px 0 rgba(184, 60, 42, 0.5),\n    -2px -2px 1px rgba(184, 60, 42, 0.5);\n}\np {\n    margin: 0 15%;\n}\n.form-group, .form-action {\n    margin: 0 15%;\n}\n.form-control {\n    height: 42px;\n    border: 3px solid rgb(236, 217, 142);\n}\n.form-control:focus {\n    border-color: rgb(253, 186, 144);\n    box-shadow: 0 1px 1px rgba(253, 186, 144, 0.75) inset, 0 0 8px rgba(253, 186, 144, 1);\n    outline: 0 none;\n}\n.form-control::-webkit-input-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\n.form-control:-moz-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\n.form-control::-moz-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\n.form-control:-ms-input-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\n.control-label {\n    font-weight: bold;\n    margin-top: 15px;\n}\n.btn {\n    background-color: rgb(251, 89, 39);\n    border: transparent;\n    width: 100%;\n    margin-top: 15px;\n    font-size: 22px;\n    padding: 8px 0 8px 0;\n    -webkit-border-radius: 3px;\n    -moz-border-radius: 3px;\n    border-radius: 3px;\n    text-shadow: -1px -1px 0 rgba(184, 60, 42, 0.5),\n    -2px -2px 1px rgba(184, 60, 42, 0.5);\n}\n.btn:focus, .btn:active, .btn:focus:active {\n    outline: none;\n    background-color:#f14c26 !important;\n    box-shadow: 0 1px 1px rgba(253, 186, 144, 0.75) inset, 0 0 8px rgba(253, 186, 144, 1);\n}\n.btn:hover{\n    background-color:#fe6a48 !important;\n}\n', 1, 1, 1467935892, 1467935892),
(6, 'White Smoke', 'Clean design for multiple purposes. Wide fields with a blue button and without shadows.', '#2B8DD6', '\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:400,600);\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,600);\nbody {\n    background-color: #fbfcfd;\n    padding: 20px;\n    font-family: "Open Sans", Helvetica, Arial, sans-serif;\n}\n.legend {\n    font-family: "Raleway", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-size: 20px;\n    font-weight: 600;\n    color: #515151;\n}\n.form-control {\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 400;\n    height:55px;\n	border-radius:3px;\n	border-color:#d3d3d3;\n}\n.form-control:focus {\n    border:1px solid #2b8dd6;\n    box-shadow: none;\n    outline: 0 none;\n}\n.form-control::-webkit-input-placeholder { color: #797979; }\n.form-control:-moz-placeholder { color: #797979; }\n.form-control::-moz-placeholder { color: #797979; }\n.form-control:-ms-input-placeholder { color: #797979; }\n.control-label {\n	font-weight: 600;\n}\n.btn {\n    background-color: #2b8dd6;\n    box-sizing: border-box !important;\n    border: 0 !important;\n    border-bottom: 3px solid rgba(0, 0, 0, 0.1) !important;\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 600;\n    box-shadow: 0 0 0 !important;\n    padding: 16px 32px;\n}\n.btn:hover, .btn:active, .btn:focus {\n    background-color: #2b8dd6;\n    opacity:0.85;\n	border:0 !important;\n	border-bottom:3px solid rgba(0, 0, 0, 0.1) !important;\n}\n', 1, 1, 1467935892, 1467935892),
(7, 'Habitat', 'Beauty gradient with a semi-transparent text.', '#1274a3', '\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700);\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,700);\n/**\n * Design inspired in https://habitat.inkling.com/signup\n */\nbody {\n    background: linear-gradient(135deg, #1274a3 0%,#68ad74 100%);\n    padding: 20px;\n    font-family: "Open Sans", Helvetica, Arial, sans-serif;\n    color: rgb(255, 255, 255);\n    color: rgba(255, 255, 255, 0.75098);\n}\n.legend {\n    font-family: "Raleway", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-size: 26px;\n    font-weight: 400;\n    color: #FFFFFF;\n    color: rgb(255, 255, 255);\n}\np, .checkbox-inline, .radio-inline {\n    font-weight: 300;\n}\n.form-control {\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 400;\n    transition: box-shadow 150ms ease-in-out;\n    background-color: rgb(10,13,25);\n    background-color: rgba(10,13,25,0.1);\n    border-radius: 3px;\n    outline: solid 2px rgba(255,255,255,0);\n    border-color: transparent;\n    box-shadow: inset 0 1px 1px rgba(10,13,25,0.15),0 1px 0 rgba(255,255,255,0.1);\n    box-sizing: border-box;\n    font-family: inherit;\n    font-size: 16px;\n    height: 45px;\n    width: 100%;\n    color: #FFFFFF;\n    color: rgba(255, 255, 255, 0.92098);\n}\n.form-control:focus {\n    box-shadow: inset 0 0 0 1px #fff,inset 0 1px 2px rgba(10,13,25,0.15),0 0 8px rgba(255,255,255,0.5),0 1px 0 rgba(255,255,255,0.1);\n    transition: none;\n}\n.form-control::-webkit-input-placeholder {\n    color: #FFFFFF;\n    color: rgba(255,255,255,0.35);\n}\n.form-control:-moz-placeholder {\n    color: #FFFFFF;\n    color: rgba(255,255,255,0.35);\n}\n.form-control::-moz-placeholder {\n    color: #FFFFFF;\n    color: rgba(255,255,255,0.35);\n}\n.form-control:-ms-input-placeholder {\n    color: #FFFFFF;\n    color: rgba(255,255,255,0.35);\n}\n.control-label {\n	font-weight: 600;\n}\n.required-control .control-label:after {\n    color: rgb(255, 255, 255) !important;\n    color: rgba(255, 255, 255, 0.75098) !important;\n}\n.btn {\n    box-sizing: border-box !important;\n    border: 0 !important;\n    border-bottom: 3px solid rgba(0, 0, 0, 0.1) !important;\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 600;\n    text-shadow: 0 -1px 0 rgba(255,255,255,0.1);\n    padding: 16px 32px;\n}\n.btn-primary {\n    background-color: rgb(110,238,215);\n    background-color: rgba(110,238,215,0.65);\n    box-shadow: inset 0 -2px 0 rgba(0,0,0,0.3),inset 0 1px 0 rgba(255,255,255,0.07),0 1px 1px rgba(10,13,25,0.5);\n}\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\n    background-color: rgb(110,238,215) !important;\n    background-color: rgba(110,238,215,0.45) !important;\n    box-shadow: inset 0 -2px 0 rgba(0,0,0,0.3),inset 0 1px 0 rgba(255,255,255,0.07),0 1px 1px rgba(10,13,25,0.5) !important;\n    outline: 0 none !important;\n}\n/**\n * Alerts\n */\n.alert-success {\n    background-color: #68ad74;\n    border-color: #1274a3;\n}\n.alert-danger {\n    background-color: #ff7332;\n    border-color: #1274a3;\n}\n.has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox,\n.has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label,\n.has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label {\n    color: #FFFFFF;\n}\n.has-error .help-block {\n    margin: 0;\n    padding: 5px 10px;\n    color: #FFF;\n}\n.has-error .form-control {\n    border-color: #ff7332;\n}\n', 1, 1, 1467935892, 1467935892),
(8, 'Blue Dress', 'A beauty dark theme with subtle shadow, green button and and active fields.', '#374151', '\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:400,600);\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,600);\nbody {\n    background-color: #374151;\n    padding: 20px;\n    font-family: "Open Sans", Helvetica, Arial, sans-serif;\n    color: #FBFEFB;\n    color: rgba(255, 255, 255, 0.82098);\n}\n.legend {\n    font-family: "Raleway", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-size: 28px;\n    font-weight: 400;\n    margin-bottom: 25px;\n    color: #FBFEFB;\n}\n.form-control {\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 400;\n    transition: box-shadow 150ms ease-in-out;\n    background-color: rgba(10,13,25,0.1);\n    border-radius: 5px;\n    outline: solid 2px rgba(255,255,255,0);\n    border: 2px solid transparent;\n    box-shadow: inset 0 1px 1px rgba(10,13,25,0.15),0 1px 0 rgba(255,255,255,0.1);\n    box-sizing: border-box;\n    font-family: inherit;\n    font-size: 16px;\n    height: 43px;\n    width: 100%;\n    color: #FFFFFF;\n    color: rgba(255, 255, 255, 0.82098);\n}\n.form-control:focus {\n    border:2px solid #95B366;\n    box-shadow: none;\n    outline: 0 none;\n}\n.form-control::-webkit-input-placeholder { color: #4A566A; }\n.form-control:-moz-placeholder { color: #4A566A; }\n.form-control::-moz-placeholder { color: #4A566A; }\n.form-control:-ms-input-placeholder { color: #4A566A; }\n.control-label {\n    color: #FBFEFB;\n	font-weight: 600;\n}\n.btn {\n    box-sizing: border-box !important;\n    border: 0 !important;\n    border-bottom: 3px solid rgba(0, 0, 0, 0.1) !important;\n    font-weight: 600;\n    padding: 9px 32px;\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n}\n.btn-primary {\n    background-color: #95B366;\n}\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\n    background-color: #95B366 !important;\n    opacity:0.85;\n	box-shadow: none;\n    outline: 0 none;\n}\n', 1, 1, 1467935892, 1467935892),
(9, 'Tea Time', 'Beautiful theme inspired by a cup of tea. With strong contrasts, a transparent black background and white letters, you can see a picture.', '#000000', '\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700);\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,600);\nbody {\n    background-color: transparent;\n    background: url("../static_files/images/themes/tea-time.jpg") no-repeat center center fixed;\n    -webkit-background-size: cover;\n    -moz-background-size: cover;\n    -o-background-size: cover;\n    background-size: cover;\n    font-family: "Open Sans", Helvetica, Arial, sans-serif;\n    color: #FFFFFF;\n}\nform {\n    background-color: rgb(0, 0, 0);\n    background-color: rgba(0, 0, 0, 0.75);\n    padding: 20px;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    /* Hide background image of the body in embed view */\n    .app-embed {\n        background: transparent;\n    }\n    form {\n        padding: 40px;\n        border-radius: 10px;\n    }\n}\n.legend {\n    font-family: "Raleway", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-size: 28px;\n    font-weight: 600;\n    margin: 0 0 20px 0;\n}\np, .checkbox-inline, .radio-inline {\n    font-weight: 300;\n}\n.form-group, .form-action {\n    margin-bottom: 25px;\n}\n.form-control {\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    color: #FFFFFF;\n    border: 1px solid #FFFFFF;\n    background-color: #000000;\n    background-color: rgba(0, 0, 0, 0);\n    height: 42px;\n}\n.form-control:focus {\n    border-color: #F9690E;\n    box-shadow: none;\n    outline: 0 none;\n    transition: none;\n}\n.form-control::-webkit-input-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.85);\n}\n.form-control:-moz-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.65);\n}\n.form-control::-moz-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.65);\n}\n.form-control:-ms-input-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.65);\n}\n.control-label {\n	font-weight: 600;\n}\n.btn {\n    border-radius: 26px;\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 600;\n    padding: 12px 42px;\n}\n.btn-primary {\n    border-color: transparent;\n    background-color: #F9690E;\n}\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\n    border-color: transparent !important;\n    background-color: #fa7d2e !important;\n    box-shadow: none !important;\n    outline: 0 none !important;\n}\n/**\n * Alerts\n */\n.alert-success {\n    background-color: #018930;\n    background-color: rgba(1,137,48,0.75);\n    border-color: #018930;\n}\n.alert-danger {\n    background-color: #FF0000;\n    background-color: rgba(255, 0, 0, 0.75);\n    border-color: #FF0000;\n}\n', 1, 1, 1467935892, 1467935892),
(10, 'Purple Bay', 'A purple translucent theme with white fields and blue button.', '#2b2c4e', '\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700);\n@import url(https://fonts.googleapis.com/css?family=Raleway:300,400);\nbody {\n    padding: 20px;\n    background-color: transparent;\n    background: url("../static_files/images/themes/purple-bay.jpg") no-repeat center center fixed;\n    -webkit-background-size: cover;\n    -moz-background-size: cover;\n    -o-background-size: cover;\n    background-size: cover;\n    font-family: "Open Sans", Helvetica, Arial, sans-serif;\n    color: #cdcdcd;\n    color: rgba(255,255,255,0.80);\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    /* Hide background image of the body in embed view */\n    .app-embed {\n        background: transparent;\n        padding: 50px 25%;\n    }\n}\n.legend {\n    display: inline-block;\n    font-family: "Raleway", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-size: 24px;\n    font-weight: 300;\n    text-transform: uppercase;\n    padding-bottom: 3px;\n    border-bottom: 2px solid #1762ee;\n    margin: 0 0 20px 0;\n    color: #ffffff;\n}\n/* Small devices (tablets, 768px and up) */\n@media (min-width: 768px) {\n    .legend {\n        font-size: 28px;\n    }\n}\np {\n    font-weight: 300;\n}\n.form-group, .form-action {\n    margin-bottom: 25px;\n}\n.form-control {\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    color: #FFFFFF;\n    border-color: transparent;\n    background-color: #000000;\n    background-color: rgba(255, 255, 255, 0.15);\n    height: 42px;\n}\n.form-control:focus {\n    border-color: #ffffff;\n    border-color: rgba(255, 255, 255, 0.30);\n    box-shadow: none;\n    outline: 0 none;\n    transition: none;\n}\n.form-control::-webkit-input-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.85);\n}\n.form-control:-moz-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.65);\n}\n.form-control::-moz-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.65);\n}\n.form-control:-ms-input-placeholder {\n    color: #D2D7D3;\n    color: rgba(255,255,255,0.65);\n}\n.control-label, .checkbox-inline, .radio-inline {\n    color: #cdcdcd;\n    color: rgba(255,255,255,0.80);\n	font-weight: 400;\n}\n.control-label {\n	text-transform: uppercase;\n}\n.btn {\n    font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;\n    font-weight: 600;\n    padding: 12px 42px;\n}\n.btn-primary {\n    border-color: transparent;\n    background-color: #1762ee;\n}\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\n    border-color: transparent !important;\n    background-color: #3375f0 !important;\n    box-shadow: none !important;\n    outline: 0 none !important;\n}\n/**\n * Alerts\n */\n.alert-success {\n    background-color: #018930;\n    background-color: rgba(1,137,48,0.75);\n    border-color: #018930;\n}\n.alert-danger {\n    background-color: #FF0000;\n    background-color: rgba(255, 0, 0, 0.75);\n    border-color: #FF0000;\n}\n', 1, 1, 1467935892, 1467935892);

CREATE TABLE `user` (
  `id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `status` smallint(6) NOT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `auth_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `access_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logged_in_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logged_in_at` timestamp NULL DEFAULT NULL,
  `created_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `banned_at` timestamp NULL DEFAULT NULL,
  `banned_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `user_auth` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `provider` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `provider_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `provider_attributes` text COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE `user_token` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `type` smallint(6) NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `data` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `expired_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


ALTER TABLE `addon`
  ADD UNIQUE KEY `id` (`id`);

ALTER TABLE `form`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `form_chart`
  ADD UNIQUE KEY `form_chart_form_id_name` (`form_id`,`name`),
  ADD KEY `form_chart_form_id` (`form_id`);

ALTER TABLE `form_confirmation`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_confirmation_form_id` (`form_id`);

ALTER TABLE `form_data`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_data_form_id` (`form_id`);

ALTER TABLE `form_email`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_email_form_id` (`form_id`);

ALTER TABLE `form_rule`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_rule_form_id` (`form_id`);

ALTER TABLE `form_submission`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_submission_form_id` (`form_id`);

ALTER TABLE `form_submission_file`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_submission_file_submission_id` (`submission_id`),
  ADD KEY `form_submission_file_form_id` (`form_id`);

ALTER TABLE `form_ui`
  ADD PRIMARY KEY (`id`),
  ADD KEY `form_ui_form_id` (`form_id`);

ALTER TABLE `form_user`
  ADD UNIQUE KEY `form_user_form_id_user_id` (`form_id`,`user_id`),
  ADD KEY `form_user_form_id` (`form_id`),
  ADD KEY `form_user_user_id` (`user_id`);

ALTER TABLE `mail_queue`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `migration`
  ADD PRIMARY KEY (`version`);

ALTER TABLE `profile`
  ADD PRIMARY KEY (`id`),
  ADD KEY `profile_user_id` (`user_id`);

ALTER TABLE `role`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `setting`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_category_key` (`category`,`key`);

ALTER TABLE `stats_performance`
  ADD UNIQUE KEY `stats_performance_day_app_id` (`day`,`app_id`);

ALTER TABLE `template`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `template_category`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `theme`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `user_email` (`email`),
  ADD UNIQUE KEY `user_username` (`username`),
  ADD KEY `user_role_id` (`role_id`);

ALTER TABLE `user_auth`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_auth_provider_id` (`provider_id`),
  ADD KEY `user_auth_user_id` (`user_id`);

ALTER TABLE `user_token`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `user_key_key` (`token`),
  ADD KEY `user_key_user_id` (`user_id`);


ALTER TABLE `form`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_confirmation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_data`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_email`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_rule`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_submission`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_submission_file`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `form_ui`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `mail_queue`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `profile`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `role`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;
ALTER TABLE `setting`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;
ALTER TABLE `template`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;
ALTER TABLE `template_category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
ALTER TABLE `theme`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;
ALTER TABLE `user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `user_auth`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `user_token`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `profile`
  ADD CONSTRAINT `profile_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`);

ALTER TABLE `user`
  ADD CONSTRAINT `user_role_id` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`);

ALTER TABLE `user_auth`
  ADD CONSTRAINT `user_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`);

ALTER TABLE `user_token`
  ADD CONSTRAINT `user_key_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
