<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**

 * CodeIgniter

 *

 * An open source application development framework for PHP 5.1.6 or newer

 *

 * @package		CodeIgniter

 * @copyright	Copyright (c) 2008 - 2011, EllisLab, Inc.

 * @license		http://codeigniter.com/user_guide/license.html

 * @author		EllisLab Dev Team

 * @link		http://codeigniter.com

 * @since		Version 2.1.2

 * @filesource

 */



// ------------------------------------------------------------------------



/**

 * PDO Utility Class

 *

 * @category	Database

 * @author		EllisLab Dev Team

 * @link		http://codeigniter.com/database/

 */

class CI_DB_pdo_utility extends CI_DB_utility {



	/**

	 * List databases

	 *

	 * @access	private

	 * @return	bool

	 */

	function _list_databases()

	{

		// Not sure if PDO lets you list all databases...

		if ($this->db->db_debug)

		{

			return $this->db->display_error('db_unsuported_feature');

		}

		return FALSE;

	}



	// --------------------------------------------------------------------



	/**

	 * Optimize table query

	 *

	 * Generates a platform-specific query so that a table can be optimized

	 *

	 * @access	private

	 * @param	string	the table name

	 * @return	object

	 */

	function _optimize_table($table)

	{

		// Not a supported PDO feature

		if ($this->db->db_debug)

		{

			return $this->db->display_error('db_unsuported_feature');

		}

		return FALSE;

	}



	// --------------------------------------------------------------------



	/**

	 * Repair table query

	 *

	 * Generates a platform-specific query so that a table can be repaired

	 *

	 * @access	private

	 * @param	string	the table name

	 * @return	object

	 */

	function _repair_table($table)

	{

		// Not a supported PDO feature

		if ($this->db->db_debug)

		{

			return $this->db->display_error('db_unsuported_feature');

		}

		return FALSE;

	}



	// --------------------------------------------------------------------



	/**

	 * PDO Export

	 *

	 * @access	private

	 * @param	array	Preferences

	 * @return	mixed

	 */

	function _backup($params = array())

	{

		// Currently unsupported

		return $this->db->display_error('db_unsuported_feature');

	}



}



/* End of file pdo_utility.php */

/* Location: ./system/database/drivers/pdo/pdo_utility.php */