<?php
/*
*   Currecy convert Class
*
*   This class can be used to convert one currecy to an other.
*
*   @copyright      $Date: 2009-09-29 23:48:13 +0200 (di, 29 sep 2009) $
*   @version        $Rev: 263 $
*   @author         $Author: Wim $
*
*	---- CURRENCY STRINGS ----
*	
* AED: U.A.E. Dirham
* ANG: Netherland Antilles Guilder
* ARS: Argentine Peso
* AUD: Australian Dollar
* GBP: British pounds
* BGN: Bulgarian levs
* BHD: Bahraini Dinar
* BND: Brunei Dollar
* BRL: Brazil Real
* BWP: Botswana Pula 
* CAD: Canadian Dollar
* CHF: Swiss Franc
* CLP: Chilean Peso
* CNY: China Renminbi
* COP: Colombian Peso
* CRC: Costa Rica Colon
* CZK: Czech Koruna
* DKK: Danish Krone
* DOP: Dominican Republic
* DZD: Algerian Dinar
* EEK: Estonian Kroon
* EGP: Egyptian Pound
* EUR: European Euro
* FJD: Fiji Dollar
* GBP: British Pound 
* HKD: Hong Kong Dollar 
* HNL: Honduras Lempira
* HRK: Croatian Kuna
* HUF: Hungarian Forint 
* IDR: Indonesian Rupiah
* ILS: Israeli Shekel
* INR: Indian Rupee
* ISK: Iceland Krona
* JMD: Jamaica Dollar
* JOD: Jordanian Dinar
* JPY: Japanese Yen
* KES: Kenyan Shilling
* KRW: South Korean Won
* KWD: Kuwaiti Dinar
* KYD: Cayman Islands
* KZT: Kazakhstan Tenge
* LBP: Lebanese Pound
* LKR: Sri Lankan Rupee
* LTL: Lithuanian Lit
* LVL: Latvian Lat
* MAD: Moroccan Dirham
* MDL: Moldova Lei
* MUR: Mauritius Rupee 
* MXN: Mexican pesos 
* MYR: Malaysian Ringgit
* NGN: Nigeria Naira
* NOK: Norwegian Krone
* NZD: New Zealand Dollar 
* OMR: Omani Rial
* PEN: Peruvian New Sol 
* PGK: Papua New Guinea Kina 
* PHP: Philippines Peso
* PKR: Pakistani Rupee
* PLN: Polish zloty';
* PYG: Paraguay Guarani
* QAR: Qatari Riyal
* RON: Romanian leu
* RUB: Russian Ruble
* SAR: Saudi Riyal
* SCR: Seychelles Rupee
* SEK: Swedish Krona
* SGD: Singapore Dollar 
* SKK: Slovakia Koruna
* SLL: Sierra Leone Leone 
* SVC: El Salvador Colon
* THB: Thai Baht
* TND: Tunisian Dinar 
* TRY: Turkish liras
* TTD: Trinidad/tobago Dollar
* TWD: Taiwan Dollar
* TZS: Tanzanian Shilling
* UAH: Ukraine Hryvna
* UGX: Ugandan Shilling
* USD: United States Dollar 
* UZS: Uzbekistan Sum
* VEB: Venezuelan Bolivar 
* VND: Vietnam Dong
* YER: Yemeni Rial
* ZAR: South African Rand
* ZMK: Zambian Kwacha
*
*	---- USAGE ----

	// To calculate Japanese Yen to US Dollars
*	$CurrencyConverter->Calculate("JPY", "USD", 1000);
*    
*/
class CurrencyConverter {

	/**
	 * Google format url
	 * 
	 * @var string
	 */
	private $_gurl = "http://www.google.com.ph/search?hl=nl&q=%d+%s+to+%s&btnG=Zoeken";
	
	/**
	 * Currencies data file content
	 * 
	 * @var string
	 */
	private $_currencyDataContent;
	
	/**
	 * Rates
	 * 
	 * @var array
	 */
	private $_currencyRatesArray;
	
	/**
	 * Strings
	 * 
	 * @var string
	 */
	private $_currencyStringArray;
	
	/**
	 * Cache file
	 * 
	 * @var string
	 */
	private $_cache;
	
	/**
	 * Save on destruct
	 *
	 * @var bool
	 */
	 private $_updatecache = FALSE;
	 
	 /**
	  * Cache time to live
	  *
	  * @const int
	  */
	 const ttl = 5;
	
	/**
	 * Constructor
	 * 
	 * @access public
	 * @param string $cachedcontent
	 * @return void
	 */
	public function __construct($cache=''){
		
		// Add possible currencies
		$currencies['AED'] = 'U.A.E. Dirham';
		$currencies['ANG'] = 'Netherland Antilles Guilder';
		$currencies['ARS'] = 'Argentine Peso';
		$currencies['AUD'] = 'Australian Dollar'; 
		$currencies['GBP'] = 'British pounds'; 
		$currencies['BGN'] = 'Bulgarian levs'; 
		$currencies['BHD'] = 'Bahraini Dinar'; 
		$currencies['BND'] = 'Brunei Dollar'; 
		$currencies['BRL'] = 'Brazil Real'; 
		$currencies['BWP'] = 'Botswana Pula';  
		$currencies['CAD'] = 'Canadian Dollar'; 
		$currencies['CHF'] = 'Swiss Franc'; 
		$currencies['CLP'] = 'Chilean Peso'; 
		$currencies['CNY'] = 'China Renminbi'; 
		$currencies['COP'] = 'Colombian Peso'; 
		$currencies['CRC'] = 'Costa Rica Colon'; 
		$currencies['CZK'] = 'Czech Koruna'; 
		$currencies['DKK'] = 'Danish Krone'; 
		$currencies['DOP'] = 'Dominican Republic'; 
		$currencies['DZD'] = 'Algerian Dinar'; 
		$currencies['EEK'] = 'Estonian Kroon'; 
		$currencies['EGP'] = 'Egyptian Pound'; 
		$currencies['EUR'] = 'European Euro'; 
		$currencies['FJD'] = 'Fiji Dollar'; 
		$currencies['GBP'] = 'British Pound';  
		$currencies['HKD'] = 'Hong Kong Dollar';  
		$currencies['HNL'] = 'Honduras Lempira'; 
		$currencies['HRK'] = 'Croatian Kuna'; 
		$currencies['HUF'] = 'Hungarian Forint';  
		$currencies['IDR'] = 'Indonesian Rupiah'; 
		$currencies['ILS'] = 'Israeli Shekel'; 
		$currencies['INR'] = 'Indian Rupee'; 
		$currencies['ISK'] = 'Iceland Krona'; 
		$currencies['JMD'] = 'Jamaica Dollar'; 
		$currencies['JOD'] = 'Jordanian Dinar'; 
		$currencies['JPY'] = 'Japanese Yen'; 
		$currencies['KES'] = 'Kenyan Shilling'; 
		$currencies['KRW'] = 'South Korean Won'; 
		$currencies['KWD'] = 'Kuwaiti Dinar'; 
		$currencies['KYD'] = 'Cayman Islands'; 
		$currencies['KZT'] = 'Kazakhstan Tenge'; 
		$currencies['LBP'] = 'Lebanese Pound'; 
		$currencies['LKR'] = 'Sri Lankan Rupee'; 
		$currencies['LTL'] = 'Lithuanian Lit'; 
		$currencies['LVL'] = 'Latvian Lat'; 
		$currencies['MAD'] = 'Moroccan Dirham'; 
		$currencies['MDL'] = 'Moldova Lei'; 
		$currencies['MUR'] = 'Mauritius Rupee';  
		$currencies['MXN'] = 'Mexican pesos';  
		$currencies['MYR'] = 'Malaysian Ringgit'; 
		$currencies['NGN'] = 'Nigeria Naira'; 
		$currencies['NOK'] = 'Norwegian Krone'; 
		$currencies['NZD'] = 'New Zealand Dollar';  
		$currencies['OMR'] = 'Omani Rial'; 
		$currencies['PEN'] = 'Peruvian New Sol';  
		$currencies['PGK'] = 'Papua New Guinea Kina';  
		$currencies['PHP'] = 'Philippines Peso'; 
		$currencies['PKR'] = 'Pakistani Rupee'; 
		$currencies['PLN'] = 'Polish zloty';
		$currencies['PYG'] = 'Paraguay Guarani'; 
		$currencies['QAR'] = 'Qatari Riyal'; 
		$currencies['RON'] = 'Romanian leu'; 
		$currencies['RUB'] = 'Russian Ruble'; 
		$currencies['SAR'] = 'Saudi Riyal'; 
		$currencies['SCR'] = 'Seychelles Rupee'; 
		$currencies['SEK'] = 'Swedish Krona'; 
		$currencies['SGD'] = 'Singapore Dollar';  
		$currencies['SKK'] = 'Slovakia Koruna'; 
		$currencies['SLL'] = 'Sierra Leone Leone';  
		$currencies['SVC'] = 'El Salvador Colon'; 
		$currencies['THB'] = 'Thai Baht'; 
		$currencies['TND'] = 'Tunisian Dinar';  
		$currencies['TRY'] = 'Turkish liras'; 
		$currencies['TTD'] = 'Trinidad/tobago Dollar'; 
		$currencies['TWD'] = 'Taiwan Dollar'; 
		$currencies['TZS'] = 'Tanzanian Shilling'; 
		$currencies['UAH'] = 'Ukraine Hryvna'; 
		$currencies['UGX'] = 'Ugandan Shilling'; 
		$currencies['USD'] = 'United States Dollar';  
		$currencies['UZS'] = 'Uzbekistan Sum'; 
		$currencies['VEB'] = 'Venezuelan Bolivar';  
		$currencies['VND'] = 'Vietnam Dong'; 
		$currencies['YER'] = 'Yemeni Rial'; 
		$currencies['ZAR'] = 'South African Rand'; 
		$currencies['ZMK'] = 'Zambian Kwacha'; 
		$this->_currencyStringArray = $currencies;
		
		if(!empty($cache)){
			$cache		 	= str_replace("\\", "/", $cache);
			$sepperator 	= (substr($cache,0, 1) == "/") ? "" : "/";
			$this->_cache 	= dirname(__FILE__) . $sepperator . $cache;
			if(file_exists($this->_cache)){
				$this->load();
			}
		}
	}
	
	public function __destruct(){
		if(!empty($this->_cache) && $this->_updatecache){
			$this->save();
		}
	}
	
	/**
	 * Get the rate for a currency
	 * 
	 * @access private
	 * @param string $currency
	 * @return void
	 */
	private function getRate($currency="USD"){
		if(isset($this->_currencyStringArray[$currency])){
			
			// Euro is the standard rate
			if($currency == "EUR"){
				$this->_currencyRatesArray[$currency]['timestamp'] = time();
				$this->_currencyRatesArray[$currency]['rate'] = 1;
				return;
			}

			if(!isset($this->_currencyRatesArray[$currency]) || (isset($this->_currencyRatesArray[$currency]['timestamp']) && $this->_currencyRatesArray[$currency]['timestamp'] < (time() - self::ttl))){
				
				// Create url
				$url = sprintf($this->_gurl, 1, "EUR", $currency);

				// Get content
				$content = file_get_contents($url);

				// Strip conversion
				preg_match_all('/font-size:138%\"\>\<b\>(.*)\<\/b\>\<\/h2>/i',$content,$matches); 
				if(isset($matches[1][0])){
					$parts = explode(" ", trim(str_replace("1 Euro = ", "", $matches[1][0])));
				}

				// Add rate to the global array
				$this->_currencyRatesArray[$currency]['timestamp'] = time();
				$this->_currencyRatesArray[$currency]['rate'] = $parts[0];
				
				// Set update cache on destruct
				$this->_updatecache = TRUE;
			}
		}
	}
	
	public function load(){
		if(!empty($this->_cache) && file_exists($this->_cache)){
			$this->_currencyRatesArray = unserialize(file_get_contents($this->_cache));
		}
	}
	
	public function save(){
		file_put_contents($this->_cache, serialize($this->_currencyRatesArray));
	}
	
	/**
	 * Calculate value
	 *
	 * @access public
	 * @param string $from
	 * @param string $to
	 * @param double $value
	 * @return double
	 */
	public function Convert( $from, $to, $value ){
		
		if(!isset($this->_currencyStringArray[$from]) || !isset($this->_currencyStringArray[$to])){
			trigger_error("Cannot convert currency because \"$from\" or \"$to\" is not a valid currencie.", E_USER_WARNING);
			exit();
		}
		$value = doubleval($value);
		
		// Check if $value is double
		if(!is_double($value) && !is_int($value)){
			trigger_error("Value must be a double or a integer.");
			exit();
		}
		
		// Get rates
		$this->getRate($from);
		$this->getRate($to);
		
		// Calculate Euro if not Euro
		if($from != "EUR"){
			$euro = $value / $this->_currencyRatesArray[$from]['rate'];
		}else{
			$euro = $value;
		}
		
		// Calculate to asked currency
		if($to != "EUR"){
			return $euro * $this->_currencyRatesArray[$to]['rate'];
		}else{
			return $euro;
		}
		
	}
	
	/**
	 * Return content that can be cached
	 * 
	 * @access public
	 * @return string
	 */
	public function CacheContent(){
		return $this->_currencyDataContent;
	}
	
	/**
	 * Return currencies array
	 * 
	 * @access public
	 * @return array
	 */
	public function GetCurrencies(){
		return	$this->_currencyStringArray;	
	}
	
}
