<?php
class EmailValidator{
    private $emailAddress;
    
    public function setEmailAddress($emailAddress){
        $this->emailAddress=$emailAddress;
    }
    
    public function getEmailAddress(){
        return $this->emailAddress;
    }
    
    //validation rules
    public function isEmail(){
        return preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/',
                    $this->getEmailAddress());
    }
    
    public function minLength($length){       
        return strlen($this->getEmailAddress())>=$length;
    }
    
    public function maxLength($length){
        return strlen($this->getEmailAddress())<=$length;
    }
    
    public function alphaNumeric(){
        return preg_match( '/[A-Za-z]+[0-9]+/',
                        $this->getEmailAddress());
    }
    
}
?>