<?php
/**
*@author  				The-Di-Lab
*@email   				thedilab@gmail.com
*@website 				www.the-di-lab.com
*@version              1.0
**/
class Da extends Api{

        /**
         * Constructor
         */
        public function __construct(){
        	include 'lib/http_socket.php';
        	$this->socket = new HTTPSocket();
        }

        /********************* PROPERTY ********************/

        /**
         * Description
         *
         * @access protected
         * @var type
         */
        protected $socket;
        
        
        /********************* PRIVATE *********************/

        /**
         * Method description
         *
         * @author              The-Di-Lab <thedilab@gmail.com>
         * @access              private
         * @param               string
         * @param               string
         * @param               string
         * @param               string
         * @return              void
         */
        private function _loginToHost($adminUsr,$adminPass,$domain,$securityLogin=0){
        	$this->socket->connect(($securityLogin?"ssl://":'').'120.50.36.48',2222);
			$this->socket->set_login($adminUsr,$adminPass);
        }
        
       
        /********************* PUBLIC **********************/

        /**
         * Method description
         *
         * @author              The-Di-Lab <thedilab@gmail.com>
         * @access              public
         * @param               string
         * @param               string
         * @param               string
         * @param               string
         * @param               string
         * @param               string
         * @param               string
         * @return              array
         */
        public function create($adminuser,$adminpass,$domain,$euser,$edomain,$epass,$equota,$securityLogin){
        	$this->_loginToHost($adminuser,$adminpass,$domain,$securityLogin);
        	$this->socket->query('/CMD_API_POP',array(
	            'action'     =>  'create',
	            'domain'     =>   $edomain,
	            'quota'        => $equota,
	            'user'        =>  $euser,
	            'passwd'    =>    $epass
        	));	        
        	$ret = $this->socket->fetch_parsed_body();        
        	$return = array();
        	if( isset($ret['error']) && $ret['error'] == 1){
        		$return['status']=0;
        		if(isset($ret['details'])){        			
        			$return['msg']= ($ret['details']);
        		}else{
        			$return['msg']='Cannot create email account.';
        		}
        	}else if(isset($ret['error']) && $ret['error'] == 0){
        		$return['status']=1;
        	}else{
        		$return['status']=0;        		
        		if(isset($this->socket->error)){
        			$return['msg'] = current($this->socket->error);
        		}else{
        			$return['msg']='Cannot create email account, server is not responding.';
        		}        		
        	}
        	return $return;
        }

}