<?php

/**
 *
 * @author Станимир | OTW Design
 * @ver 1.0
 */
class Otw_Shortcode_Testimonialsslider extends OTW_Shortcodes {

    function __construct() {
        parent::__construct();
        $this->has_custom_options = true;
    }

    function register_external_libs() {
        $this->add_external_lib('css', 'otw-caroucel', $this->component_url . 'css/owl.carousel.css', 'all', 5);
        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 30);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 100);
        $this->add_external_lib('js', 'otw-anish', $this->component_url . 'js/jquery.animate-shadow-min.js', 'all', 98, array('jquery'));
        $this->add_external_lib('js', 'otw-quicks', $this->component_url . 'js/jquery.quicksand.js', 'all', 99, array('otw-anish'));
        $this->add_external_lib('js', 'otw-carouceljs', $this->component_url . 'js/owl.carousel.min.js', 'all', 100, array('otw-quicks'));
        $this->add_external_lib('js', 'otw-shortcode-core', $this->component_url . 'js/otw_shortcode_core.js', 'all', 129, array('otw-carouceljs'));
        $this->add_external_lib('js', 'otw-shortcode', $this->component_url . 'js/otw_shortcode.js', 'all', 130, array('otw-shortcode-core'));
        $this->add_external_lib('js', 'otw-shortcode_live_preview', $this->component_url . 'js/otw_shortcode_live_preview.js', 'live_preview', 200, array('otw-shortcode'));

        return $this;
    }

    public function apply_settings() {
        $this->_applyBoxBackgroundPattern();
        $this->_applyBoxBackgrounds();
        $this->_applyBoxBorderColors();
        $this->_applyBoxBorderStyle();
        $this->_applyBoxBorderType();
        //  $this->_applyBoxBorderWidth();
        $this->_applyBoxRoundedCourners();
        $this->_applyBoxShadow();
        $this->_applyBoxType();
        $this->_applyAutoScrolling();
        $this->_applyNumItems();
        $this->_applyShowNavigations();
    }

    private function _applyNumItems() {
        $this->settings['num_items'] = $this->_getNumItems();
        $this->settings['default_num_items'] = 2;
    }

    private function _getNumItems() {
        return array(
            '1' => $this->get_label('1 Items'),
            '2' => $this->get_label('2 Items(default)'),
            '3' => $this->get_label('3 Items'),
            '4' => $this->get_label('4 Items'),
            '5' => $this->get_label('5 Items'),
            '6' => $this->get_label('6 Items'),
            '7' => $this->get_label('7 Items'),
            '8' => $this->get_label('8 Items'),
            '9' => $this->get_label('9 Items'),
            '10' => $this->get_label('10 Items')
        );
    }

    public function getAutoScrolling() {
        return array(
            'true' => $this->get_label('Yes(Default)'),
            'false' => $this->get_label('No'),
        );
    }

    protected function _applyAutoScrolling() {
        $this->settings['auto_scolling'] = $this->getAutoScrolling();
        $this->settings['default_auto_scolling'] = 'true';
        return $this;
    }

    public function getShowNavigation() {
        return array(
            'true' => $this->get_label('Yes(Default)'),
            'false' => $this->get_label('No'),
        );
    }

    protected function _applyShowNavigations() {
        $this->settings['show_navigations'] = $this->getAutoScrolling();
        $this->settings['default_show_navigations'] = 'true';
        return $this;
    }

    public function build_shortcode_code($attributes) {
        $code = '';

        if (!$this->has_error) {
            $code .= '[otw_shortcode_testimonialsslider';
            $code .= $this->format_attribute('num_items', 'num_items', $attributes);
            $code .= $this->format_attribute('auto_scolling', 'auto_scolling', $attributes);
            $code .= $this->format_attribute('show_navigations', 'show_navigations', $attributes);
            $total_elements = $this->format_attribute('', 'num_items', $attributes);

            for ($ni = 1; $ni <= $total_elements; $ni++) {
                $code .= $this->format_attribute('item_' . $ni . '_content', 'item_' . $ni . '_content', $attributes, false, '', true);
                $code .= $this->format_attribute('item_' . $ni . '_name', 'item_' . $ni . '_name', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_position', 'item_' . $ni . '_position', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_company', 'item_' . $ni . '_company', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_website', 'item_' . $ni . '_website', $attributes);
                $code .= $this->format_attribute('item_' . $ni . '_image', 'item_' . $ni . '_image', $attributes);
//                $code .= $this->format_attribute('item_' . $ni . '_box_brd_width', 'item_' . $ni . '_box_brd_width', $attributes);
            }
            $code .= $this->format_attribute('item_box_brd_style', 'item_box_brd_style', $attributes);
            $code .= $this->format_attribute('item_box_brd_type', 'item_box_brd_type', $attributes);
            $code .= $this->format_attribute('item_box_brd_color', 'item_box_brd_color', $attributes);
//            $code .= $this->format_attribute('item_box_shadow', 'item_box_shadow', $attributes);
            $code .= $this->format_attribute('item_box_rounded_corners', 'item_box_rounded_corners', $attributes);
            $code .= $this->format_attribute('item_box_bgr', 'item_box_bgr', $attributes);
            $code .= $this->format_attribute('item_box_bgr_pattern', 'item_box_bgr_pattern', $attributes);
            $code .= $this->format_attribute('custom_class', 'custom_class', $attributes);
            $code .= $this->format_attribute('item_box_custom_border_color', 'item_box_custom_border_color', $attributes);
            $code .= $this->format_attribute('item_box_custom_bgr_color', 'item_box_custom_bgr_color', $attributes);
            $code .= $this->format_attribute('item_box_custom_bgr_pattern', 'item_box_custom_bgr_pattern', $attributes);

            $code .= ']';
            $code .= '[/otw_shortcode_testimonialsslider]';
        }


        return $code;
    }

    public function build_shortcode_editor_custom_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }

        $html .= $this->_generatePicker('item_box_custom_border_color', 'Box Border Color Custom', 'Choose a custom box border color.', $source);
        $html .= $this->_generatePicker('item_box_custom_bgr_color', 'Box Background Color Custom', 'Choose a custom box background color.', $source);
        $html .= $this->_generateUploader('item_box_custom_bgr_pattern', 'Box Background Pattern URL', 'URL to a custom box background pattern. ', $source);
        $html .= $this->_generateText('custom_class', 'CSS Class', 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..', $source);
        return $html;
    }

    public function build_shortcode_editor_options() {
        $html = '';

        $source = array();
        if (isset($_POST['shortcode_object'])) {
            $source = $_POST['shortcode_object'];
        }
        //Get default value for items in init time
        $total_elements = $this->settings['default_num_items'];
        //check for set items
        if (isset($source['otw-shortcode-element-num_items'])) {
            $total_elements = $source['otw-shortcode-element-num_items'];
        }
        $html .= $this->_generateSelect('num_items', 'Number of Itmes', 'Select number of items.', $source, 'num_items', 'default_num_items', 1); //$this->format_attribute('num_items', 'num_items', $attributes);
        $html .= $this->_generateSelect('auto_scolling', 'Enable Auto Scroll', 'Enables auto scroll.', $source, 'auto_scolling', 'default_auto_scolling'); //$this->format_attribute('num_items', 'num_items', $attributes);
        $html .= $this->_generateSelect('show_navigations', 'Show Navigation', 'Display navigation arrows.', $source, 'show_navigations', 'default_show_navigations'); //$this->format_attribute('num_items', 'num_items', $attributes);
        $html .= $this->_generateSelect('item_box_brd_style', 'Box Border Style', 'Choose box border style.', $source, 'box_brd_style', 'default_box_brd_style');
        $html .= $this->_generateSelect('item_box_brd_type', 'Box Border Type', 'Choose box border type.', $source, 'box_brd_type', 'default_box_brd_type');
        $html .= $this->_generateSelect('item_box_brd_color', 'Box Border Color', 'Choose box border color.', $source, 'box_brd_color', 'default_box_brd_color');
//        $html .= $this->_generateSelect('item_box_shadow', 'Box Shadow', 'Choose box shadow.', $source, 'box_shadow', 'default_box_shadow');
        $html .= $this->_generateSelect('item_box_rounded_corners', 'Box Rounded Corners', 'Choose box rounded corners.', $source, 'box_rounded_corners', 'default_box_rounded_corners');
        $html .= $this->_generateSelect('item_box_bgr', 'Box Background Color', 'Choose box background color.', $source, 'box_bgr', 'default_box_bgr');
        $html .= $this->_generateSelect('item_box_bgr_pattern', 'Box Background Pattern', 'Choose box background pattern.', $source, 'box_bgr_pattern', 'default_box_bgr_pattern');
        for ($ni = 1; $ni <= $total_elements; $ni++) {
            $html .= '<div class="otw-form-control" >'
                    . '<h4> Testimonial ' . $ni
                    . '<div class="otw_separator"> </div></div>';
            $html .= $this->_generateTextArea('item_' . $ni . '_content', 'Content', 'The content text. HTML is allowed.', $source);
            $html .= $this->_generateText('item_' . $ni . '_name', 'Person Name', 'Enter person name.', $source);
            $html .= $this->_generateText('item_' . $ni . '_position', 'Person Position', 'Enter person positon.', $source);
            $html .= $this->_generateText('item_' . $ni . '_company', 'Company Name', 'Enter company name.', $source);
            $html .= $this->_generateText('item_' . $ni . '_website', 'Company Website URL', 'Enter company website URL.', $source);
            $html .= $this->_generateUploader('item_' . $ni . '_image', 'Image', 'Upload an image.', $source);
//            $html .= $this->_generateSelect('item_' . $ni . '_box_brd_width', 'Box Border Width', 'Choose box border width.', $source, 'box_brd_width', 'default_box_brd_width');
        }
        return $html;
    }

    public function display_shortcode($attributes, $content) {

        $html .= '<div class="' . $this->format_attribute('', 'custom_class', $attributes) . ' otw-b-carousel otw-b-testimonials-slider"  data-nav="' . $this->format_attribute('', 'show_navigations', $attributes) . '" data-autoloop="' . $this->format_attribute('', 'auto_scolling', $attributes) . '" >';
        $total_elements = $this->format_attribute('', 'num_items', $attributes);
        for ($ni = 1; $ni <= $total_elements; $ni++) {

            $html .= '<div class="otw-b-testimonials-slider-item">';
            $class_container_content = 'otw-b-testimonials-content';
//            $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_' . $ni . '_box_brd_width', $attributes));

            if (strlen($this->format_attribute('', 'item_box_brd_type', $attributes)) > 0 && strlen($this->format_attribute('', 'item_box_brd_style', $attributes)) > 0) {
                $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_brd_style', $attributes));
                $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_brd_type', $attributes));
            }
            $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_brd_color', $attributes));
//            $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_shadow', $attributes));
            $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_rounded_corners', $attributes));
            $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_bgr', $attributes));
            $class_container_content = $this->append_attribute($class_container_content, $this->format_attribute('', 'item_box_bgr_pattern', $attributes));

            //custom styles for each one slides
            $style_master = '';
            if (strlen($this->format_attribute('', 'item_box_custom_border_color', $attributes)) > 0) {
                $style_master .= $this->append_attribute($style_master, 'border-color: ' . $this->format_attribute('', 'item_box_custom_border_color', $attributes) . '!important;');
            }
            if (strlen($this->format_attribute('', 'item_box_custom_bgr_color', $attributes)) > 0) {
                $style_master .= $this->append_attribute($style_master, 'background-color: ' . $this->format_attribute('', 'item_box_custom_bgr_color', $attributes) . '!important;');
            }
            if (strlen($this->format_attribute('', 'item_box_custom_bgr_pattern', $attributes)) > 0) {
                $style_master .= $this->append_attribute($style_master, 'background-image: url(' . $this->format_attribute('', 'item_box_custom_bgr_pattern', $attributes) . ')!important;');
            }

            $html .= '<div style="' . $style_master . '" class="' . $class_container_content . '">';
            $html .= '<p>' . otw_htmlentities_decode(stripslashes($this->format_attribute('', 'item_' . $ni . '_content', $attributes))) . '</p>';
            $html .= '</div>';

            $html .= '<div class="otw-b-testimonials-avatar">';
            $image = $this->format_attribute('', 'item_' . $ni . '_image', $attributes);
            if (!empty($image) && file_get_contents($image) != false) {
                $html .= '<img src="' . $image . '" alt="">';
            }

            $html .= '<p>' . $this->format_attribute('', 'item_' . $ni . '_name', $attributes);
            $html .= '<br> ';
            $html .= $this->format_attribute('', 'item_' . $ni . '_position', $attributes);

            if (strlen($this->format_attribute('', 'item_' . $ni . '_position', $attributes)) > 0 && strlen($this->format_attribute('', 'item_' . $ni . '_company', $attributes)) > 0) {
                $html .= ' - ';
            }
            if (strlen($this->format_attribute('', 'item_' . $ni . '_website', $attributes)) > 0) {
                $html .= '<a href="' . $this->format_attribute('', 'item_' . $ni . '_website', $attributes) . '">' . $this->format_attribute('', 'item_' . $ni . '_company', $attributes) . '</a>';
            } else {
                $html .= $this->format_attribute('', 'item_' . $ni . '_company', $attributes);
            }
            $html .= '</p>';
            $html .= ' </div>';
            $html .= '</div>';
        }
        $html .= '</div>';
        return $this->format_shortcode_output($html);
    }

}
