<?php
class OTW_Shortcode_Sortable_Table extends OTW_Shortcodes{
	
	/**
	 *  Numbers
	 *
	 *  @var array
	 */
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'all', 100 );
		$this->add_external_lib( 'css', 'footable-0.1.css', $this->component_url.'css/footable-0.1.css', 'all', 101 );
		$this->add_external_lib( 'css', 'footable.sortable-0.1.css', $this->component_url.'css/footable.sortable-0.1.css', 'all', 102 );
		
		$this->add_external_lib( 'js', 'footable.js', $this->component_url.'js/footable-0.1.js', 'all', 10, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'footable.sortable.js', $this->component_url.'js/footable.sortable.js', 'all', 11, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode-core', $this->component_url.'js/otw_shortcode_core.js', 'all', 99, array( 'jquery' ) );
		$this->add_external_lib( 'js', 'otw-shortcode', $this->component_url.'js/otw_shortcode.js', 'front', 100 );
		$this->add_external_lib( 'js', 'otw-shortcode_live_preview', $this->component_url.'js/otw_shortcode_live_preview.js', 'live_preview', 200 );

	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'cols' => array(
				'1'           => $this->get_label( '1' ),
				'2'           => $this->get_label( '2 (default)' ),
				'3'           => $this->get_label( '3' ),
				'4'           => $this->get_label( '4' ),
				'5'           => $this->get_label( '5' ),
				'6'           => $this->get_label( '6' ),
				'7'           => $this->get_label( '7' ),
				'8'           => $this->get_label( '8' ),
				'9'           => $this->get_label( '9' ),
				'10'          => $this->get_label( '10' )
			),
			'default_cols' => 2,
			
			'rows' => array(
				'1'           => $this->get_label( '1' ),
				'2'           => $this->get_label( '2 (default)' ),
				'3'           => $this->get_label( '3' ),
				'4'           => $this->get_label( '4' ),
				'5'           => $this->get_label( '5' ),
				'6'           => $this->get_label( '6' ),
				'7'           => $this->get_label( '7' ),
				'8'           => $this->get_label( '8' ),
				'9'           => $this->get_label( '9' ),
				'10'          => $this->get_label( '10' )
			),
			'default_rows' => 2,
			
			'title_color_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red-text'                   => $this->get_label( 'Red' ),
				'otw-orange-text'                => $this->get_label( 'Orange' ),
				'otw-green-text'                 => $this->get_label( 'Green' ),
				'otw-greenish-text'              => $this->get_label( 'Greenish' ),
				'otw-aqua-text'                  => $this->get_label( 'Aqua' ),
				'otw-blue-text'                  => $this->get_label( 'Blue' ),
				'otw-pink-text'                  => $this->get_label( 'Pink' ),
				'otw-silver-text'                => $this->get_label( 'Silver' ),
				'otw-brown-text'                 => $this->get_label( 'Brown' ),
				'otw-black-text'                 => $this->get_label( 'Black' )
			),
			'default_title_color_class' => '',
			
			'title_bgcolor_classes' => array(
				
				''                      => $this->get_label( 'none (Default)' ),
				'otw-red'                   => $this->get_label( 'Red' ),
				'otw-orange'                => $this->get_label( 'Orange' ),
				'otw-green'                 => $this->get_label( 'Green' ),
				'otw-greenish'              => $this->get_label( 'Greenish' ),
				'otw-aqua'                  => $this->get_label( 'Aqua' ),
				'otw-blue'                  => $this->get_label( 'Blue' ),
				'otw-pink'                  => $this->get_label( 'Pink' ),
				'otw-silver'                => $this->get_label( 'Silver' ),
				'otw-brown'                 => $this->get_label( 'Brown' ),
				'otw-black'                 => $this->get_label( 'Black' )
			),
			'default_title_bgcolor_class' => '',
			
			'title_pattern_classes' => array(
				''               => $this->get_label( 'none (default)' ),
				'otw-pattern-1'      => $this->get_label( 'pattern 1' ),
				'otw-pattern-2'      => $this->get_label( 'pattern 2' ),
				'otw-pattern-3'      => $this->get_label( 'pattern 3' ),
				'otw-pattern-4'      => $this->get_label( 'pattern 4' ),
				'otw-pattern-5'      => $this->get_label( 'pattern 5' )
			),
			'default_title_pattern_class' => '',

		);
		
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-cols', 'label' => $this->get_label( 'Number of Columns' ), 'description' => $this->get_label( 'Choose the number of columns.' ), 'parse' => $source, 'options' => $this->settings['cols'], 'value' => $this->settings['default_cols'], 'data-reload' => '1' ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-rows', 'label' => $this->get_label( 'Number of Rows' ), 'description' => $this->get_label( 'Choose the number of rows.' ), 'parse' => $source, 'options' => $this->settings['rows'], 'value' => $this->settings['default_rows'], 'data-reload' => '1' ) );
		
		$html .= '<div class="otw_separator"> </div>';
		
		$total_rows = $this->settings['default_rows'];
		
		if( isset( $source['otw-shortcode-element-rows'] ) ){
			$total_rows = $source['otw-shortcode-element-rows'];
		}
		
		$total_cols = $this->settings['default_cols'];
		
		if( isset( $source['otw-shortcode-element-cols'] ) ){
			$total_cols = $source['otw-shortcode-element-cols'];
		}
		
		for( $cC = 1; $cC <= $total_cols; $cC++ ){
		
			$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-col_'.$cC.'_title', 'label' => $this->get_label( 'Column '.$cC.' Title' ), 'description' => $this->get_label( 'Enter title.' ), 'parse' => $source )  );
			
			for( $cR = 1; $cR <= $total_rows; $cR++ ){
				$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-row_'.$cR.'_col_'.$cC.'_text', 'label' => $this->get_label( 'Column '.$cC.' Row '.$cR.' Text' ), 'description' => $this->get_label( 'Enter the texts for this column. HTML is enabled.' ), 'parse' => $source )  );
			}
			
			$html .= '<div class="otw_separator"> </div>';
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_color_class', 'label' => $this->get_label( 'Titles Color' ), 'description' => $this->get_label( 'Choose a color for the titles.' ), 'parse' => $source, 'options' => $this->settings['title_color_classes'], 'value' => $this->settings['default_title_color_class'] )  );
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_bgcolor_class', 'label' => $this->get_label( 'Titles Background Color' ), 'description' => $this->get_label( 'Choose background color for all titles.' ), 'parse' => $source, 'options' => $this->settings['title_bgcolor_classes'], 'value' => $this->settings['default_title_bgcolor_class'] )  );
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_pattern_class', 'label' => $this->get_label( 'Titles Background Pattern' ), 'description' => $this->get_label( 'Choose background pattern for all titles.' ), 'parse' => $source, 'options' => $this->settings['title_pattern_classes'], 'value' => $this->settings['default_title_pattern_class'] )  );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-title_color', 'label' => $this->get_label( 'Titles Color Custom' ), 'description' => $this->get_label( 'Choose custom color for the titles.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-title_bgcolor', 'label' => $this->get_label( 'Titles Background Color Custom' ), 'description' => $this->get_label( 'Choose custom background color for all titles.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::uploader( array( 'id' => 'otw-shortcode-element-title_pattern', 'label' => $this->get_label( 'Titles Background Pattern Custom' ), 'description' => $this->get_label( 'URL to a custom titles background pattern.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_sortable_table';
			
			$code .= $this->format_attribute( 'cols', 'cols', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'rows', 'rows', $attributes, false, '', true );
			
			$rows = $this->format_attribute( '', 'rows', $attributes );
			
			$cols = $this->format_attribute( '', 'cols', $attributes );
			
			for( $cC = 1; $cC <= $cols; $cC++ ){
				
				$code .= $this->format_attribute( 'col_'.$cC.'_title', 'col_'.$cC.'_title', $attributes, false, '', true );
				
				for( $cR = 1; $cR <= $rows; $cR++ ){
					$code .= $this->format_attribute( 'row_'.$cR.'_col_'.$cC.'_text', 'row_'.$cR.'_col_'.$cC.'_text', $attributes, false, '', true );
				}
			}
			
			$code .= $this->format_attribute( 'title_color_class', 'title_color_class', $attributes, false, '', true );
			$code .= $this->format_attribute( 'title_bgcolor_class', 'title_bgcolor_class', $attributes, false, '', true );
			$code .= $this->format_attribute( 'title_pattern_class', 'title_pattern_class', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_color', 'title_color', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_bgcolor', 'title_bgcolor', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'title_pattern', 'title_pattern', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_sortable_table]';
		
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<table';
		
		/*class attributes*/
		$class = 'otw-table footable otw-sortable-table';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$rows = intval( $this->format_attribute( '', 'rows', $attributes, false, '' ) );
		$cols = intval( $this->format_attribute( '', 'cols', $attributes, false, '' ) );
		
		$html .= "\n<thead>";
		
		$html .= '<tr>';
		
		for( $cC = 1; $cC <= $cols; $cC++ ){
			
			$cell_class = '';
			$cell_style = '';
			
			$cell_class .= $this->format_attribute( '', 'title_color_class', $attributes, false, $cell_class );
			$cell_class .= $this->format_attribute( '', 'title_bgcolor_class', $attributes, false, $cell_class );
			$cell_class .= $this->format_attribute( '', 'title_pattern_class', $attributes, false, $cell_class );
			
			if( $value = $this->format_attribute( '', 'title_color', $attributes, false, '' ) ){
				$cell_style = $this->append_attribute( $cell_style, 'color: '.$value.';' );
			}
			
			if( $value = $this->format_attribute( '', 'title_bgcolor', $attributes, false, '' ) ){
				$cell_style = $this->append_attribute( $cell_style, 'background-color: '.$value.';' );
			}
			
			if( $value = $this->format_attribute( '', 'title_pattern', $attributes, false, '' ) ){
				$cell_style = $this->append_attribute( $cell_style, 'background-image: url(\''.$value.'\');' );
			}
			
			if( strlen( $cell_class ) ){
				$cell_class = ' class="'.$cell_class.'"';
			}
			if( strlen( $cell_style ) ){
				$cell_style = ' style="'.$cell_style.'"';
			}
			
			$html .= '<th'.$cell_class.''.$cell_style.'>'.$this->format_attribute( '', 'col_'.$cC.'_title', $attributes, false, '' ).'</th>';
			
		}
		$html .= '</tr>';
		
		$html .= '</thead>';
		
		$html .= "\n<tbody>";
		
		for( $cR = 1; $cR <= $rows; $cR++ ){
			
			$html .= "\n<tr>";
			
			for( $cC = 1; $cC <= $cols; $cC++ ){
				$html .= '<td>'.otw_htmlentities_decode( $this->format_attribute( '', 'row_'.$cR.'_col_'.$cC.'_text', $attributes, false, '' ) ).'</td>';
			}
			
			$html .= '</tr>';
		}
		
		$html .= '</tbody>';
		
		$html .= '</table>';
		
		return $this->format_shortcode_output( $html );
	}
}
?>
