<?php
class OTW_Shortcode_Social_Tweet extends OTW_Shortcodes{
	
	public function __construct(){
		
		$this->has_custom_options = true;
		
		$this->preview = 'div';
		
		parent::__construct();
	}
	/**
	 * register external libs
	 */
	public function register_external_libs(){
	
		$this->add_external_lib( 'css', 'otw-shortcode', $this->component_url.'css/otw_shortcode.css', 'front', 100 );
	}
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array(
			
			'style' => array(
					''          => $this->get_label( 'none' ),
					'vertical'    => $this->get_label( 'Vertical(default)' ),
					'horizontal'   => $this->get_label( 'horizontal' )
				),
			'default_style' => 'vertical',
			
			'float' => array(
					''          => $this->get_label( 'none(default)' ),
					'left'    => $this->get_label( 'Left' ),
					'right'   => $this->get_label( 'Right' )
				),
			'default_float' => '',
			
			'lang' => array(
					''          => $this->get_label( 'english (Default)' ),
					'fr'    => $this->get_label( 'fr' ),
					'de'   => $this->get_label( 'de' ),
					'es'   => $this->get_label( 'es' ),
					'js'   => $this->get_label( 'js' )
				),
			'default_lang' => '',
			
			'post_url' => array(
					'no'     => $this->get_label( 'false(default)' ),
					'yes'    => $this->get_label( 'true' )
				),
			'default_post_url' => ''
		);
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-style', 'label' => $this->get_label( 'Style' ), 'description' => $this->get_label( 'Values: vertical, horizontal, none (default: vertical).' ), 'parse' => $source, 'options' => $this->settings['style'], 'value' => $this->settings['default_style'] ) );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-url', 'label' => $this->get_label( 'URL' ), 'description' => $this->get_label( 'Optional. Specify URL directly.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-source', 'label' => $this->get_label( 'Source' ), 'description' => $this->get_label( 'Optional. Username to mention in tweet.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-related', 'label' => $this->get_label( 'Related' ), 'description' => $this->get_label( 'Optional. Related account.' ), 'parse' => $source )  );
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-text', 'label' => $this->get_label( 'Text' ), 'description' => $this->get_label( 'Optional tweet text (default: title of page).' ), 'parse' => $source )  );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-float', 'label' => $this->get_label( 'Float' ), 'description' => $this->get_label( 'Optionally float your icon to the left or right.' ), 'parse' => $source, 'options' => $this->settings['float'], 'value' => $this->settings['default_float'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-lang', 'label' => $this->get_label( 'Lang' ), 'description' => $this->get_label( 'Values: fr, de, es, js (default: english).' ), 'parse' => $source, 'options' => $this->settings['lang'], 'value' => $this->settings['default_lang'] ) );
		
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-post_url', 'label' => $this->get_label( 'Use Post URL' ), 'description' => $this->get_label( 'Values: true, false (default: false).' ), 'parse' => $source, 'options' => $this->settings['post_url'], 'value' => $this->settings['default_post_url'] ) );
		
		return $html;
	}
	
	/**
	 * Shortcode admin interface custom options
	 */
	public function build_shortcode_editor_custom_options(){
		
		$html = '';
		
		$source = array();
		if( isset( $_POST['shortcode_object'] ) ){
			$source = $_POST['shortcode_object'];
		}
		
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label( 'CSS Class' ), 'description' => $this->get_label( 'If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..' ), 'parse' => $source )  );
		
		return $html;
	}
	
	/** build shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_social_tweet';
			
			$code .= $this->format_attribute( 'style', 'style', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'url', 'url', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'source', 'source', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'related', 'related', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'text', 'text', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'float', 'float', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'lang', 'lang', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'post_url', 'post_url', $attributes, false, '', true );
			
			$code .= $this->format_attribute( 'css_class', 'css_class', $attributes, false, '', true  );
			
			$code .= ']';
			
			$code .= '[/otw_shortcode_social_tweet]';
		}
		
		return $code;

	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-sc-twitter';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.$class.'"';
		}
		/*end class attributes*/
		
		/*style attribute*/
		$style = '';
		
		if( $float = $this->format_attribute( '', 'float', $attributes, false, '' ) ){
		
			$style = $this->append_attribute( $style, 'float: '.$float.';' );
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.$style.'"';
		}
		
		$html .= '>';
		
		$html .= '<a href="http://twitter.com/share" class="twitter-share-button"';
		
		if( $style = $this->format_attribute( '', 'style', $attributes, false, '' ) ){
			$html .= ' data-count="'.$style.'"';
		}
		
		if( $url = $this->format_attribute( '', 'url', $attributes, false, '' ) ){
			$html .= ' data-url="'.$url.'"';
		}
		
		if( $source = $this->format_attribute( '', 'source', $attributes, false, '' ) ){
			$html .= ' data-via="'.$source.'"';
		}
		
		if( $text = $this->format_attribute( '', 'text', $attributes, false, '' ) ){
			$html .= ' data-text="'.$text.'"';
		}
		
		if( $related = $this->format_attribute( '', 'related', $attributes, false, '' ) ){
			$html .= ' data-related="'.$related.'"';
		}
		
		if( $lang = $this->format_attribute( '', 'lang', $attributes, false, '' ) ){
			$html .= ' data-lang="'.$lang.'"';
		}
		
		if( $post_url = $this->format_attribute( '', 'post_url', $attributes, false, '' ) ){
			
			if( $post_url == 'yes' ){
				global $post;
				
				if( isset( $post->ID ) ){
					$html .= ' data-url="'.get_permalink( $post->ID ).'"';
				}
			}
		}
		
		$html .= '>'.$this->get_label('Tweet');
		
		$html .= '</a>';
		
		$html .= '<script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>';
		
		$html .= '</div>';
		
		return $this->format_shortcode_output( $html );
	}
}
